/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.javascript.flex.FlexPropertiesSupport;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlexPropertyReferenceProvider
extends PsiReferenceProvider {
    private static final Set<String> ourMethodsWithPropertyReferences = new THashSet(Arrays.asList("findResourceBundleWithResource", "getString", "getObject", "getClass", "getStringArray", "getNumber", "getInt", "getUint", "getBoolean"));
    private static final FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> ourPropertyInfoProvider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public String getBundleName(JSLiteralExpressionImpl element) {
            return null;
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return false;
        }
    };
    private static final FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> ourSoftPropertyInfoProvider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public String getBundleName(JSLiteralExpressionImpl element) {
            return null;
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return true;
        }
    };
    private static final FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl> ourBundleInfoProvider = new FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return false;
        }
    };
    private static final FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl> ourSoftBundleInfoProvider = new FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return true;
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/FlexPropertyReferenceProvider", "getReferencesByElement"));
        }
        PsiElement parent = element.getParent();
        JSReferenceExpression invokedMethod = JSUtils.getMethodNameIfInsideCall((PsiElement)parent);
        ArrayList result = new ArrayList();
        if (invokedMethod != null) {
            JSExpression qualifier;
            boolean justResourceBundleRef = false;
            String invokedMethodName = invokedMethod.getReferencedName();
            if ((ourMethodsWithPropertyReferences.contains(invokedMethodName) || (justResourceBundleRef = "getResourceBundle".equals(invokedMethodName))) && ((qualifier = invokedMethod.getQualifier()) instanceof JSReferenceExpression || qualifier instanceof JSCallExpression && ((JSCallExpression)qualifier).getMethodExpression() instanceof JSReferenceExpression)) {
                PsiElement parentClass;
                PsiElement resolved;
                JSExpression[] args = ((JSArgumentList)parent).getArguments();
                boolean propertyRef = false;
                boolean bundleRef = false;
                if (justResourceBundleRef) {
                    bundleRef = args.length > 1 && args[1] == element;
                } else {
                    propertyRef = args.length > 1 && args[1] == element;
                    boolean bl = bundleRef = args.length > 0 && args[0] == element;
                    if (bundleRef && args.length == 1) {
                        bundleRef = false;
                        propertyRef = true;
                    }
                }
                boolean isSoft = true;
                if ((propertyRef || bundleRef) && (resolved = invokedMethod.resolve()) instanceof JSFunction && (parentClass = JSResolveUtil.findParent((PsiElement)resolved)) instanceof JSClass) {
                    String name = ((JSClass)parentClass).getName();
                    boolean bl = isSoft = name == null || name.indexOf("ResourceManager") == -1 && name.indexOf("ResourceBundle") == -1;
                }
                if (propertyRef) {
                    FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> provider;
                    FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> propertyReferenceInfoProvider = provider = isSoft ? ourSoftPropertyInfoProvider : ourPropertyInfoProvider;
                    if (args.length > 1 && !isSoft && args[0] instanceof JSLiteralExpression) {
                        final String myText = args[0].getText();
                        provider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl>(){

                            @Override
                            public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
                                return FlexPropertyReferenceProvider.getValueRange(element);
                            }

                            @Override
                            public String getBundleName(JSLiteralExpressionImpl element) {
                                return StringUtil.stripQuotesAroundValue((String)myText);
                            }

                            @Override
                            public boolean isSoft(JSLiteralExpressionImpl element) {
                                return false;
                            }
                        };
                    }
                    Collections.addAll(result, FlexPropertiesSupport.getPropertyReferences((JSLiteralExpressionImpl)element, provider));
                } else if (bundleRef) {
                    PsiReference[] reference = FlexPropertiesSupport.getResourceBundleReference((JSLiteralExpressionImpl)element, isSoft ? ourSoftBundleInfoProvider : ourBundleInfoProvider);
                    Collections.addAll(result, reference);
                }
            }
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexPropertyReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static TextRange getValueRange(JSLiteralExpressionImpl element) {
        int textLength = element.getTextLength();
        if (textLength < 2) {
            return null;
        }
        return new TextRange(1, textLength - 1);
    }
}

