/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javascript.flex.css.FlexCSSDialect;
import com.intellij.javascript.flex.css.FlexCssPropertyDescriptor;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.javascript.flex.css.FlexCssValueValidator;
import com.intellij.javascript.flex.css.FlexStyleIndex;
import com.intellij.javascript.flex.css.FlexStyleIndexInfo;
import com.intellij.javascript.flex.css.SwitchToCssDialectQuickFix;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptorStub;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.psi.css.descriptor.value.CssNullValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCssElementDescriptorProvider
extends CssElementDescriptorProvider {
    private final FlexCssValueValidator FLEX_CSS_VALUE_VALIDATOR;
    private final Map<String, CssFunctionDescriptor> myFunctionDescriptors;

    public FlexCssElementDescriptorProvider(@NotNull CssElementDescriptorFactory2 descriptorFactory) {
        if (descriptorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFactory", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "<init>"));
        }
        this.FLEX_CSS_VALUE_VALIDATOR = new FlexCssValueValidator(this);
        this.myFunctionDescriptors = ContainerUtil.newHashMap();
        CssStringValue singleStringValue = descriptorFactory.createStringValueDescriptor(null, 1, 1, null);
        CssGroupValue embedFunctionValue = descriptorFactory.createGroupValue(CssGroupValue.Type.OR, 1, 1, null, null);
        CssTextValue commaSeparator = descriptorFactory.createTextValueDescriptor(",", 1, 1, null);
        CssGroupValue attributes = descriptorFactory.createGroupValue(CssGroupValue.Type.AND, 1, 1, (CssValueDescriptor)embedFunctionValue, (CssValueDescriptor)commaSeparator);
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("source", true, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("mimeType", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createBooleanAttributeValueDescriptor("smoothing", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createBooleanAttributeValueDescriptor("compression", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("quality", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("scaleGridTop", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("scaleGridBottom", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("scaleGridLeft", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("scaleGridRight", false, descriptorFactory, attributes));
        attributes.addChild((CssValueDescriptor)FlexCssElementDescriptorProvider.createAttributeValueDescriptor("symbol", false, descriptorFactory, attributes));
        embedFunctionValue.addChild((CssValueDescriptor)descriptorFactory.createStringValueDescriptor(null, 1, 1, (CssValueDescriptor)embedFunctionValue));
        embedFunctionValue.addChild((CssValueDescriptor)attributes);
        this.myFunctionDescriptors.put("Embed", (CssFunctionDescriptor)new CssFunctionDescriptorStub("Embed", (CssValueDescriptor)embedFunctionValue));
        this.myFunctionDescriptors.put("ClassReference", (CssFunctionDescriptor)new CssFunctionDescriptorStub("ClassReference", (CssValueDescriptor)singleStringValue));
        this.myFunctionDescriptors.put("PropertyReference", (CssFunctionDescriptor)new CssFunctionDescriptorStub("PropertyReference", (CssValueDescriptor)singleStringValue));
    }

    private static CssGroupValue createAttributeValueDescriptor(@NotNull String attributeName, boolean required, @NotNull CssElementDescriptorFactory2 descriptorFactory, @NotNull CssGroupValue parent) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "createAttributeValueDescriptor"));
        }
        if (descriptorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFactory", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "createAttributeValueDescriptor"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "createAttributeValueDescriptor"));
        }
        CssGroupValue attributeValue = descriptorFactory.createGroupValue(CssGroupValue.Type.ALL, required ? 1 : 0, 1, (CssValueDescriptor)parent, null);
        attributeValue.addChild((CssValueDescriptor)descriptorFactory.createNameValueDescriptor(attributeName, attributeName, 1, 1, (CssValueDescriptor)attributeValue));
        attributeValue.addChild((CssValueDescriptor)descriptorFactory.createTextValueDescriptor("=", 1, 1, (CssValueDescriptor)attributeValue));
        attributeValue.addChild((CssValueDescriptor)descriptorFactory.createStringValueDescriptor(null, 1, 1, (CssValueDescriptor)attributeValue));
        return attributeValue;
    }

    private static CssGroupValue createBooleanAttributeValueDescriptor(@NotNull String attributeName, boolean required, @NotNull CssElementDescriptorFactory2 descriptorFactory, @NotNull CssGroupValue parent) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "createBooleanAttributeValueDescriptor"));
        }
        if (descriptorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFactory", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "createBooleanAttributeValueDescriptor"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "createBooleanAttributeValueDescriptor"));
        }
        CssGroupValue attributeValue = descriptorFactory.createGroupValue(CssGroupValue.Type.ALL, required ? 1 : 0, 1, (CssValueDescriptor)parent, null);
        attributeValue.addChild((CssValueDescriptor)descriptorFactory.createNameValueDescriptor(attributeName, attributeName, 1, 1, (CssValueDescriptor)attributeValue));
        attributeValue.addChild((CssValueDescriptor)descriptorFactory.createTextValueDescriptor("=", 1, 1, (CssValueDescriptor)attributeValue));
        CssGroupValue booleanValue = descriptorFactory.createGroupValue(CssGroupValue.Type.OR, 1, 1, (CssValueDescriptor)attributeValue, null);
        booleanValue.addChild((CssValueDescriptor)descriptorFactory.createStringValueDescriptor("true", 1, 1, (CssValueDescriptor)booleanValue));
        booleanValue.addChild((CssValueDescriptor)descriptorFactory.createStringValueDescriptor("false", 1, 1, (CssValueDescriptor)booleanValue));
        attributeValue.addChild((CssValueDescriptor)booleanValue);
        return attributeValue;
    }

    public boolean isMyContext(@Nullable PsiElement context) {
        Language lang;
        FileType type;
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        if (HtmlUtil.hasHtml((PsiFile)file)) {
            return false;
        }
        VirtualFile vFile = file.getOriginalFile().getVirtualFile();
        if (vFile != null && (type = vFile.getFileType()) instanceof LanguageFileType && (lang = ((LanguageFileType)type).getLanguage()).isKindOf((Language)CSSLanguage.INSTANCE) && !lang.is((Language)CSSLanguage.INSTANCE)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null && (file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile(context)) != null) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        }
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return false;
        }
        if (vFile != null) {
            CssDialect dialect = (CssDialect)CssDialectMappings.getInstance((Project)context.getProject()).getMapping(vFile);
            return dialect == null || dialect == FlexCSSDialect.getInstance();
        }
        return true;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        FlexCssValueValidator flexCssValueValidator = this.FLEX_CSS_VALUE_VALIDATOR;
        if (flexCssValueValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getValueValidator"));
        }
        return flexCssValueValidator;
    }

    public boolean shouldAskOtherProviders(PsiElement context) {
        return false;
    }

    @Nullable
    private static String findJsClassOrFile(@NotNull JSClass root, Set<JSClass> visited, Set<String> possibleQNames) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findJsClassOrFile"));
        }
        if (!visited.add(root)) {
            return null;
        }
        String qName = root.getQualifiedName();
        if (qName != null && possibleQNames.contains(qName)) {
            return qName;
        }
        LinkedHashSet includes = ContainerUtil.newLinkedHashSet();
        FlexCssUtil.collectAllIncludes((PsiElement)root, includes);
        String fileName = null;
        for (String include : includes) {
            if (!possibleQNames.contains(include)) continue;
            fileName = include;
        }
        if (fileName != null) {
            return fileName;
        }
        for (JSClass jsSuper : root.getSupers()) {
            String result = FlexCssElementDescriptorProvider.findJsClassOrFile(jsSuper, visited, possibleQNames);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static List<FlexStyleIndexInfo> filter(Collection<? extends Collection<FlexStyleIndexInfo>> collections, List<CssSimpleSelector> selectors, @NotNull GlobalSearchScope scope, @Nullable Module module) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "filter"));
        }
        LinkedHashSet allNames = ContainerUtil.newLinkedHashSet();
        for (Collection<FlexStyleIndexInfo> collection : collections) {
            for (FlexStyleIndexInfo flexStyleIndexInfo : collection) {
                allNames.add(flexStyleIndexInfo.getClassOrFileName());
            }
        }
        LinkedHashSet namesFromSelectors = null;
        if (selectors.size() > 0 && !FlexCssElementDescriptorProvider.containsGlobalSelectors(selectors)) {
            namesFromSelectors = ContainerUtil.newLinkedHashSet();
            for (CssSimpleSelector selector : selectors) {
                JSClass jSClass;
                if (module != null && (jSClass = FlexCssElementDescriptorProvider.getClassFromMxmlDescriptor(selector, module)) != null) {
                    String classOrFileName = FlexCssElementDescriptorProvider.findJsClassOrFile(jSClass, ContainerUtil.newLinkedHashSet(), allNames);
                    if (classOrFileName == null) continue;
                    namesFromSelectors.add(classOrFileName);
                    continue;
                }
                String string = selector.getElementName();
                Collection elements = JSResolveUtil.findElementsByName((String)string, (Project)scope.getProject(), (GlobalSearchScope)scope);
                for (PsiElement element : elements) {
                    String classOrFileName;
                    if (!(element instanceof JSClass) || (classOrFileName = FlexCssElementDescriptorProvider.findJsClassOrFile((JSClass)element, ContainerUtil.newLinkedHashSet(), allNames)) == null) continue;
                    namesFromSelectors.add(classOrFileName);
                }
            }
        }
        ArrayList<FlexStyleIndexInfo> arrayList = new ArrayList<FlexStyleIndexInfo>();
        for (Collection collection : collections) {
            for (FlexStyleIndexInfo info : collection) {
                if (namesFromSelectors != null && !namesFromSelectors.contains(info.getClassOrFileName())) continue;
                arrayList.add(info);
            }
        }
        return arrayList;
    }

    public PsiElement getDocumentationElementForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        Collection<JSQualifiedNamedElement> classes;
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDocumentationElementForSelector"));
        }
        if (context != null && (classes = FlexCssElementDescriptorProvider.getClasses(selectorName, context)) != null) {
            for (JSQualifiedNamedElement c : classes) {
                if (!(c instanceof JSClass)) continue;
                return c;
            }
        }
        return null;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        List<CssPseudoSelectorDescriptorStub> list = Collections.singletonList(new CssPseudoSelectorDescriptorStub(name));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getNamedValueDescriptors"));
        }
        List<CssNullValue> list = Collections.singletonList(new CssNullValue(parent));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getNamedValueDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        if (context != null) {
            List<CssSimpleSelector> selectors;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            GlobalSearchScope scope = FlexCssUtil.getResolveScope(context);
            List lists = FileBasedIndex.getInstance().getValues(FlexStyleIndex.INDEX_ID, (Object)propertyName, scope);
            List<FlexStyleIndexInfo> infos = FlexCssElementDescriptorProvider.filter(lists, selectors = FlexCssElementDescriptorProvider.findSimpleSelectorsAbove(context), scope, module);
            if (infos.size() > 0) {
                List<FlexCssPropertyDescriptor> list = Collections.singletonList(new FlexCssPropertyDescriptor(infos));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findPropertyDescriptors"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findFunctionDescriptors"));
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myFunctionDescriptors.get(functionName));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findFunctionDescriptors"));
        }
        return list;
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "isPossibleSelector"));
        }
        if (selector.equals("global")) {
            return true;
        }
        GlobalSearchScope scope = FlexCssUtil.getResolveScope(context);
        Collection classes = JSResolveUtil.findElementsByName((String)selector, (Project)context.getProject(), (GlobalSearchScope)scope);
        for (JSQualifiedNamedElement c : classes) {
            if (!(c instanceof JSClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isPossiblePseudoSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "isPossiblePseudoSelector"));
        }
        return false;
    }

    private static boolean isInClassicForm(String propertyName) {
        return propertyName.indexOf(45) >= 0;
    }

    private static void fillPropertyDescriptorsDynamically(final @NotNull JSClass jsClass, Set<JSClass> visited, final Set<CssPropertyDescriptor> result) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "fillPropertyDescriptorsDynamically"));
        }
        if (!visited.add(jsClass)) {
            return;
        }
        FlexUtils.processMetaAttributesForClass((PsiElement)jsClass, new JSResolveUtil.MetaDataProcessor(){

            public boolean process(@NotNull JSAttribute jsAttribute) {
                if (jsAttribute == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider$1", "process"));
                }
                if ("Style".equals(jsAttribute.getName())) {
                    JSAttributeNameValuePair pair = jsAttribute.getValueByName("name");
                    String styleName = pair != null ? pair.getSimpleValue() : null;
                    String qualifiedName = jsClass.getQualifiedName();
                    if (styleName != null && qualifiedName != null) {
                        result.add(new FlexCssPropertyDescriptor(ContainerUtil.newLinkedHashSet((Object[])new FlexStyleIndexInfo[]{FlexStyleIndexInfo.create(qualifiedName, styleName, jsAttribute, true)})));
                    }
                }
                return true;
            }

            public boolean handleOtherElement(PsiElement el, PsiElement context, @Nullable Ref<PsiElement> continuePassElement) {
                return true;
            }
        });
        for (JSClass jsSuper : jsClass.getSupers()) {
            if (jsSuper == null) continue;
            FlexCssElementDescriptorProvider.fillPropertyDescriptorsDynamically(jsSuper, visited, result);
        }
    }

    @NotNull
    private static Collection<? extends CssPropertyDescriptor> getPropertyDescriptorsDynamically(@NotNull List<CssSimpleSelector> selectors, @NotNull Module module) {
        if (selectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectors", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getPropertyDescriptorsDynamically"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getPropertyDescriptorsDynamically"));
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        Project project = module.getProject();
        for (CssSimpleSelector selector : selectors) {
            JSClass jsClass = FlexCssElementDescriptorProvider.getClassFromMxmlDescriptor(selector, module);
            if (jsClass != null) {
                FlexCssElementDescriptorProvider.fillPropertyDescriptorsDynamically(jsClass, visited, result);
                continue;
            }
            String shortClassName = selector.getElementName();
            Collection candidates = JSResolveUtil.findElementsByName((String)shortClassName, (Project)project, (GlobalSearchScope)scope);
            for (JSQualifiedNamedElement candidate : candidates) {
                if (!(candidate instanceof JSClass)) continue;
                FlexCssElementDescriptorProvider.fillPropertyDescriptorsDynamically((JSClass)candidate, visited, result);
            }
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            CssPropertyDescriptor propertyDescriptor = (CssPropertyDescriptor)iterator.next();
            List values = fileBasedIndex.getValues(FlexStyleIndex.INDEX_ID, (Object)propertyDescriptor.getPropertyName(), scope);
            if (values.size() != 0) continue;
            iterator.remove();
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getPropertyDescriptorsDynamically"));
        }
        return linkedHashSet;
    }

    private static boolean containsGlobalSelectors(@NotNull List<CssSimpleSelector> selectors) {
        if (selectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectors", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "containsGlobalSelectors"));
        }
        for (CssSimpleSelector selector : selectors) {
            String elementName = selector.getElementName();
            if (!elementName.isEmpty() && !"global".equals(elementName) && !"*".equals(elementName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        if (context == null || DumbService.getInstance((Project)context.getProject()).isDumb()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getAllPropertyDescriptors"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        List<CssSimpleSelector> simpleSelectors = FlexCssElementDescriptorProvider.findSimpleSelectorsAbove(context);
        if (simpleSelectors.size() > 0 && !FlexCssElementDescriptorProvider.containsGlobalSelectors(simpleSelectors) && module != null) {
            Collection<? extends CssPropertyDescriptor> collection = FlexCssElementDescriptorProvider.getPropertyDescriptorsDynamically(simpleSelectors, module);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getAllPropertyDescriptors"));
            }
            return collection;
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        List keys = ContainerUtil.sorted((Collection)index.getAllKeys(FlexStyleIndex.INDEX_ID, context.getProject()));
        ArrayList<FlexCssPropertyDescriptor> result = new ArrayList<FlexCssPropertyDescriptor>();
        GlobalSearchScope scope = FlexCssUtil.getResolveScope(context);
        for (String key : keys) {
            if (FlexCssElementDescriptorProvider.isInClassicForm(key)) continue;
            for (Set infos : index.getValues(FlexStyleIndex.INDEX_ID, (Object)key, scope)) {
                result.add(new FlexCssPropertyDescriptor(infos));
            }
        }
        ArrayList<FlexCssPropertyDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getAllPropertyDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getSimpleSelectors"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getSimpleSelectors"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        CodeContext codeContext = CodeContext.getContext("http://www.adobe.com/2006/mxml", module);
        XmlElementDescriptor[] descriptors = codeContext.getDescriptorsWithAllowedDeclaration();
        String[] selectors = new String[descriptors.length + 1];
        selectors[0] = "global";
        int i = 1;
        for (XmlElementDescriptor descriptor : descriptors) {
            selectors[i++] = descriptor.getName();
        }
        if (selectors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getSimpleSelectors"));
        }
        return selectors;
    }

    @Nullable
    private static Collection<JSQualifiedNamedElement> getClasses(String className, PsiElement context) {
        if (context == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : context.getResolveScope();
        return JSResolveUtil.findElementsByName((String)className, (Project)context.getProject(), (GlobalSearchScope)scope);
    }

    @Nullable
    public static XmlElementDescriptor getTypeSelectorDescriptor(@NotNull CssSimpleSelector selector, @NotNull Module module) {
        CssNamespace namespace;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getTypeSelectorDescriptor"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getTypeSelectorDescriptor"));
        }
        CssStylesheet stylesheet = ((CssFile)selector.getContainingFile()).getStylesheet();
        CssNamespace cssNamespace = namespace = stylesheet != null ? stylesheet.getNamespace(selector.getNamespaceName()) : null;
        if (namespace != null && namespace.getUri() != null) {
            return CodeContext.getContext(namespace.getUri(), module).getElementDescriptor(selector.getElementName(), (XmlTag)null);
        }
        return null;
    }

    @Nullable
    private static JSClass getClassFromMxmlDescriptor(@NotNull CssSimpleSelector selector, @NotNull Module module) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getClassFromMxmlDescriptor"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getClassFromMxmlDescriptor"));
        }
        XmlElementDescriptor xmlElementDescriptor = FlexCssElementDescriptorProvider.getTypeSelectorDescriptor(selector, module);
        if (xmlElementDescriptor == null) {
            return null;
        }
        PsiElement declaration = xmlElementDescriptor.getDeclaration();
        return declaration instanceof JSClass ? (JSClass)declaration : null;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        JSClass jsClass;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)selector);
        if (module != null && (jsClass = FlexCssElementDescriptorProvider.getClassFromMxmlDescriptor(selector, module)) != null) {
            PsiElement[] psiElementArray = new PsiElement[]{jsClass};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = FlexCssElementDescriptorProvider.getDeclarationsForSimpleSelector(selector.getElementName(), (PsiElement)selector);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement getReferencedElement(@NotNull PsiElement element) {
        PsiFile file;
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getReferencedElement"));
        }
        if (element instanceof JSClassImpl) {
            PsiElement psiElement = element.getNavigationElement();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getReferencedElement"));
            }
            return psiElement;
        }
        if (element instanceof XmlBackedJSClassImpl && (parent = element.getParent()) != null && (file = parent.getContainingFile()) != null) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getReferencedElement"));
            }
            return psiFile;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getReferencedElement"));
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement[] getDeclarationsForSimpleSelector(@NotNull String className, @Nullable PsiElement context) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        Collection<JSQualifiedNamedElement> elements = FlexCssElementDescriptorProvider.getClasses(className, context);
        if (elements != null && elements.size() > 0) {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            LinkedHashSet qNames = ContainerUtil.newLinkedHashSet();
            for (JSQualifiedNamedElement c : elements) {
                String qName;
                if (!(c instanceof JSClass) || !qNames.add(qName = c.getQualifiedName())) continue;
                result.add(FlexCssElementDescriptorProvider.getReferencedElement((PsiElement)c));
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    public String generateDocForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "generateDocForSelector"));
        }
        PsiElement[] declarations = FlexCssElementDescriptorProvider.getDeclarationsForSimpleSelector(selectorName, context);
        JSClass[] classes = new JSClass[declarations.length];
        for (int i = 0; i < declarations.length; ++i) {
            PsiElement declaration = declarations[i];
            assert (declaration instanceof JSClass);
            classes[i] = (JSClass)declaration;
        }
        Arrays.sort(classes, (c1, c2) -> Comparing.compare((Comparable)((Object)c1.getQualifiedName()), (Comparable)((Object)c2.getQualifiedName())));
        StringBuilder builder = new StringBuilder();
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            DocumentationProvider provider;
            String docForDeclaration;
            JSClass jsClass = classes[i];
            PsiFile file = jsClass.getContainingFile();
            if (file == null || (docForDeclaration = (provider = DocumentationManager.getProviderFromElement((PsiElement)jsClass)).generateDoc((PsiElement)jsClass, (PsiElement)jsClass)) == null) continue;
            builder.append(docForDeclaration);
            if (i == n - 1) continue;
            builder.append("<br><br>\n\n");
        }
        return builder.toString();
    }

    @NotNull
    private static List<CssSimpleSelector> findSimpleSelectorsAbove(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findSimpleSelectorsAbove"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, CssRuleset.class);
        if (ruleset != null) {
            for (CssSelector selector : ruleset.getSelectors()) {
                CssSimpleSelector simpleSelector = null;
                for (PsiElement child : selector.getChildren()) {
                    if (!(child instanceof CssSimpleSelector)) continue;
                    simpleSelector = (CssSimpleSelector)child;
                }
                if (simpleSelector == null) continue;
                result.add(simpleSelector);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "findSimpleSelectorsAbove"));
        }
        return arrayList;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        HtmlCssClassOrIdReference htmlCssClassOrIdReference = new HtmlCssClassOrIdReference(element, start, end, caseSensitive, false);
        if (htmlCssClassOrIdReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getStyleReference"));
        }
        return htmlCssClassOrIdReference;
    }

    public Color getColorByValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getColorByValue"));
        }
        try {
            int rgb = Integer.parseInt(value);
            return new JBColor(rgb, rgb);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "isColorTerm"));
        }
        return term.getTermType() == CssTermTypes.NUMBER;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
        }
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        VirtualFile vFile = FlexCssElementDescriptorProvider.checkForQuickFixAndGetVFile(context);
        if (vFile == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        CssDialect dialect = (CssDialect)CssDialectMappings.getInstance((Project)context.getProject()).getMapping(vFile);
        if (dialect == CssDialect.CLASSIC) {
            Collection<? extends CssPropertyDescriptor> flexDescriptor = this.findPropertyDescriptors(propertyName, context);
            if (!flexDescriptor.isEmpty()) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwitchToCssDialectQuickFix(FlexCSSDialect.getInstance())};
                if (localQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
                }
                return localQuickFixArray;
            }
        } else {
            Collection classicDescriptors;
            CssElementDescriptorProviderImpl classicCssDescriptorProvider = (CssElementDescriptorProviderImpl)CssElementDescriptorProvider.EP_NAME.findExtension(CssElementDescriptorProviderImpl.class);
            if (classicCssDescriptorProvider != null && !(classicDescriptors = classicCssDescriptorProvider.findPropertyDescriptors(propertyName, context)).isEmpty()) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwitchToCssDialectQuickFix(CssDialect.CLASSIC)};
                if (localQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
        }
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        VirtualFile vFile = FlexCssElementDescriptorProvider.checkForQuickFixAndGetVFile(context);
        if (vFile == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        CssDialect dialect = (CssDialect)CssDialectMappings.getInstance((Project)context.getProject()).getMapping(vFile);
        if (dialect == CssDialect.CLASSIC) {
            if (this.isPossibleSelector(selectorName, context)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwitchToCssDialectQuickFix(FlexCSSDialect.getInstance())};
                if (localQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
                }
                return localQuickFixArray;
            }
        } else {
            CssElementDescriptorProviderImpl classicCssDescriptorProvider = (CssElementDescriptorProviderImpl)CssElementDescriptorProvider.EP_NAME.findExtension(CssElementDescriptorProviderImpl.class);
            if (classicCssDescriptorProvider != null && classicCssDescriptorProvider.isPossibleSelector(selectorName, context)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwitchToCssDialectQuickFix(CssDialect.CLASSIC)};
                if (localQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    public boolean isColorTermsSupported() {
        return false;
    }

    @Nullable
    private static VirtualFile checkForQuickFixAndGetVFile(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssElementDescriptorProvider", "checkForQuickFixAndGetVFile"));
        }
        PsiFile file = InjectedLanguageManager.getInstance((Project)context.getProject()).getTopLevelFile(context);
        if (file == null) {
            return null;
        }
        VirtualFile vFile = file.getOriginalFile().getVirtualFile();
        if (vFile == null || vFile.getFileType() != CssFileType.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)context.getProject());
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return null;
        }
        return vFile;
    }
}

