/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.javascript.flex.mxml.schema.AnnotationBackedDescriptorImpl;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ui.ColorChooser;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.ColorIconCache;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexMxmlColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/mxml/FlexMxmlColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javascript/flex/mxml/FlexMxmlColorAnnotator", "annotate"));
        }
        if (!(element instanceof XmlAttribute) || !JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element.getContainingFile())) {
            return;
        }
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (webEditorOptions == null || !webEditorOptions.isShowCssColorPreviewInGutter()) {
            return;
        }
        XmlAttribute attribute = (XmlAttribute)element;
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        if (!(descriptor instanceof AnnotationBackedDescriptorImpl)) {
            return;
        }
        AnnotationBackedDescriptorImpl annotationBackedDescriptor = (AnnotationBackedDescriptorImpl)descriptor;
        String format = annotationBackedDescriptor.getFormat();
        if (!"Color".equals(format)) {
            return;
        }
        String value = attribute.getValue();
        if (value == null || value.length() == 0) {
            return;
        }
        if (!"Array".equals(annotationBackedDescriptor.getType())) {
            Annotation annotation = holder.createInfoAnnotation((PsiElement)attribute.getValueElement(), null);
            annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(value, attribute));
        }
    }

    @Nullable
    private static Color getColor(@NotNull String colorValue) {
        if (colorValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorValue", "com/intellij/javascript/flex/mxml/FlexMxmlColorAnnotator", "getColor"));
        }
        try {
            int num = Integer.parseInt(colorValue);
            return new Color(num);
        }
        catch (NumberFormatException num) {
            String hex = FlexMxmlColorAnnotator.toCannonicalHex(colorValue, false);
            if (hex == null) {
                return null;
            }
            try {
                return Color.decode(hex);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    @Nullable
    private static String toCannonicalHex(String colorValue, boolean cssStyle) {
        String hex;
        if (colorValue.startsWith("#")) {
            if (cssStyle) {
                return colorValue;
            }
            return "0x" + colorValue.substring(1);
        }
        if (colorValue.startsWith("0x")) {
            if (!cssStyle) {
                return colorValue;
            }
            return "#" + colorValue.substring(2);
        }
        if (ColorMap.isStandardColor((String)(colorValue = colorValue.toLowerCase())) && (hex = ColorMap.getHexCodeForColorName((String)colorValue)) != null) {
            return FlexMxmlColorAnnotator.toCannonicalHex(hex, cssStyle);
        }
        return null;
    }

    public static class MyRenderer
    extends GutterIconRenderer {
        private static final int ICON_SIZE = 8;
        private final String myColorValue;
        private final XmlAttribute myAttribute;

        private MyRenderer(String colorValue, XmlAttribute attribute) {
            this.myColorValue = colorValue;
            this.myAttribute = attribute;
        }

        @NotNull
        public Icon getIcon() {
            Color color = FlexMxmlColorAnnotator.getColor(this.myColorValue);
            if (color != null) {
                ColorIconCache.ColorIcon colorIcon = new ColorIconCache.ColorIcon(8, color);
                if (colorIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexMxmlColorAnnotator$MyRenderer", "getIcon"));
                }
                return colorIcon;
            }
            Icon icon = EmptyIcon.create((int)8);
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexMxmlColorAnnotator$MyRenderer", "getIcon"));
            }
            return icon;
        }

        public String getTooltipText() {
            String hex = FlexMxmlColorAnnotator.toCannonicalHex(this.myColorValue, true);
            if (hex == null) {
                return null;
            }
            Color color = null;
            try {
                color = Color.decode(hex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (color == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder("<html><body><table style=\"padding: 2px 0;\" cellspacing=\"2\">");
            String attributeName = this.myAttribute.getName();
            builder.append("<tr><td valign=\"bottom\">").append(attributeName).append(":</td><td style=\"background-color:");
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            String textColor = hsb[2] > 0.7f ? "black" : "white";
            builder.append(hex);
            builder.append("; color: ").append(textColor).append("; font-family: monospaced;\" valign=\"bottom\">").append(hex).append("</td></tr></table></body></html>");
            return builder.toString();
        }

        public AnAction getClickAction() {
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null) {
                        Color currentColor = FlexMxmlColorAnnotator.getColor(myColorValue);
                        Color color = ColorChooser.chooseColor((Component)editor.getComponent(), (String)FlexBundle.message("flex.choose.color.dialog.title", new Object[0]), (Color)currentColor);
                        if (color != null && !color.equals(currentColor)) {
                            PsiFile psiFile = myAttribute.getContainingFile();
                            if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                                return;
                            }
                            String hex = CssPsiColorUtil.toHexColor((Color)color);
                            String mxmlStyleHex = FlexMxmlColorAnnotator.toCannonicalHex(hex, false);
                            ApplicationManager.getApplication().runWriteAction(() -> myAttribute.setValue(mxmlStyleHex));
                        }
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyRenderer that = (MyRenderer)((Object)o);
            if (this.myAttribute != null ? !this.myAttribute.equals(that.myAttribute) : that.myAttribute != null) {
                return false;
            }
            return !(this.myColorValue != null ? !this.myColorValue.equals(that.myColorValue) : that.myColorValue != null);
        }

        public int hashCode() {
            int result = this.myColorValue != null ? this.myColorValue.hashCode() : 0;
            result = 31 * result + (this.myAttribute != null ? this.myAttribute.hashCode() : 0);
            return result;
        }
    }
}

