/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlexXmlBackedClassesIndex
extends ScalarIndexExtension<String> {
    private static final int INDEX_VERSION = 4;

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/javascript/flex/mxml/FlexXmlBackedClassesIndex$1", "map"));
                }
                XmlFile file = (XmlFile)inputData.getPsiFile();
                HashMap result = new HashMap();
                for (JSClass clazz : XmlBackedJSClassImpl.getClasses((XmlFile)file)) {
                    JSExpression[] expressions;
                    JSReferenceList supers = FlexXmlBackedClassesIndex.this.getSupers(clazz);
                    if (supers == null) continue;
                    for (JSExpression expr : expressions = supers.getExpressions()) {
                        String s;
                        String string = s = expr instanceof JSReferenceExpression ? ((JSReferenceExpression)expr).getReferenceName() : null;
                        if (s == null) continue;
                        result.put(s, null);
                    }
                }
                HashMap hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedClassesIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedClassesIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @Nullable
    protected abstract JSReferenceList getSupers(JSClass var1);

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedClassesIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaScriptSupportLoader.getMxmlFileType()}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/mxml/FlexXmlBackedClassesIndex$2", "acceptInput"));
                }
                return JavaScriptSupportLoader.isMxmlOrFxgFile((VirtualFile)file);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedClassesIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return JSFileElementType.getVersion() + 4;
    }

    public static Collection<JSClass> searchClassInheritors(ID<String, Void> indexId, String name, Project project, GlobalSearchScope scope) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(indexId, (Object)name, scope);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<JSClass> classes = new ArrayList<JSClass>(files.size());
        for (VirtualFile file : files) {
            PsiFile psifile = psiManager.findFile(file);
            if (!(psifile instanceof XmlFile)) continue;
            classes.addAll(XmlBackedJSClassImpl.getClasses((XmlFile)((XmlFile)psifile)));
        }
        if ("Container".equals(name)) {
            classes.addAll(FlexXmlBackedClassesIndex.searchClassInheritors(indexId, "Component", project, scope));
        }
        return classes;
    }
}

