/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.javascript.flex.mxml.MxmlImplicitImports;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MxmlJSClass
extends XmlBackedJSClassImpl {
    @NonNls
    public static final String XML_TAG_NAME = "XML";
    @NonNls
    public static final String XMLLIST_TAG_NAME = "XMLList";
    @NonNls
    public static final String PRIVATE_TAG_NAME = "Private";
    @NonNls
    public static final String MXML_URI4 = "library://ns.adobe.com/flex/spark";
    @NonNls
    public static final String MXML_URI5 = "library://ns.adobe.com/flex/halo";
    @NonNls
    public static final String MXML_URI6 = "library://ns.adobe.com/flex/mx";
    @NonNls
    public static final String[] MXML_URIS = new String[]{"http://www.adobe.com/2006/mxml", "http://ns.adobe.com/mxml/2009", "library://ns.adobe.com/flex/spark", "library://ns.adobe.com/flex/halo", "library://ns.adobe.com/flex/mx"};
    @NonNls
    public static final String[] FLEX_4_NAMESPACES = new String[]{"http://ns.adobe.com/mxml/2009", "library://ns.adobe.com/flex/spark", "library://ns.adobe.com/flex/halo", "library://ns.adobe.com/flex/mx"};
    private static final String OPERATION_TAG_NAME = "operation";
    private static final String HTTP_SERVICE_TAG_NAME = "HTTPService";
    private static final String WEB_SERVICE_TAG_NAME = "WebService";
    private static final String[] REQUEST_TAG_POSSIBLE_NAMESPACES = new String[]{"http://www.adobe.com/2006/mxml", "library://ns.adobe.com/flex/spark", "library://ns.adobe.com/flex/mx"};
    private static final String REQUEST_TAG_NAME = "request";
    private static final String[] TAGS_THAT_ALLOW_ANY_XML_CONTENT = new String[]{"Private", "XML", "XMLList", "Model"};
    @NonNls
    private static final String FXG_SUPER_CLASS = "spark.core.SpriteVisualElement";
    private static final Logger LOG = Logger.getInstance(MxmlJSClass.class);
    private static Key<CachedValue<List<JSVariable>>> ourSkinComponentPredefinedVarsKey = Key.create((String)"ourskinComponentPredefinedVarsKey");
    private static JSResolveUtil.ImplicitVariableProvider skinComponentPredefinedVars = new JSResolveUtil.ImplicitVariableProvider(){

        protected void doComputeVars(final List<JSVariable> vars, final XmlFile xmlFile) {
            for (XmlTag t : xmlFile.getDocument().getRootTag().findSubTags("Metadata", "http://ns.adobe.com/mxml/2009")) {
                JSResolveUtil.processInjectedFileForTag((XmlTag)t, (JSResolveUtil.JSInjectedFilesVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                    protected void process(JSFile file) {
                        for (PsiElement elt : file.getChildren()) {
                            JSAttribute[] hostAnnotation;
                            if (!(elt instanceof JSAttributeList) || (hostAnnotation = ((JSAttributeList)elt).getAttributesByName("HostComponent")).length != 1 || vars.size() != 0) continue;
                            JSAttributeNameValuePair valuePair = hostAnnotation[0].getValueByName(null);
                            vars.add(new ImplicitJSVariableImpl("hostComponent", valuePair != null ? valuePair.getSimpleValue() : "Object", JSAttributeList.AccessType.PUBLIC, (PsiElement)xmlFile));
                            return;
                        }
                    }
                });
            }
        }
    };
    private static JSResolveUtil.ImplicitVariableProvider inlineComponentRenderPredefinedVars = new JSResolveUtil.ImplicitVariableProvider(){

        protected void doComputeVars(List<JSVariable> vars, XmlFile xmlFile) {
            XmlBackedJSClass cls = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)xmlFile);
            JSType type = JSNamedType.createType((String)cls.getQualifiedName(), (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)cls, (boolean)true), (JSContext)JSContext.INSTANCE);
            vars.add((JSVariable)new ImplicitJSVariableImpl("outerDocument", type, (PsiElement)xmlFile));
        }
    };
    private static Key<CachedValue<List<JSVariable>>> ourInlineComponentRenderPredefinedVarsKey = Key.create((String)"ourInlineComponentRenderPredefinedVarsKey");
    private volatile JSReferenceList myImplementsList;
    private final boolean isFxgBackedClass;

    public MxmlJSClass(XmlTag tag) {
        super(tag);
        PsiFile psiFile = tag.getContainingFile();
        this.isFxgBackedClass = psiFile != null && MxmlJSClass.isFxgFile(psiFile);
    }

    public static XmlTag[] findLanguageSubTags(XmlTag tag, String languageTagName) {
        return tag.findSubTags(languageTagName, MxmlJSClass.getLanguageNamespace(tag));
    }

    public static boolean isFxgFile(PsiFile file) {
        return JavaScriptSupportLoader.isFxgFile((VirtualFile)file.getViewProvider().getVirtualFile());
    }

    @NotNull
    public static String getLanguageNamespace(XmlTag rootTag) {
        assert (JavaScriptSupportLoader.isFlexMxmFile((PsiFile)rootTag.getContainingFile())) : rootTag.getContainingFile();
        String string = rootTag.getPrefixByNamespace("http://ns.adobe.com/mxml/2009") != null ? "http://ns.adobe.com/mxml/2009" : "http://www.adobe.com/2006/mxml";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/MxmlJSClass", "getLanguageNamespace"));
        }
        return string;
    }

    protected String getSuperClassName() {
        if (this.isFxgBackedClass) {
            return FXG_SUPER_CLASS;
        }
        return super.getSuperClassName();
    }

    public String getName() {
        String explicitName;
        XmlTag parent = this.getParent();
        if (parent.getParentTag() != null && MxmlJSClass.isComponentTag((XmlTag)parent.getParentTag()) && (explicitName = this.getExplicitName()) != null) {
            return explicitName;
        }
        return super.getName();
    }

    @Nullable
    private String getExplicitName() {
        XmlTag parent = this.getParent();
        if (parent.getParentTag() != null) {
            return parent.getParentTag().getAttributeValue("className", parent.getParentTag().getNamespace());
        }
        return null;
    }

    @Nullable
    public JSReferenceList getImplementsList() {
        if (this.isFxgBackedClass) {
            return null;
        }
        JSReferenceList refList = this.myImplementsList;
        if (refList == null) {
            XmlTag rootTag = this.getParent();
            this.myImplementsList = refList = this.createReferenceList(rootTag != null ? rootTag.getAttributeValue("implements") : null);
        }
        return refList;
    }

    public void addToImplementsList(String refText) {
        XmlAttribute attribute = this.getParent().getAttribute("implements");
        if (attribute == null) {
            this.getParent().setAttribute("implements", refText);
        } else {
            attribute.setValue(attribute.getValue() + ", " + refText);
        }
        this.myImplementsList = null;
    }

    public void removeFromImplementsList(String refText) {
        Object[] refs = this.getImplementsList().getReferenceTexts();
        LOG.assertTrue(ArrayUtil.contains((String)refText, (String[])refs));
        XmlAttribute attribute = this.getParent().getAttribute("implements");
        if (refs.length == 1) {
            attribute.delete();
        } else {
            String[] newRefs = (String[])ArrayUtil.remove((Object[])refs, (Object)refText);
            attribute.setValue(StringUtil.join((String[])newRefs, (String)", "));
        }
        this.myImplementsList = null;
    }

    public void setBaseComponent(String qName, String prefix, String namespace) {
        MxmlJSClass.setBaseComponent(this.getParent(), qName, prefix, namespace);
        this.myExtendsList = null;
    }

    public static void setBaseComponent(XmlTag rootTag, String qName, String prefix, String namespace) {
        Map existingPrefix2Namespace = rootTag.getLocalNamespaceDeclarations();
        for (Map.Entry entry : existingPrefix2Namespace.entrySet()) {
            if (!((String)entry.getValue()).equals(namespace)) continue;
            rootTag.setName((String)entry.getKey() + ":" + StringUtil.getShortName((String)qName));
            return;
        }
        int postfix = 1;
        String uniquePrefix = prefix;
        while (existingPrefix2Namespace.containsKey(uniquePrefix)) {
            uniquePrefix = prefix + postfix++;
        }
        rootTag.setName(uniquePrefix + ":" + StringUtil.getShortName((String)qName));
        rootTag.setAttribute("xmlns:" + uniquePrefix, namespace);
    }

    protected void processImplicitMembers(PsiScopeProcessor processor) {
        JSResolveUtil.processImplicitVars((PsiScopeProcessor)processor, (PsiFile)this.getContainingFile(), (JSResolveUtil.ImplicitVariableProvider)skinComponentPredefinedVars, ourSkinComponentPredefinedVarsKey);
    }

    public boolean processOuterDeclarations(PsiScopeProcessor processor) {
        return JSResolveUtil.processImplicitVars((PsiScopeProcessor)processor, (PsiFile)this.getContainingFile(), (JSResolveUtil.ImplicitVariableProvider)inlineComponentRenderPredefinedVars, ourInlineComponentRenderPredefinedVarsKey);
    }

    public static boolean isFxLibraryTag(XmlTag tag) {
        return tag != null && "Library".equals(tag.getLocalName()) && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace());
    }

    protected boolean canResolveTo(XmlElement element) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag == null) {
            return true;
        }
        if (!MxmlJSClass.isComponentTag((XmlTag)tag) && MxmlJSClass.getContainingComponent((XmlElement)element) != this) {
            return false;
        }
        return MxmlJSClass.canBeReferencedById(tag);
    }

    protected boolean resolveViaImplicitImports(ResolveProcessor processor) {
        return MxmlImplicitImports.resolveTypeNameUsingImplicitImports(processor, (PsiNamedElement)this);
    }

    public static boolean canBeReferencedById(XmlTag tag) {
        return !MxmlJSClass.isInsideTagThatAllowsAnyXmlContent(tag) && !MxmlJSClass.isOperationTag(tag);
    }

    public static boolean isTagOrInsideTagThatAllowsAnyXmlContent(XmlTag tag) {
        return MxmlJSClass.isTagThatAllowsAnyXmlContent(tag) || MxmlJSClass.isInsideTagThatAllowsAnyXmlContent(tag);
    }

    public static boolean isInsideTagThatAllowsAnyXmlContent(XmlTag tag) {
        return MxmlJSClass.isInsideTag((XmlTag)tag, parentTag -> MxmlJSClass.isTagThatAllowsAnyXmlContent(parentTag));
    }

    public static boolean isTagThatAllowsAnyXmlContent(XmlTag tag) {
        return tag != null && (JavaScriptSupportLoader.isLanguageNamespace((String)tag.getNamespace()) && ArrayUtil.contains((String)tag.getLocalName(), (String[])TAGS_THAT_ALLOW_ANY_XML_CONTENT) || MxmlJSClass.isWebOrHttpServiceRequestTag(tag));
    }

    private static boolean isOperationTag(XmlTag tag) {
        return OPERATION_TAG_NAME.equals(tag.getLocalName()) && ArrayUtil.contains((String)tag.getNamespace(), (String[])REQUEST_TAG_POSSIBLE_NAMESPACES);
    }

    private static boolean isWebOrHttpServiceRequestTag(XmlTag tag) {
        XmlTag parentTag;
        if (ArrayUtil.contains((String)tag.getNamespace(), (String[])REQUEST_TAG_POSSIBLE_NAMESPACES) && REQUEST_TAG_NAME.equals(tag.getLocalName()) && (parentTag = tag.getParentTag()) != null && ArrayUtil.contains((String)parentTag.getNamespace(), (String[])REQUEST_TAG_POSSIBLE_NAMESPACES)) {
            XmlTag parentParentTag;
            if (HTTP_SERVICE_TAG_NAME.equals(parentTag.getLocalName())) {
                return true;
            }
            if (OPERATION_TAG_NAME.equals(parentTag.getLocalName()) && (parentParentTag = parentTag.getParentTag()) != null && ArrayUtil.contains((String)parentParentTag.getNamespace(), (String[])REQUEST_TAG_POSSIBLE_NAMESPACES) && WEB_SERVICE_TAG_NAME.equals(parentParentTag.getLocalName())) {
                return true;
            }
        }
        return false;
    }

    public JSFile createScriptTag() throws IncorrectOperationException {
        XmlTag rootTag = this.getParent();
        if (rootTag != null) {
            String ns = MxmlJSClass.getLanguageNamespace(rootTag);
            String emptyText = "\n";
            for (XmlTag tag : rootTag.getSubTags()) {
                if (!"Script".equals(tag.getLocalName()) || !ns.equals(tag.getNamespace())) continue;
                tag.getValue().setText("\n");
                return this.findFirstScriptTag();
            }
            rootTag.add((PsiElement)rootTag.createChildTag("Script", ns, "<![CDATA[\n]]>", false));
            return this.findFirstScriptTag();
        }
        return null;
    }

    protected JSLanguageDialect getClassLanguage() {
        return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
    }
}

