/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.FlexCompilerProjectConfiguration;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexCompilerProjectConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainPanel;
    private JRadioButton myBuiltInCompilerRadioButton;
    private JRadioButton myMxmlcCompcRadioButton;
    private JCheckBox myPreferASC20CheckBox;
    private JTextField myHeapSizeTextField;
    private RawCommandLineEditor myVMOptionsEditor;
    private final Project myProject;
    private final FlexCompilerProjectConfiguration myConfig;

    public FlexCompilerProjectConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myConfig = FlexCompilerProjectConfiguration.getInstance(project);
        this.myVMOptionsEditor.setDialogCaption(FlexBundle.message("flex.compiler.vm.options.title", new Object[0]));
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    @NotNull
    public String getId() {
        if ("flex.compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexCompilerProjectConfigurable", "getId"));
        }
        return "flex.compiler";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Flex Compiler";
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.flex";
    }

    public boolean isModified() {
        return this.myConfig.USE_MXMLC_COMPC != this.myMxmlcCompcRadioButton.isSelected() || this.myConfig.USE_BUILT_IN_COMPILER != this.myBuiltInCompilerRadioButton.isSelected() || this.myConfig.PREFER_ASC_20 != this.myPreferASC20CheckBox.isSelected() || !this.myHeapSizeTextField.getText().trim().equals(String.valueOf(this.myConfig.HEAP_SIZE_MB)) || !this.myVMOptionsEditor.getText().trim().equals(this.myConfig.VM_OPTIONS);
    }

    public void apply() throws ConfigurationException {
        if (!this.myProject.isDefault()) {
            FlexCompilerHandler flexCompilerHandler = FlexCompilerHandler.getInstance(this.myProject);
            flexCompilerHandler.getCompilerDependenciesCache().clear();
            flexCompilerHandler.quitCompilerShell();
            flexCompilerHandler.getBuiltInFlexCompilerHandler().stopCompilerProcess();
        }
        this.myConfig.USE_BUILT_IN_COMPILER = this.myBuiltInCompilerRadioButton.isSelected();
        this.myConfig.USE_MXMLC_COMPC = this.myMxmlcCompcRadioButton.isSelected();
        this.myConfig.PREFER_ASC_20 = this.myPreferASC20CheckBox.isSelected();
        try {
            int heapSizeMb = Integer.parseInt(this.myHeapSizeTextField.getText().trim());
            if (heapSizeMb <= 0) {
                throw new ConfigurationException(FlexBundle.message("invalid.flex.compiler.heap.size", new Object[0]));
            }
            this.myConfig.HEAP_SIZE_MB = heapSizeMb;
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(FlexBundle.message("invalid.flex.compiler.heap.size", new Object[0]));
        }
        this.myConfig.VM_OPTIONS = this.myVMOptionsEditor.getText().trim();
    }

    public void reset() {
        this.myBuiltInCompilerRadioButton.setSelected(this.myConfig.USE_BUILT_IN_COMPILER);
        this.myMxmlcCompcRadioButton.setSelected(this.myConfig.USE_MXMLC_COMPC);
        this.myPreferASC20CheckBox.setSelected(this.myConfig.PREFER_ASC_20);
        this.myHeapSizeTextField.setText(String.valueOf(this.myConfig.HEAP_SIZE_MB));
        this.myVMOptionsEditor.setText(this.myConfig.VM_OPTIONS);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        RawCommandLineEditor rawCommandLineEditor;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMxmlcCompcRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(2, 3, 2, 0));
        jRadioButton2.setText("Mxmlc/compc");
        jRadioButton2.setMnemonic('M');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        this.myPreferASC20CheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Prefer ActionScript Compiler 2.0 for pure ActionScript build configurations");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        JLabel jLabel = new JLabel();
        jLabel.setText("Compile with:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Compiler heap size:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSizeTextField = jTextField = new JTextField();
        jTextField.setText("512");
        jTextField.setHorizontalAlignment(4);
        jPanel.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(" Mb");
        jPanel.add((Component)jLabel3, new GridConstraints(6, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("VM options:");
        jLabel4.setDisplayedMnemonic('V');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(7, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myBuiltInCompilerRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Built-in compiler shell");
        jRadioButton.setMnemonic('B');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)rawCommandLineEditor);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

