/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.ide.IconProvider;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FlexIconProvider
extends IconProvider {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        JSNamedElement mainDeclaredElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/presentation/FlexIconProvider", "getIcon"));
        }
        int transformedFlags = ElementBase.transformFlags((PsiElement)element, (int)flags);
        Icon icon = null;
        if (element instanceof XmlFile) {
            XmlBackedJSClass jsClass;
            if (JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element)) && (jsClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element))) != null) {
                icon = jsClass.getIcon(flags);
            }
        } else if (element instanceof JSFileImpl && (mainDeclaredElement = JSFileImpl.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)element))) != null) {
            icon = mainDeclaredElement.getIcon(transformedFlags);
        }
        if (icon != null) {
            PsiFile psiFile = element.getContainingFile();
            VirtualFile vFile = psiFile == null ? null : psiFile.getVirtualFile();
            CompilerManager compilerManager = CompilerManager.getInstance((Project)element.getProject());
            if (vFile != null && compilerManager != null && compilerManager.isExcludedFromCompilation(vFile)) {
                icon = new LayeredIcon(new Icon[]{icon, PlatformIcons.EXCLUDED_FROM_COMPILE_ICON});
            }
        }
        return icon;
    }
}

