/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.ProjectLibrariesSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.lang.javascript.flex.projectStructure.conversion.ConversionParams;
import com.intellij.lang.javascript.flex.projectStructure.conversion.FlexLibrariesConverter;
import com.intellij.lang.javascript.flex.projectStructure.conversion.FlexModuleConverter;
import com.intellij.lang.javascript.flex.projectStructure.conversion.FlexWorkspaceConverter;
import com.intellij.openapi.roots.ProjectRootManager;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

class FlexProjectConverter
extends ProjectConverter {
    private ConversionParams myParams;
    private final ConversionContext myContext;

    FlexProjectConverter(ConversionContext context) {
        this.myContext = context;
    }

    private boolean _isConversionNeeded() {
        for (File file : this.myContext.getModuleFiles()) {
            try {
                ModuleSettings moduleSettings = this.myContext.getModuleSettings(file);
                if (!FlexModuleConverter.isConversionNeededStatic(moduleSettings)) continue;
                return true;
            }
            catch (CannotConvertException cannotConvertException) {
                // empty catch block
            }
        }
        return false;
    }

    public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
        return new FlexModuleConverter(this.getParams());
    }

    @Nullable
    public ConversionProcessor<WorkspaceSettings> createWorkspaceFileConverter() {
        return this._isConversionNeeded() ? new FlexWorkspaceConverter(this.getParams()) : null;
    }

    public ConversionParams getParams() {
        if (this.myParams == null) {
            this.myParams = new ConversionParams(this.myContext);
        }
        return this.myParams;
    }

    public void preProcessingFinished() throws CannotConvertException {
        ComponentManagerSettings projectRootManagerSettings = this.myContext.getProjectRootManagerSettings();
        if (projectRootManagerSettings == null) {
            return;
        }
        Element projectRootManager = projectRootManagerSettings.getComponentElement(ProjectRootManager.class.getSimpleName());
        if (projectRootManager == null) {
            return;
        }
        this.getParams().projectSdkName = projectRootManager.getAttributeValue("project-jdk-name");
        ConversionParams.convertFlexSdks();
    }

    public void postProcessingFinished() throws CannotConvertException {
        this.getParams().apply();
    }

    public ConversionProcessor<ProjectLibrariesSettings> createProjectLibrariesConverter() {
        return new FlexLibrariesConverter(this.myContext, this.myParams);
    }
}

