/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.projectStructure.FlexBCConfigurator;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirDesktopPackagingConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.lang.javascript.flex.projectStructure.ui.AndroidPackagingConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.BuildConfigurationProjectStructureElement;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompilerOptionsConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompositeConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.CreateHtmlWrapperTemplateDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.IOSPackagingConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.RLMsDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.RepeatableValueDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.SelectFlexSdkDialog;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.FlexIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexBCConfigurable
extends ProjectStructureElementConfigurable<ModifiableFlexBuildConfiguration>
implements CompositeConfigurable.Item,
Place.Navigator {
    public static final String TAB_NAME = FlexBundle.message("bc.tab.general.display.name", new Object[0]);
    public static final String LOCATION_ON_TAB = "FlashBuildConfiguration.locationOnTab";
    private JPanel myMainPanel;
    private JLabel myNatureLabel;
    private HoverHyperlinkLabel myChangeNatureHyperlink;
    private JTextField myNameField;
    private JPanel myOptimizeForPanel;
    private JComboBox myOptimizeForCombo;
    private JLabel myMainClassLabel;
    private JSReferenceEditor myMainClassComponent;
    private JLabel myMainClassWarning;
    private JTextField myOutputFileNameTextField;
    private JLabel myOutputFileNameWarning;
    private TextFieldWithBrowseButton myOutputFolderField;
    private JLabel myOutputFolderWarning;
    private JCheckBox myUseHTMLWrapperCheckBox;
    private JLabel myWrapperFolderLabel;
    private TextFieldWithBrowseButton myWrapperTemplateTextWithBrowse;
    private JButton myCreateHtmlWrapperTemplateButton;
    private JLabel myRLMLabel;
    private TextFieldWithBrowseButton.NoPathCompletion myRLMTextWithBrowse;
    private Collection<FlexBuildConfiguration.RLMInfo> myRLMs;
    private JLabel myCssFilesLabel;
    private TextFieldWithBrowseButton.NoPathCompletion myCssFilesTextWithBrowse;
    private Collection<String> myCssFilesToCompile;
    private JCheckBox mySkipCompilationCheckBox;
    private JLabel myWarning;
    private final Module myModule;
    private final ModifiableFlexBuildConfiguration myConfiguration;
    @NotNull
    private final FlexProjectConfigurationEditor myConfigEditor;
    private final ProjectSdksModel mySdksModel;
    private final StructureConfigurableContext myContext;
    private String myName;
    private DependenciesConfigurable myDependenciesConfigurable;
    private CompilerOptionsConfigurable myCompilerOptionsConfigurable;
    @Nullable
    private AirDesktopPackagingConfigurable myAirDesktopPackagingConfigurable;
    @Nullable
    private AndroidPackagingConfigurable myAndroidPackagingConfigurable;
    @Nullable
    private IOSPackagingConfigurable myIOSPackagingConfigurable;
    private final BuildConfigurationProjectStructureElement myStructureElement;
    private final Disposable myDisposable;
    private final UserActivityListener myUserActivityListener;
    private boolean myFreeze;
    private PublicInheritorFilter myMainClassFilter;

    public FlexBCConfigurable(Module module, ModifiableFlexBuildConfiguration bc, final Runnable bcNatureModifier, @NotNull FlexProjectConfigurationEditor configEditor, ProjectSdksModel sdksModel, StructureConfigurableContext context) {
        if (configEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configEditor", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexBCConfigurable", "<init>"));
        }
        super(false, null);
        this.myModule = module;
        this.myConfiguration = bc;
        this.myConfigEditor = configEditor;
        this.mySdksModel = sdksModel;
        this.myContext = context;
        this.$$$setupUI$$$();
        this.myName = bc.getName();
        this.myStructureElement = new BuildConfigurationProjectStructureElement(bc, module, context){

            @Override
            protected void libraryReplaced(@NotNull Library library, @Nullable Library replacement) {
                if (library == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexBCConfigurable$1", "libraryReplaced"));
                }
                FlexBCConfigurable.this.myDependenciesConfigurable.libraryReplaced(library, replacement);
            }
        };
        this.myRLMs = Collections.emptyList();
        this.myCssFilesToCompile = Collections.emptyList();
        this.myDisposable = Disposer.newDisposable();
        this.myUserActivityListener = new UserActivityListener(){

            public void stateChanged() {
                if (FlexBCConfigurable.this.myFreeze) {
                    return;
                }
                try {
                    FlexBCConfigurable.this.apply();
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
                FlexBCConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate((ProjectStructureElement)FlexBCConfigurable.this.myStructureElement);
                FlexBCConfigurable.this.myContext.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
                FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
                List<ModifiableFlexBuildConfiguration> bcs = configurator.getBCsByOutputPath(FlexBCConfigurable.this.myConfiguration.getActualOutputFilePath());
                if (bcs != null) {
                    for (ModifiableFlexBuildConfiguration bc : bcs) {
                        if (bc == FlexBCConfigurable.this.myConfiguration) continue;
                        FlexBCConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate((ProjectStructureElement)configurator.getBCConfigurable(bc).myStructureElement);
                    }
                }
            }
        };
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myMainPanel);
        watcher.addUserActivityListener(this.myUserActivityListener, this.myDisposable);
        this.createChildConfigurables();
        this.myChangeNatureHyperlink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                bcNatureModifier.run();
            }
        });
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FlexBCConfigurable.this.setDisplayName(FlexBCConfigurable.this.myNameField.getText().trim());
            }
        });
        this.myOutputFolderField.addBrowseFolderListener(null, null, module.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.initHtmlWrapperControls();
        this.initRLMControls();
        this.initCSSControls();
        this.myOptimizeForCombo.setModel(new CollectionComboBoxModel(Arrays.asList(""), (Object)""));
        this.myOptimizeForCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if ("".equals(value)) {
                    this.setText("<no optimization>");
                }
            }
        });
        this.myMainClassWarning.setIcon(FlexIcons.Flex.SmallWarning);
        this.myOutputFileNameWarning.setIcon(FlexIcons.Flex.SmallWarning);
        this.myOutputFolderWarning.setIcon(FlexIcons.Flex.SmallWarning);
        this.myWarning.setIcon(UIUtil.getBalloonWarningIcon());
    }

    private void initHtmlWrapperControls() {
        this.myUseHTMLWrapperCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexBCConfigurable.this.updateControls();
                IdeFocusManager.getInstance((Project)FlexBCConfigurable.this.myModule.getProject()).requestFocus((Component)FlexBCConfigurable.this.myWrapperTemplateTextWithBrowse.getTextField(), true);
            }
        });
        String title = "Select folder with HTML wrapper template";
        String description = "Folder must contain 'index.template.html' file which must contain '${swf}' macro.";
        this.myWrapperTemplateTextWithBrowse.addBrowseFolderListener("Select folder with HTML wrapper template", "Folder must contain 'index.template.html' file which must contain '${swf}' macro.", this.myModule.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myCreateHtmlWrapperTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk sdk = FlexBCConfigurable.this.myDependenciesConfigurable.getCurrentSdk();
                if (sdk == null || sdk.getSdkType() == FlexmojosSdkType.getInstance()) {
                    Sdk dialogSdk;
                    SelectFlexSdkDialog dialog = new SelectFlexSdkDialog(FlexBCConfigurable.this.myModule.getProject(), CreateHtmlWrapperTemplateDialog.TITLE, FlexBundle.message("take.wrapper.template.from.sdk", new Object[0]));
                    if (dialog.showAndGet() && (dialogSdk = dialog.getSdk()) != null) {
                        FlexBCConfigurable.this.showHtmlWrapperCreationDialog(dialogSdk);
                    }
                } else {
                    FlexBCConfigurable.this.showHtmlWrapperCreationDialog(sdk);
                }
            }
        });
    }

    private void initRLMControls() {
        this.myRLMTextWithBrowse.getTextField().setEditable(false);
        this.myRLMTextWithBrowse.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        this.myRLMTextWithBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RLMsDialog dialog = new RLMsDialog(FlexBCConfigurable.this.myModule, FlexBCConfigurable.this.myRLMs);
                if (dialog.showAndGet()) {
                    FlexBCConfigurable.this.myRLMs = dialog.getRLMs();
                    FlexBCConfigurable.this.updateRLMsText();
                }
            }
        });
    }

    private void initCSSControls() {
        this.myCssFilesTextWithBrowse.getTextField().setEditable(false);
        this.myCssFilesTextWithBrowse.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        this.myCssFilesTextWithBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<StringBuilder> value = new ArrayList<StringBuilder>();
                for (String cssFilePath : FlexBCConfigurable.this.myCssFilesToCompile) {
                    value.add(new StringBuilder(cssFilePath));
                }
                RepeatableValueDialog dialog = new RepeatableValueDialog(FlexBCConfigurable.this.myModule.getProject(), FlexBundle.message("css.files.to.compile.dialog.title", new Object[0]), value, CompilerOptionInfo.CSS_FILES_INFO_FOR_UI);
                if (dialog.showAndGet()) {
                    List newValue = dialog.getCurrentList();
                    FlexBCConfigurable.this.myCssFilesToCompile = new ArrayList(newValue.size());
                    for (StringBuilder cssPath : newValue) {
                        FlexBCConfigurable.this.myCssFilesToCompile.add(cssPath.toString());
                    }
                    FlexBCConfigurable.this.updateCssFilesText();
                }
            }
        });
    }

    private void showHtmlWrapperCreationDialog(@NotNull Sdk sdk) {
        CreateHtmlWrapperTemplateDialog dialog;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexBCConfigurable", "showHtmlWrapperCreationDialog"));
        }
        String path = this.myWrapperTemplateTextWithBrowse.getText().trim();
        if (path.isEmpty()) {
            path = FlexUtils.getContentOrModuleFolderPath(this.myModule) + "/" + "html-template";
        }
        if ((dialog = new CreateHtmlWrapperTemplateDialog(this.myModule, sdk, this.myOutputFolderField.getText().trim(), path)).showAndGet()) {
            this.myWrapperTemplateTextWithBrowse.setText(FileUtil.toSystemDependentName((String)dialog.getWrapperFolderPath()));
        }
    }

    public void createChildConfigurables() {
        BuildConfigurationNature nature = this.myConfiguration.getNature();
        if (this.myDependenciesConfigurable != null) {
            this.myDependenciesConfigurable.removeUserActivityListeners();
            this.myDependenciesConfigurable.disposeUIResources();
        }
        if (this.myCompilerOptionsConfigurable != null) {
            this.myCompilerOptionsConfigurable.removeUserActivityListeners();
            this.myCompilerOptionsConfigurable.disposeUIResources();
        }
        if (this.myAirDesktopPackagingConfigurable != null) {
            this.myAirDesktopPackagingConfigurable.removeUserActivityListeners();
            this.myAirDesktopPackagingConfigurable.disposeUIResources();
        }
        if (this.myAndroidPackagingConfigurable != null) {
            this.myAndroidPackagingConfigurable.removeUserActivityListeners();
            this.myAndroidPackagingConfigurable.disposeUIResources();
        }
        if (this.myIOSPackagingConfigurable != null) {
            this.myIOSPackagingConfigurable.removeUserActivityListeners();
            this.myIOSPackagingConfigurable.disposeUIResources();
        }
        this.myDependenciesConfigurable = new DependenciesConfigurable(this.myConfiguration, this.myModule.getProject(), this.myConfigEditor, this.mySdksModel);
        this.myDependenciesConfigurable.addUserActivityListener(this.myUserActivityListener, this.myDisposable);
        this.myCompilerOptionsConfigurable = new CompilerOptionsConfigurable(this.myModule, nature, this.myDependenciesConfigurable, this.myConfiguration.getCompilerOptions());
        this.myCompilerOptionsConfigurable.addUserActivityListener(this.myUserActivityListener, this.myDisposable);
        this.myCompilerOptionsConfigurable.addAdditionalOptionsListener(new CompilerOptionsConfigurable.OptionsListener(){

            @Override
            public void configFileChanged(String additionalConfigFilePath) {
                FlexBCConfigurable.this.checkIfConfigFileOverridesOptions(additionalConfigFilePath);
            }

            @Override
            public void additionalOptionsChanged(String additionalOptions) {
            }
        });
        AirPackagingConfigurableBase.AirDescriptorInfoProvider airDescriptorInfoProvider = new AirPackagingConfigurableBase.AirDescriptorInfoProvider(){

            @Override
            public String getMainClass() {
                return FlexBCConfigurable.this.myMainClassComponent.getText().trim();
            }

            @Override
            public String getAirVersion() {
                Sdk sdk = FlexBCConfigurable.this.myDependenciesConfigurable.getCurrentSdk();
                return sdk == null || sdk.getVersionString() == null ? "" : StringUtil.notNullize((String)FlexCommonUtils.getAirVersion((String)sdk.getHomePath(), (String)sdk.getVersionString()));
            }

            @Override
            public String[] getExtensionIDs() {
                return FlexCompilationUtils.getAirExtensionIDs((ModuleRootModel)FlexBCConfigurable.this.myConfigEditor.getModifiableRootModel(FlexBCConfigurable.this.myModule), FlexBCConfigurable.this.myDependenciesConfigurable.getEditableObject());
            }

            @Override
            public boolean isAndroidPackagingEnabled() {
                return FlexBCConfigurable.this.myAndroidPackagingConfigurable != null && FlexBCConfigurable.this.myAndroidPackagingConfigurable.isPackagingEnabled();
            }

            @Override
            public boolean isIOSPackagingEnabled() {
                return FlexBCConfigurable.this.myIOSPackagingConfigurable != null && FlexBCConfigurable.this.myIOSPackagingConfigurable.isPackagingEnabled();
            }

            @Override
            public void setCustomDescriptorForAndroidAndIOS(String descriptorPath) {
                assert (FlexBCConfigurable.this.myAndroidPackagingConfigurable != null && FlexBCConfigurable.this.myIOSPackagingConfigurable != null);
                FlexBCConfigurable.this.myAndroidPackagingConfigurable.setUseCustomDescriptor(descriptorPath);
                FlexBCConfigurable.this.myIOSPackagingConfigurable.setUseCustomDescriptor(descriptorPath);
            }
        };
        AirDesktopPackagingConfigurable airDesktopPackagingConfigurable = this.myAirDesktopPackagingConfigurable = nature.isDesktopPlatform() && nature.isApp() ? new AirDesktopPackagingConfigurable(this.myModule, this.myConfiguration.getAirDesktopPackagingOptions(), airDescriptorInfoProvider) : null;
        if (this.myAirDesktopPackagingConfigurable != null) {
            this.myAirDesktopPackagingConfigurable.addUserActivityListener(this.myUserActivityListener, this.myDisposable);
        }
        AndroidPackagingConfigurable androidPackagingConfigurable = this.myAndroidPackagingConfigurable = nature.isMobilePlatform() && nature.isApp() ? new AndroidPackagingConfigurable(this.myModule, this.myConfiguration.getAndroidPackagingOptions(), airDescriptorInfoProvider) : null;
        if (this.myAndroidPackagingConfigurable != null) {
            this.myAndroidPackagingConfigurable.addUserActivityListener(this.myUserActivityListener, this.myDisposable);
        }
        IOSPackagingConfigurable iOSPackagingConfigurable = this.myIOSPackagingConfigurable = nature.isMobilePlatform() && nature.isApp() ? new IOSPackagingConfigurable(this.myModule, this.myConfiguration.getIosPackagingOptions(), airDescriptorInfoProvider) : null;
        if (this.myIOSPackagingConfigurable != null) {
            this.myIOSPackagingConfigurable.addUserActivityListener(this.myUserActivityListener, this.myDisposable);
        }
    }

    private void checkIfConfigFileOverridesOptions(String configFilePath) {
        InfoFromConfigFile info = FlexCompilerConfigFileUtil.getInfoFromConfigFile(configFilePath);
        this.overriddenValuesChanged(info.getMainClass(this.myModule), info.getOutputFileName(), info.getOutputFolderPath());
        this.myDependenciesConfigurable.overriddenTargetPlayerChanged(info.getTargetPlayer());
    }

    public void overriddenValuesChanged(@Nullable String mainClass, @Nullable String outputFileName, @Nullable String outputFolderPath) {
        this.myMainClassWarning.setToolTipText(FlexBundle.message("actual.value.from.config.file.0", mainClass));
        this.myMainClassWarning.setVisible(this.myMainClassComponent.isVisible() && mainClass != null);
        this.myOutputFileNameWarning.setToolTipText(FlexBundle.message("actual.value.from.config.file.0", outputFileName));
        this.myOutputFileNameWarning.setVisible(outputFileName != null);
        this.myOutputFolderWarning.setToolTipText(FlexBundle.message("actual.value.from.config.file.0", FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)outputFolderPath))));
        this.myOutputFolderWarning.setVisible(outputFolderPath != null);
        String warning = this.myMainClassWarning.isVisible() && outputFileName == null && outputFolderPath == null ? FlexBundle.message("overridden.in.config.file", "Main class", mainClass) : (!this.myMainClassWarning.isVisible() && outputFileName != null && outputFolderPath != null ? FlexBundle.message("overridden.in.config.file", "Output path", FileUtil.toSystemDependentName((String)(outputFolderPath + "/" + outputFileName))) : FlexBundle.message("main.class.and.output.overridden.in.config.file", new Object[0]));
        this.myWarning.setText(warning);
        this.myWarning.setVisible(this.myMainClassWarning.isVisible() || this.myOutputFileNameWarning.isVisible() || this.myOutputFolderWarning.isVisible());
    }

    @Nls
    public String getDisplayName() {
        return this.myName;
    }

    public void updateName() {
        this.myFreeze = true;
        try {
            this.myNameField.setText(this.getDisplayName());
        }
        finally {
            this.myFreeze = false;
        }
    }

    public void setDisplayName(String name) {
        this.myName = name;
    }

    public String getBannerSlogan() {
        return "Build Configuration '" + this.myName + "'";
    }

    public Module getModule() {
        return this.myModule;
    }

    public String getModuleName() {
        ModuleEditor moduleEditor = this.getModulesConfigurator().getModuleEditor(this.myModule);
        assert (moduleEditor != null) : this.myModule;
        return moduleEditor.getName();
    }

    private ModulesConfigurator getModulesConfigurator() {
        return ModuleStructureConfigurable.getInstance((Project)this.myModule.getProject()).getContext().getModulesConfigurator();
    }

    public Icon getIcon() {
        return this.myConfiguration.getIcon();
    }

    public ModifiableFlexBuildConfiguration getEditableObject() {
        return this.myConfiguration;
    }

    public String getHelpTopic() {
        return "BuildConfigurationPage.General";
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    private void updateControls() {
        TargetPlatform targetPlatform = this.myConfiguration.getTargetPlatform();
        OutputType outputType = this.myConfiguration.getOutputType();
        this.myOptimizeForPanel.setVisible(false);
        boolean showMainClass = outputType == OutputType.Application || outputType == OutputType.RuntimeLoadedModule;
        this.myMainClassLabel.setVisible(showMainClass);
        this.myMainClassComponent.setVisible(showMainClass);
        boolean wrapperApplicable = targetPlatform == TargetPlatform.Web && outputType == OutputType.Application;
        this.myUseHTMLWrapperCheckBox.setVisible(wrapperApplicable);
        this.myWrapperFolderLabel.setVisible(wrapperApplicable);
        this.myWrapperTemplateTextWithBrowse.setVisible(wrapperApplicable);
        this.myCreateHtmlWrapperTemplateButton.setVisible(wrapperApplicable);
        if (wrapperApplicable) {
            this.myWrapperFolderLabel.setEnabled(this.myUseHTMLWrapperCheckBox.isSelected());
            this.myWrapperTemplateTextWithBrowse.setEnabled(this.myUseHTMLWrapperCheckBox.isSelected());
            this.myCreateHtmlWrapperTemplateButton.setEnabled(this.myUseHTMLWrapperCheckBox.isSelected());
        }
        boolean canHaveRLMsAndRuntimeStylesheets = FlexCommonUtils.canHaveRLMsAndRuntimeStylesheets((OutputType)outputType, (TargetPlatform)targetPlatform);
        this.myRLMLabel.setVisible(canHaveRLMsAndRuntimeStylesheets);
        this.myRLMTextWithBrowse.setVisible(canHaveRLMsAndRuntimeStylesheets);
        this.updateRLMsText();
        this.myCssFilesLabel.setVisible(canHaveRLMsAndRuntimeStylesheets);
        this.myCssFilesTextWithBrowse.setVisible(canHaveRLMsAndRuntimeStylesheets);
        this.updateCssFilesText();
    }

    private void updateRLMsText() {
        String s = StringUtil.join(this.myRLMs, info -> info.MAIN_CLASS, (String)", ");
        this.myRLMTextWithBrowse.setText(s);
    }

    private void updateCssFilesText() {
        String s = StringUtil.join(this.myCssFilesToCompile, path -> PathUtil.getFileName((String)path), (String)", ");
        this.myCssFilesTextWithBrowse.setText(s);
    }

    public String getTreeNodeText() {
        return this.myConfiguration.getShortText();
    }

    public OutputType getOutputType() {
        return this.myConfiguration.getOutputType();
    }

    public boolean isModified() {
        if (!this.myConfiguration.getName().equals(this.myName)) {
            return true;
        }
        if (!this.myConfiguration.getOptimizeFor().equals(this.myOptimizeForCombo.getSelectedItem())) {
            return true;
        }
        if (!this.myConfiguration.getMainClass().equals(this.myMainClassComponent.getText().trim())) {
            return true;
        }
        if (!this.myConfiguration.getOutputFileName().equals(this.myOutputFileNameTextField.getText().trim())) {
            return true;
        }
        if (!this.myConfiguration.getOutputFolder().equals(FileUtil.toSystemIndependentName((String)this.myOutputFolderField.getText().trim()))) {
            return true;
        }
        if (this.myConfiguration.isUseHtmlWrapper() != this.myUseHTMLWrapperCheckBox.isSelected()) {
            return true;
        }
        if (!this.myConfiguration.getWrapperTemplatePath().equals(FileUtil.toSystemIndependentName((String)this.myWrapperTemplateTextWithBrowse.getText().trim()))) {
            return true;
        }
        if (!this.myConfiguration.getRLMs().equals(this.myRLMs)) {
            return true;
        }
        if (!this.myConfiguration.getCssFilesToCompile().equals(this.myCssFilesToCompile)) {
            return true;
        }
        if (this.myConfiguration.isSkipCompile() != this.mySkipCompilationCheckBox.isSelected()) {
            return true;
        }
        if (this.myDependenciesConfigurable.isModified()) {
            return true;
        }
        if (this.myCompilerOptionsConfigurable.isModified()) {
            return true;
        }
        if (this.myAirDesktopPackagingConfigurable != null && this.myAirDesktopPackagingConfigurable.isModified()) {
            return true;
        }
        if (this.myAndroidPackagingConfigurable != null && this.myAndroidPackagingConfigurable.isModified()) {
            return true;
        }
        return this.myIOSPackagingConfigurable != null && this.myIOSPackagingConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.applyOwnTo(this.myConfiguration, true);
        this.myDependenciesConfigurable.apply();
        this.myCompilerOptionsConfigurable.apply();
        if (this.myAirDesktopPackagingConfigurable != null) {
            this.myAirDesktopPackagingConfigurable.apply();
        }
        if (this.myAndroidPackagingConfigurable != null) {
            this.myAndroidPackagingConfigurable.apply();
        }
        if (this.myIOSPackagingConfigurable != null) {
            this.myIOSPackagingConfigurable.apply();
        }
        this.rebuildMainClassFilter();
    }

    private void rebuildMainClassFilter() {
        boolean rlm = this.myConfiguration.getOutputType() == OutputType.RuntimeLoadedModule;
        this.myMainClassFilter = BCUtils.getMainClassFilter(this.myModule, this.myConfiguration, rlm, false, true);
    }

    private void applyOwnTo(ModifiableFlexBuildConfiguration configuration, boolean validate) throws ConfigurationException {
        if (validate && StringUtil.isEmptyOrSpaces((String)this.myName)) {
            throw new ConfigurationException("Module '" + this.getModuleName() + "': build configuration name is empty");
        }
        configuration.setName(this.myName);
        configuration.setOptimizeFor((String)this.myOptimizeForCombo.getSelectedItem());
        configuration.setMainClass(this.myMainClassComponent.getText().trim());
        configuration.setOutputFileName(this.myOutputFileNameTextField.getText().trim());
        configuration.setOutputFolder(FileUtil.toSystemIndependentName((String)this.myOutputFolderField.getText().trim()));
        configuration.setUseHtmlWrapper(this.myUseHTMLWrapperCheckBox.isSelected());
        configuration.setWrapperTemplatePath(FileUtil.toSystemIndependentName((String)this.myWrapperTemplateTextWithBrowse.getText().trim()));
        configuration.setRLMs(this.myRLMs);
        configuration.setCssFilesToCompile(this.myCssFilesToCompile);
        configuration.setSkipCompile(this.mySkipCompilationCheckBox.isSelected());
    }

    public void reset() {
        this.myFreeze = true;
        try {
            this.setDisplayName(this.myConfiguration.getName());
            this.myNatureLabel.setText(this.myConfiguration.getNature().getPresentableText());
            this.myOptimizeForCombo.setSelectedItem(this.myConfiguration.getOptimizeFor());
            this.myMainClassComponent.setText(this.myConfiguration.getMainClass());
            this.myOutputFileNameTextField.setText(this.myConfiguration.getOutputFileName());
            this.myOutputFolderField.setText(FileUtil.toSystemDependentName((String)this.myConfiguration.getOutputFolder()));
            this.myUseHTMLWrapperCheckBox.setSelected(this.myConfiguration.isUseHtmlWrapper());
            this.myWrapperTemplateTextWithBrowse.setText(FileUtil.toSystemDependentName((String)this.myConfiguration.getWrapperTemplatePath()));
            this.myRLMs = new ArrayList<FlexBuildConfiguration.RLMInfo>(this.myConfiguration.getRLMs());
            this.myCssFilesToCompile = new ArrayList<String>(this.myConfiguration.getCssFilesToCompile());
            this.mySkipCompilationCheckBox.setSelected(this.myConfiguration.isSkipCompile());
            this.updateControls();
            this.overriddenValuesChanged(null, null, null);
            this.myDependenciesConfigurable.reset();
            this.myCompilerOptionsConfigurable.reset();
            if (this.myAirDesktopPackagingConfigurable != null) {
                this.myAirDesktopPackagingConfigurable.reset();
            }
            if (this.myAndroidPackagingConfigurable != null) {
                this.myAndroidPackagingConfigurable.reset();
            }
            if (this.myIOSPackagingConfigurable != null) {
                this.myIOSPackagingConfigurable.reset();
            }
        }
        finally {
            this.myFreeze = false;
        }
        this.rebuildMainClassFilter();
        this.myContext.getDaemonAnalyzer().queueUpdate((ProjectStructureElement)this.myStructureElement);
    }

    public void disposeUIResources() {
        this.myDependenciesConfigurable.disposeUIResources();
        this.myCompilerOptionsConfigurable.disposeUIResources();
        if (this.myAirDesktopPackagingConfigurable != null) {
            this.myAirDesktopPackagingConfigurable.disposeUIResources();
        }
        if (this.myAndroidPackagingConfigurable != null) {
            this.myAndroidPackagingConfigurable.disposeUIResources();
        }
        if (this.myIOSPackagingConfigurable != null) {
            this.myIOSPackagingConfigurable.disposeUIResources();
        }
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private List<NamedConfigurable> getChildren() {
        ArrayList<NamedConfigurable> children = new ArrayList<NamedConfigurable>();
        children.add(this.myDependenciesConfigurable);
        children.add(this.myCompilerOptionsConfigurable);
        ContainerUtil.addIfNotNull((Object)((Object)this.myAirDesktopPackagingConfigurable), children);
        ContainerUtil.addIfNotNull((Object)((Object)this.myAndroidPackagingConfigurable), children);
        ContainerUtil.addIfNotNull((Object)((Object)this.myIOSPackagingConfigurable), children);
        return children;
    }

    public CompositeConfigurable wrapInTabs() {
        return new CompositeConfigurable(this, this.getChildren(), null);
    }

    public void updateTabs(CompositeConfigurable compositeConfigurable) {
        List<NamedConfigurable> children = compositeConfigurable.getChildren();
        assert (children.get(0) == this) : children.get(0).getDisplayName();
        for (int i = children.size() - 1; i >= 1; --i) {
            compositeConfigurable.removeChildAt(i);
        }
        for (NamedConfigurable child : this.getChildren()) {
            compositeConfigurable.addChild(child);
        }
    }

    public DependenciesConfigurable getDependenciesConfigurable() {
        return this.myDependenciesConfigurable;
    }

    public boolean isParentFor(DependenciesConfigurable dependenciesConfigurable) {
        return this.myDependenciesConfigurable == dependenciesConfigurable;
    }

    private void createUIComponents() {
        this.myChangeNatureHyperlink = new HoverHyperlinkLabel("Change...");
        this.rebuildMainClassFilter();
        this.myMainClassComponent = JSReferenceEditor.forClassName((String)"", (Project)this.myModule.getProject(), null, (GlobalSearchScope)this.myModule.getModuleScope(false), null, (Condition)Conditions.alwaysTrue(), (String)ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0]));
    }

    public void addSharedLibrary(Library library) {
        this.myDependenciesConfigurable.addSharedLibraries(Collections.singletonList(library));
    }

    public static FlexBCConfigurable unwrap(CompositeConfigurable c) {
        return c.getMainChild();
    }

    @Override
    public String getTabTitle() {
        return TAB_NAME;
    }

    public ProjectStructureElement getProjectStructureElement() {
        return this.myStructureElement;
    }

    public void setHistory(History history) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object location;
        if (place != null && (location = place.getPath(LOCATION_ON_TAB)) instanceof Location) {
            switch ((Location)((Object)location)) {
                case Nature: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myChangeNatureHyperlink, true);
                }
                case MainClass: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myMainClassComponent.getChildComponent(), true);
                }
                case OutputFileName: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myOutputFileNameTextField, true);
                }
                case OutputFolder: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myOutputFolderField.getChildComponent(), true);
                }
                case HtmlTemplatePath: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myWrapperTemplateTextWithBrowse.getChildComponent(), true);
                }
                case RuntimeStyleSheets: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myCssFilesTextWithBrowse.getChildComponent(), true);
                }
                case RLMs: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myRLMTextWithBrowse.getChildComponent(), true);
                }
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexBCConfigurable", "queryPlace"));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel4;
        JLabel jLabel5;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JLabel jLabel6;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion2;
        JLabel jLabel7;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel8;
        JCheckBox jCheckBox2;
        JLabel jLabel9;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(12, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainClassLabel = jLabel9 = new JLabel();
        jLabel9.setText("Main class:");
        jLabel9.setDisplayedMnemonic('M');
        jLabel9.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Output file name:");
        jLabel10.setDisplayedMnemonic('T');
        jLabel10.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Output folder:");
        jLabel11.setDisplayedMnemonic('F');
        jLabel11.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jLabel11, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUseHTMLWrapperCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use HTML wrapper");
        jCheckBox2.setMnemonic('U');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWrapperFolderLabel = jLabel8 = new JLabel();
        jLabel8.setText("Folder with template:");
        jLabel8.setDisplayedMnemonic('W');
        jLabel8.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myWrapperTemplateTextWithBrowse = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCreateHtmlWrapperTemplateButton = jButton = new JButton();
        jButton.setText("Create...");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        this.myRLMLabel = jLabel7 = new JLabel();
        jLabel7.setText("Runtime-loaded modules:");
        jLabel7.setDisplayedMnemonic('E');
        jLabel7.setDisplayedMnemonicIndex(6);
        jPanel3.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRLMTextWithBrowse = noPathCompletion2 = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel3.add((Component)noPathCompletion2, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myCssFilesLabel = jLabel6 = new JLabel();
        jLabel6.setText("Runtime style sheets:");
        jLabel6.setDisplayedMnemonic('I');
        jLabel6.setDisplayedMnemonicIndex(4);
        jPanel3.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCssFilesTextWithBrowse = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel3.add((Component)noPathCompletion, new GridConstraints(4, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.mySkipCompilationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Skip compilation (use build configuration for code highlighting only) ");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOutputFileNameTextField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myOutputFileNameWarning = jLabel5 = new JLabel();
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myWarning = jLabel4 = new JLabel();
        jLabel4.setText("Warning placeholder");
        jPanel2.add((Component)jLabel4, new GridConstraints(11, 0, 1, 3, 8, 0, 1, 0, new Dimension(50, -1), null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myOutputFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myOutputFolderWarning = jLabel3 = new JLabel();
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.myMainClassComponent;
        jSReferenceEditor.setText("");
        jPanel6.add((Component)jSReferenceEditor, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myMainClassWarning = jLabel2 = new JLabel();
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(2, 1, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNatureLabel = jLabel = new JLabel();
        jLabel.setText("Flex application for web (Flash Player)");
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myChangeNatureHyperlink;
        hoverHyperlinkLabel.setText("Change...");
        jPanel7.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 2, 0, 3, 3, null, null, null));
        this.myOptimizeForPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Optimize for:");
        jLabel12.setDisplayedMnemonic('O');
        jLabel12.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptimizeForCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Type:");
        jPanel2.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Name:");
        jLabel14.setDisplayedMnemonic('N');
        jLabel14.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(200, -1), null));
        Spacer spacer7 = new Spacer();
        jPanel2.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel9.setLabelFor((Component)jSReferenceEditor);
        jLabel10.setLabelFor(jTextField2);
        jLabel11.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel8.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel7.setLabelFor((Component)noPathCompletion2);
        jLabel6.setLabelFor((Component)noPathCompletion);
        jLabel12.setLabelFor(jComboBox);
        jLabel14.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static enum Location {
        Nature("nature"),
        MainClass("main-class"),
        OutputFileName("output-file-name"),
        OutputFolder("output-folder"),
        HtmlTemplatePath("html-template-path"),
        RLMs("runtime-loaded-modules"),
        RuntimeStyleSheets("runtime-style-sheets");

        public final String errorId;

        private Location(String errorId) {
            this.errorId = errorId;
        }
    }
}

