/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpeedSearchUtil {
    private SpeedSearchUtil() {
    }

    public static void applySpeedSearchHighlighting(@NotNull JComponent speedSearchEnabledComponent, @NotNull SimpleColoredComponent coloredComponent, boolean mainTextOnly, boolean selected) {
        Iterator<TextRange> rangesIterator;
        if (speedSearchEnabledComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearchEnabledComponent", "com/intellij/ui/speedSearch/SpeedSearchUtil", "applySpeedSearchHighlighting"));
        }
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "com/intellij/ui/speedSearch/SpeedSearchUtil", "applySpeedSearchHighlighting"));
        }
        SpeedSearchSupply speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent);
        Iterable<TextRange> ranges = speedSearch == null ? null : speedSearch.matchingFragments(coloredComponent.getCharSequence(mainTextOnly).toString());
        Iterator<TextRange> iterator = rangesIterator = ranges != null ? ranges.iterator() : null;
        if (rangesIterator == null || !rangesIterator.hasNext()) {
            return;
        }
        Color bg = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
        SimpleColoredComponent.ColoredIterator coloredIterator = coloredComponent.iterator();
        TextRange range = rangesIterator.next();
        block0: while (coloredIterator.hasNext()) {
            coloredIterator.next();
            int offset = coloredIterator.getOffset();
            int endOffset = coloredIterator.getEndOffset();
            if (!range.intersectsStrict(offset, endOffset)) continue;
            SimpleTextAttributes attributes = coloredIterator.getTextAttributes();
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, attributes.getFgColor(), null, attributes.getStyle() | 0x40);
            do {
                if (range.getStartOffset() > offset) {
                    offset = coloredIterator.split(range.getStartOffset() - offset, attributes);
                }
                if (range.getEndOffset() <= endOffset) {
                    offset = coloredIterator.split(range.getEndOffset() - offset, highlighted);
                    if (!rangesIterator.hasNext()) break block0;
                } else {
                    coloredIterator.split(endOffset - offset, highlighted);
                    continue block0;
                }
                range = rangesIterator.next();
            } while (range.intersectsStrict(offset, endOffset));
        }
    }

    public static void appendFragmentsForSpeedSearch(@NotNull JComponent speedSearchEnabledComponent, @NotNull String text, @NotNull SimpleTextAttributes attributes, boolean selected, @NotNull SimpleColoredComponent simpleColoredComponent) {
        Iterable<TextRange> fragments;
        if (speedSearchEnabledComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearchEnabledComponent", "com/intellij/ui/speedSearch/SpeedSearchUtil", "appendFragmentsForSpeedSearch"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/speedSearch/SpeedSearchUtil", "appendFragmentsForSpeedSearch"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/speedSearch/SpeedSearchUtil", "appendFragmentsForSpeedSearch"));
        }
        if (simpleColoredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleColoredComponent", "com/intellij/ui/speedSearch/SpeedSearchUtil", "appendFragmentsForSpeedSearch"));
        }
        SpeedSearchSupply speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent);
        if (speedSearch != null && (fragments = speedSearch.matchingFragments(text)) != null) {
            Color fg = attributes.getFgColor();
            Color bg = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments(simpleColoredComponent, text, fragments, plain, highlighted);
            return;
        }
        simpleColoredComponent.append(text, attributes);
    }

    public static void appendColoredFragmentForMatcher(@NotNull String text, SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, @Nullable Matcher matcher, Color selectedBg, boolean selected) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/speedSearch/SpeedSearchUtil", "appendColoredFragmentForMatcher"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/speedSearch/SpeedSearchUtil", "appendColoredFragmentForMatcher"));
        }
        if (!(matcher instanceof MinusculeMatcher) || Registry.is((String)"ide.highlight.match.in.selected.only") && !selected) {
            component.append(text, attributes);
            return;
        }
        FList iterable = ((MinusculeMatcher)matcher).matchingFragments(text);
        if (iterable != null) {
            Color fg = attributes.getFgColor();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(selectedBg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments(component, text, (Iterable<TextRange>)iterable, plain, highlighted);
        } else {
            component.append(text, attributes);
        }
    }

    public static void appendColoredFragments(SimpleColoredComponent simpleColoredComponent, String text, Iterable<TextRange> colored, SimpleTextAttributes plain, SimpleTextAttributes highlighted) {
        ArrayList<Pair> searchTerms = new ArrayList<Pair>();
        for (TextRange fragment : colored) {
            searchTerms.add(Pair.create((Object)fragment.substring(text), (Object)fragment.getStartOffset()));
        }
        int[] lastOffset = new int[]{0};
        ContainerUtil.process(searchTerms, pair -> {
            if ((Integer)pair.second > lastOffset[0]) {
                simpleColoredComponent.append(text.substring(lastOffset[0], (Integer)pair.second), plain);
            }
            simpleColoredComponent.append(text.substring((Integer)pair.second, (Integer)pair.second + ((String)pair.first).length()), highlighted);
            lastOffset[0] = (Integer)pair.second + ((String)pair.first).length();
            return true;
        });
        if (lastOffset[0] < text.length()) {
            simpleColoredComponent.append(text.substring(lastOffset[0]), plain);
        }
    }
}

