/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryModel {
    public static final ScriptingLibraryModel[] EMPTY_ARRAY = new ScriptingLibraryModel[0];
    private String myName;
    private final Set<VirtualFile> mySourceFiles;
    private final Set<VirtualFile> myCompactFiles;
    private final Set<String> myDocUrls;
    private LibraryLevel myLibraryLevel;
    private ScriptingFrameworkDescriptor myFrameworkDescriptor;
    private Library myOriginalLibrary;
    private Set<Module> myAssociatedModules;
    private boolean myIsOnByDefault;

    public ScriptingLibraryModel(@NotNull String name, @NotNull VirtualFile[] sourceFiles, @NotNull VirtualFile[] compactFiles, @NotNull String[] docUrls, @NotNull LibraryLevel level, boolean isOnByDefault) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/webcore/libraries/ScriptingLibraryModel", "<init>"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "com/intellij/webcore/libraries/ScriptingLibraryModel", "<init>"));
        }
        if (compactFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactFiles", "com/intellij/webcore/libraries/ScriptingLibraryModel", "<init>"));
        }
        if (docUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docUrls", "com/intellij/webcore/libraries/ScriptingLibraryModel", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/webcore/libraries/ScriptingLibraryModel", "<init>"));
        }
        this(name, level);
        this.setSourceFiles(sourceFiles);
        this.myCompactFiles.addAll(Arrays.asList(compactFiles));
        this.myDocUrls.addAll(Arrays.asList(docUrls));
        this.myIsOnByDefault = isOnByDefault;
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, String extDocUrl, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, new String[]{extDocUrl}, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public ScriptingLibraryModel(@Nullable String name, LibraryLevel libraryLevel) {
        this.mySourceFiles = new HashSet<VirtualFile>();
        this.myCompactFiles = new HashSet<VirtualFile>();
        this.myDocUrls = new TreeSet<String>();
        this.myName = name;
        this.myLibraryLevel = libraryLevel;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setSourceFiles(VirtualFile[] files) {
        this.mySourceFiles.clear();
        Collections.addAll(this.mySourceFiles, files);
    }

    public void setCompactFiles(VirtualFile[] files) {
        this.myCompactFiles.clear();
        this.myCompactFiles.addAll(Arrays.asList(files));
    }

    public void setDocUrls(String[] docUrls) {
        this.myDocUrls.clear();
        this.myDocUrls.addAll(Arrays.asList(docUrls));
    }

    @NotNull
    public Set<VirtualFile> getSourceFiles() {
        Set<VirtualFile> set = this.mySourceFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "getSourceFiles"));
        }
        return set;
    }

    public Set<VirtualFile> getCompactFiles() {
        return this.myCompactFiles;
    }

    public Set<String> getDocUrls() {
        return this.myDocUrls;
    }

    @NotNull
    public Set<VirtualFile> getAllFiles() {
        HashSet compactAndSourceFiles = ContainerUtil.newHashSet(this.getSourceFiles());
        compactAndSourceFiles.addAll(this.myCompactFiles);
        HashSet hashSet = compactAndSourceFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "getAllFiles"));
        }
        return hashSet;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "getName"));
        }
        return string;
    }

    public boolean containsFile(VirtualFile file) {
        return this.getSourceFiles().contains(file) || this.myCompactFiles.contains(file);
    }

    public boolean isEmpty() {
        return this.getSourceFiles().isEmpty() && this.myCompactFiles.isEmpty();
    }

    public String toString() {
        return this.myName + (this.isPredefined() ? " (Predefined)" : "");
    }

    public boolean isPredefined() {
        return this.myLibraryLevel == LibraryLevel.PREDEFINED;
    }

    public LibraryLevel getLibraryLevel() {
        return this.myLibraryLevel;
    }

    public ScriptingFrameworkDescriptor getFrameworkDescriptor() {
        return this.myFrameworkDescriptor;
    }

    public void setFrameworkDescriptor(ScriptingFrameworkDescriptor frameworkDescriptor) {
        this.myFrameworkDescriptor = frameworkDescriptor;
    }

    void setOriginalLibrary(@Nullable Library originalLibrary) {
        this.myOriginalLibrary = originalLibrary;
    }

    @Nullable
    public Library getOriginalLibrary() {
        return this.myOriginalLibrary;
    }

    public void setLibraryLevel(LibraryLevel libraryLevel) {
        assert (libraryLevel == LibraryLevel.PROJECT || libraryLevel == LibraryLevel.GLOBAL) : "Only Global or Project level is allowed here";
        if (libraryLevel != this.myLibraryLevel) {
            this.myLibraryLevel = libraryLevel;
            this.myOriginalLibrary = null;
        }
    }

    public void setAssociatedModules(Set<Module> modules) {
        this.myAssociatedModules = modules;
    }

    public boolean hasAssociatedModules() {
        return this.myAssociatedModules != null && !this.myAssociatedModules.isEmpty();
    }

    public boolean isAssociatedWith(Module module) {
        return this.myAssociatedModules != null && this.myAssociatedModules.contains(module);
    }

    public Set<Module> getAssociatedModules() {
        return this.myAssociatedModules;
    }

    public boolean isOnByDefault() {
        return this.myIsOnByDefault;
    }

    @NotNull
    public static ScriptingLibraryModel[] toArray(@NotNull Collection<ScriptingLibraryModel> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/webcore/libraries/ScriptingLibraryModel", "toArray"));
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = collection.toArray(new ScriptingLibraryModel[collection.size()]);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryModel", "toArray"));
        }
        return scriptingLibraryModelArray;
    }

    public void addSignificantFiles(Collection<VirtualFile> result) {
        Set<VirtualFile> sourceFiles = this.getSourceFiles();
        if (!sourceFiles.isEmpty()) {
            result.addAll(sourceFiles);
        } else {
            result.addAll(this.myCompactFiles);
        }
    }

    public boolean shouldIndexSourcesWithoutMappings() {
        return true;
    }

    public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/webcore/libraries/ScriptingLibraryModel", "collectFilesWithGlobalDefinitions"));
        }
        this.addSignificantFiles(result);
    }

    public static enum LibraryLevel {
        PREDEFINED,
        GLOBAL,
        PROJECT;

    }
}

