/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.base;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.FindUsagesCommand;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.base.UsageInfoContainmentComparator;
import com.sixrr.xrp.base.XRPUsageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XRPBaseRefactoringProcessor
extends BaseRefactoringProcessor {
    private static final Logger logger = Logger.getInstance((String)"com.siyeh.rpp.XRPBaseRefactoringProcessor");
    private final boolean previewUsages;

    protected XRPBaseRefactoringProcessor(Project project, boolean previewUsages) {
        super(project);
        this.previewUsages = previewUsages;
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/base/XRPBaseRefactoringProcessor", "isPreviewUsages"));
        }
        return this.previewUsages || super.isPreviewUsages(usageInfos);
    }

    protected void refreshElements(@NotNull PsiElement[] psiElements) {
        if (psiElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElements", "com/sixrr/xrp/base/XRPBaseRefactoringProcessor", "refreshElements"));
        }
    }

    public UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usageInfos, FindUsagesCommand findUsagesCommand) {
        return this.createUsageViewDescriptor(usageInfos);
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] var1);

    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/base/XRPBaseRefactoringProcessor", "performRefactoring"));
        }
        Arrays.sort(usageInfos, new UsageInfoContainmentComparator());
        for (UsageInfo usageInfo : usageInfos) {
            try {
                ((XRPUsageInfo)usageInfo).fixUsage();
            }
            catch (IncorrectOperationException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<XRPUsageInfo> usages = new ArrayList<XRPUsageInfo>();
        this.findUsages(usages);
        int numUsages = usages.size();
        UsageInfo[] usageArray = usages.toArray(new XRPUsageInfo[numUsages]);
        Arrays.sort(usageArray, new UsageInfoContainmentComparator());
        if (usageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/base/XRPBaseRefactoringProcessor", "findUsages"));
        }
        return usageArray;
    }

    protected abstract void findUsages(@NotNull List<XRPUsageInfo> var1);
}

