/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopParameterScopeEnlarger
extends UseScopeEnlarger {
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/aop/SpringAopParameterScopeEnlarger", "getAdditionalUseScope"));
        }
        if (!(element instanceof PsiParameter)) {
            return null;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        PsiParameter parameter = (PsiParameter)element;
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (!(declarationScope instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        if (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || method.hasModifierProperty("final")) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return null;
        }
        final Project project = module.getProject();
        return (SearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<SearchScope>(){

            @Nullable
            public CachedValueProvider.Result<SearchScope> compute() {
                GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                List fileElements = DomService.getInstance().getFileElements(Beans.class, project, searchScope);
                HashSet files = new HashSet();
                for (DomFileElement domFileElement : fileElements) {
                    if (!SpringDomUtils.hasNamespace((DomFileElement)domFileElement, (String)"Spring AOP namespace key") && !SpringDomUtils.hasNamespace((DomFileElement)domFileElement, (String)"Spring TX namespace key")) continue;
                    ContainerUtil.addIfNotNull(files, (Object)domFileElement.getFile().getVirtualFile());
                }
                return CachedValueProvider.Result.createSingleDependency(files.isEmpty() ? null : GlobalSearchScope.filesScope((Project)project, files), (Object)PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        });
    }
}

