/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;

public class SpringMVCImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final Collection<String> SPRING_MVC_IMPLICIT_USAGE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.ModelAttribute", "org.springframework.web.bind.annotation.InitBinder", "org.springframework.web.bind.annotation.ExceptionHandler"});

    public boolean isImplicitUsage(PsiElement element) {
        return this.isImplicitWrite(element) || SpringMVCImplicitUsageProvider.isSpecialClass(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return SpringMVCImplicitUsageProvider.isAnnotated(element);
    }

    private static boolean isAnnotated(PsiElement element) {
        if (!SpringMVCImplicitUsageProvider.isRelevantAnnotationElement(element)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), SPRING_MVC_IMPLICIT_USAGE_ANNOTATIONS);
    }

    private static boolean isRelevantAnnotationElement(PsiElement element) {
        if (element instanceof PsiParameter) {
            return true;
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).hasModifierProperty("public");
        }
        return false;
    }

    private static boolean isSpecialClass(PsiElement element) {
        return element instanceof PsiClass && InheritanceUtil.isInheritor((PsiClass)((PsiClass)element), (String)"org.springframework.web.WebApplicationInitializer");
    }
}

