/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.converters.resources.ResourceValueConverter;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.spring.model.xml.mvc.TilesConfigurer;
import com.intellij.spring.web.SpringWebConstants;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesConfigurerDefinitionsConverter
extends ResourceValueConverter
implements GenericDomValueConvertersRegistry.Provider,
Condition<Pair<PsiType, GenericDomValue>> {
    @NonNls
    static final String DEFINITIONS_ATTRIBUTE = "definitions";

    public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
        return this;
    }

    public Converter getConverter() {
        return this;
    }

    public boolean value(Pair<PsiType, GenericDomValue> pair) {
        GenericDomValue genericDomValue = (GenericDomValue)pair.getSecond();
        return TilesConfigurerDefinitionsConverter.isRelevantProperty(genericDomValue);
    }

    private static boolean isRelevantProperty(GenericDomValue genericDomValue) {
        if ("location".equals(genericDomValue.getXmlElementName()) && genericDomValue.getParentOfType(TilesConfigurer.class, true) != null) {
            return true;
        }
        return SpringPropertyUtils.isSpecificProperty((GenericDomValue)genericDomValue, (String)DEFINITIONS_ATTRIBUTE, (String[])SpringWebConstants.TILES_CONFIGURER_CLASSES);
    }

    public static class ResourceTypeProvider
    implements SpringResourceTypeProvider {
        private final Condition<PsiFileSystemItem> TILES_XML_CONDITION = item -> {
            if (item.isDirectory()) {
                return true;
            }
            VirtualFile file = item.getVirtualFile();
            if (file == null) {
                return false;
            }
            PsiFile psiFile = item.getManager().findFile(file);
            if (!(psiFile instanceof XmlFile)) {
                return false;
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            return StrutsProjectComponent.getInstance((Project)item.getProject()).getTilesFactory().getDomRoot(xmlFile) != null;
        };

        @Nullable
        public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
            if (genericDomValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/web/mvc/tiles/TilesConfigurerDefinitionsConverter$ResourceTypeProvider", "getResourceFilter"));
            }
            return TilesConfigurerDefinitionsConverter.isRelevantProperty(genericDomValue) ? this.TILES_XML_CONDITION : null;
        }
    }
}

