/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlViewResolverFactory
extends BeanNameViewResolverFactory {
    @Override
    public String getBeanClass() {
        return "org.springframework.web.servlet.view.XmlViewResolver";
    }

    @Override
    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        return Collections.singleton(new XmlViewResolver(bean));
    }

    private static class XmlViewResolver
    extends BeanNameViewResolverFactory.BeanNameViewResolver {
        final String myLocation;

        private XmlViewResolver(CommonSpringBean bean) {
            String location = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"location");
            this.myLocation = location == null ? "/WEB-INF/views.xml" : location;
        }

        @Override
        @NotNull
        public String handleElementRename(String newElementName) {
            String string = newElementName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/XmlViewResolverFactory$XmlViewResolver", "handleElementRename"));
            }
            return string;
        }

        @Override
        protected Collection<SpringModel> getModels(SpringMVCModel context) {
            WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement(this.myLocation, context.getWebFacet());
            if (element == null) {
                return Collections.emptyList();
            }
            PsiFile file = element.getOriginalFile();
            if (!(file instanceof XmlFile)) {
                return Collections.emptyList();
            }
            SpringModel model = SpringManager.getInstance((Project)file.getProject()).getSpringModelByFile(file);
            return model == null ? Collections.emptyList() : Collections.singletonList(model);
        }
    }
}

