/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.openapi.module.Module;
import com.intellij.util.ArrayUtil;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectProcedure;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gga.graph.impl.DataGraphImpl;
import org.gga.graph.maps.DataGraph;

class ClassesDependencyMap {
    private final Map<ClassNode, TObjectIntHashMap<String>> myMap = new HashMap<ClassNode, TObjectIntHashMap<String>>();
    private Module myCurrentModule = null;

    ClassesDependencyMap() {
    }

    private ClassNode createKey(String name) {
        return new ClassNode(name, this.myCurrentModule);
    }

    public void addDependency(String from, String to) {
        ClassNode key = this.createKey(from);
        TObjectIntHashMap depMap = this.myMap.get(key);
        if (depMap == null) {
            depMap = new TObjectIntHashMap();
            this.myMap.put(key, (TObjectIntHashMap<String>)depMap);
        }
        depMap.put((Object)to, depMap.get((Object)to) + 1);
    }

    public int size() {
        return this.myMap.size();
    }

    public DataGraph<String, Integer> toSimpleGraph() {
        final HashSet<String> namesSet = new HashSet<String>();
        for (ClassNode key : this.myMap.keySet()) {
            namesSet.add(key.className);
        }
        final DataGraphImpl<String, Integer> result = new DataGraphImpl<String, Integer>(namesSet.size(), true);
        Object[] names = ArrayUtil.toStringArray(namesSet);
        Arrays.sort(names);
        for (int i = 0; i < names.length; ++i) {
            result.setNode(i, (String)names[i]);
        }
        for (final ClassNode key : this.myMap.keySet()) {
            final TObjectIntHashMap<String> deps = this.myMap.get(key);
            if (deps == null) continue;
            deps.forEachKey((TObjectProcedure)new TObjectProcedure<String>(){

                public boolean execute(String to) {
                    if (!namesSet.contains(to)) {
                        return true;
                    }
                    int d = deps.get((Object)to);
                    result.insert(key.className, to, d);
                    return true;
                }
            });
        }
        return result;
    }

    public void setCurrentModule(Module currentModule) {
        this.myCurrentModule = currentModule;
    }

    public Map<ClassNode, TObjectIntHashMap<String>> getMap() {
        return this.myMap;
    }
}

