/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DsmTableSpeedSearch<N>
extends SpeedSearchBase<DsmTableImpl<N>> {
    private int selectedIndex = -1;

    public DsmTableSpeedSearch(DsmTableImpl<N> component) {
        super(component);
    }

    protected int getSelectedIndex() {
        return this.selectedIndex;
    }

    protected Object[] getAllElements() {
        DsmTableImpl table = (DsmTableImpl)this.getComponent();
        List rows = table.myCache.myRows;
        LinkedHashSet nodes = ContainerUtil.newLinkedHashSet();
        for (DsmTreeStructure.TreeNode row : rows) {
            this.addNodeAndParents(row, nodes);
        }
        return nodes.toArray();
    }

    private void addNodeAndParents(DsmTreeStructure.TreeNode<N> node, Set<DsmTreeStructure.TreeNode<N>> nodes) {
        DsmTreeStructure.TreeNode<N> parent = node.getParent();
        if (parent == null) {
            return;
        }
        this.addNodeAndParents(parent, nodes);
        nodes.add(node);
    }

    @Nullable
    protected String getElementText(Object element) {
        return ((DsmTreeStructure.TreeNode)element).getShortName();
    }

    protected void selectElement(Object element, String selectedText) {
        DsmTreeStructure.TreeNode selected = (DsmTreeStructure.TreeNode)element;
        DsmSelectionModel selectionModel = ((DsmTableImpl)this.getComponent()).getSelectionModel();
        Map indices = ((DsmTableImpl)this.getComponent()).myCache.rowIndices;
        DsmTreeStructure.TreeNode startNode = selected;
        Integer startIndex = indices.get(selected);
        while (!startNode.isLeaf() && startIndex == null) {
            DsmTreeStructure.TreeNode<N>[] children = startNode.getChildren();
            startNode = children[0];
            startIndex = indices.get(startNode);
        }
        DsmTreeStructure.TreeNode endNode = selected;
        Integer endIndex = indices.get(selected);
        while (!endNode.isLeaf() && endIndex == null) {
            DsmTreeStructure.TreeNode<N>[] children = endNode.getChildren();
            endNode = children[children.length - 1];
            endIndex = indices.get(endNode);
        }
        assert (startIndex != null && endIndex != null);
        this.selectedIndex = ArrayUtil.indexOf((Object[])this.getAllElements(), selected);
        selectionModel.clear();
        selectionModel.addSelection(DsmSelection.createRowSelection(Collections.singleton(selected), startIndex, endIndex));
        ((DsmTableImpl)this.getComponent()).scrollRowToVisible(selected);
    }
}

