/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.NodeVisitor;
import com.intellij.dsm.ui.RowAnnotation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.Icon;

class PaintRowHeaderVisitor<N>
implements NodeVisitor<N> {
    private final Graphics2D g;
    private final DsmTableImpl<N> myDsmTable;

    public PaintRowHeaderVisitor(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
        this.visitRow(node, x, y, this.myDsmTable.myBoxSize, isFirst, isLast, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitAfterExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
        boolean superSmall = this.myDsmTable.myCache.isSuperSmall;
        if (superSmall) {
            return;
        }
        boolean small = this.myDsmTable.myCache.isSmall;
        Rectangle oldClipBounds = this.g.getClipBounds();
        Color bg = this.myDsmTable.getHeaderBg(node);
        Color fg = this.myDsmTable.getForeground();
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        if (!oldClipBounds.intersects(r)) {
            return;
        }
        this.g.setClip(new Rectangle(r.x, r.y, r.width + 1, r.height + 1).intersection(oldClipBounds));
        try {
            this.g.setPaint(bg);
            this.g.fill(r);
            this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
            this.g.draw(r);
            if (small) {
                return;
            }
            AffineTransform tr = this.g.getTransform();
            int iconX = x + (this.myDsmTable.myBoxSize - AllIcons.Nodes.CollapseNode.getIconWidth()) / 2;
            int iconY = y + (this.myDsmTable.myBoxSize - AllIcons.Nodes.CollapseNode.getIconHeight()) / 2 + 1;
            int iconXc = iconX + AllIcons.Nodes.CollapseNode.getIconWidth() / 2;
            int iconYc = iconY + AllIcons.Nodes.CollapseNode.getIconHeight() / 2;
            int iconX2 = iconX + AllIcons.Nodes.CollapseNode.getIconWidth();
            AllIcons.Nodes.CollapseNode.paintIcon(this.myDsmTable, this.g, iconX, iconY);
            Point textStart = this.myDsmTable.myCache.rowTextStart.get(node);
            Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds(node.getShortName(), this.g);
            this.g.translate(textStart.x, textStart.y);
            this.g.rotate(1.5707963267948966);
            PaintRowHeaderVisitor.paintRowIcon(node, 0, -r.width + 3, r.width, this.myDsmTable, this.g);
            UISettings.setupAntialiasing((Graphics)this.g);
            this.g.setPaint(this.myDsmTable.getHeaderFg(node));
            this.g.drawString(node.getShortName(), r.width, -this.myDsmTable.getFontMetrics(this.myDsmTable.getFont()).getDescent());
            this.g.setTransform(tr);
            UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconX2, (int)iconYc, (int)(iconX + this.myDsmTable.myBoxSize - 1), (int)iconYc, (Color)bg, (Color)fg);
            int textY2 = (int)((double)textStart.y + stringBounds.getWidth() + (double)r.width);
            if (!isLast) {
                UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconXc, (int)(textY2 + 5), (int)iconXc, (int)(iconY + height), (Color)bg, (Color)fg);
            }
        }
        finally {
            this.g.setClip(oldClipBounds);
        }
    }

    @Override
    public void visitBeforeExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
    }

    @Override
    public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
        this.visitRow(node, x, y, height, isFirst, last, AllIcons.Nodes.ExpandNode);
    }

    private void visitRow(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast, Icon icon) {
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        assert (r != null) : "Null bounds for: " + node;
        Rectangle clipBounds = this.g.getClipBounds();
        if (!clipBounds.intersects(r)) {
            return;
        }
        Color bg = this.myDsmTable.getHeaderBg(node);
        Color fg = this.myDsmTable.getForeground();
        this.g.setPaint(bg);
        this.g.fill(r);
        boolean small = this.myDsmTable.myCache.isSmall;
        boolean superSmall = this.myDsmTable.myCache.isSuperSmall;
        Map<DsmTreeStructure.TreeNode, RowAnnotation> rowAnnotations = this.myDsmTable.myRowAnnotations;
        if (rowAnnotations.containsKey(node)) {
            Color c;
            RowAnnotation rowAnnotation = rowAnnotations.get(node);
            switch (rowAnnotation) {
                default: {
                    assert (false);
                }
                case BCK_DEP: {
                    c = DsmTableConstants.COLOR_FWD_DEP;
                    break;
                }
                case FWD_DEP: {
                    c = DsmTableConstants.COLOR_BCK_DEP;
                    break;
                }
                case CYCLE_DEP: {
                    c = DsmTableConstants.COLOR_CYCLE;
                }
            }
            this.g.setPaint(c);
            int s = 10;
            this.g.fillRect(r.x + r.width - 10, r.y, 10, r.height);
            this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
            if (!superSmall) {
                this.g.drawRect(r.x + r.width - 10, r.y, 10, r.height);
            }
        }
        this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
        if (!superSmall) {
            this.g.draw(r);
        }
        int iconX = x + (this.myDsmTable.myBoxSize - AllIcons.Nodes.ExpandNode.getIconWidth()) / 2;
        int iconY = y + (height - AllIcons.Nodes.ExpandNode.getIconHeight()) / 2 + 1;
        int iconXc = iconX + AllIcons.Nodes.ExpandNode.getIconWidth() / 2;
        int iconYc = iconY + AllIcons.Nodes.ExpandNode.getIconHeight() / 2;
        int iconX2 = iconX + AllIcons.Nodes.ExpandNode.getIconWidth();
        int iconY2 = iconY + AllIcons.Nodes.ExpandNode.getIconHeight();
        if (!small) {
            if (icon != null) {
                icon.paintIcon(this.myDsmTable, this.g, iconX, iconY);
            } else {
                UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconXc, (int)(isFirst ? iconYc + 1 : iconY), (int)iconXc, (int)(isLast ? iconYc : iconY2), (Color)bg, (Color)fg);
                UIUtil.drawDottedLine((Graphics2D)this.g, (int)(iconXc + 2), (int)iconYc, (int)iconX2, (int)iconYc, (Color)bg, (Color)fg);
                if (isFirst) {
                    UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconX, (int)iconYc, (int)(iconXc - 1), (int)iconYc, (Color)bg, (Color)fg);
                }
            }
            String s = node.getShortName();
            Point textStart = this.myDsmTable.myCache.rowTextStart.get(node);
            if (!small) {
                this.g.setPaint(this.myDsmTable.getHeaderFg(node));
                UISettings.setupAntialiasing((Graphics)this.g);
                this.g.drawString(s, textStart.x, textStart.y);
            }
            PaintRowHeaderVisitor.paintRowIcon(node, textStart.x - height - 2, y + 2, height, this.myDsmTable, this.g);
            if (!isLast) {
                UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconXc, (int)(iconY2 + 1), (int)iconXc, (int)(iconY + this.myDsmTable.myBoxSize), (Color)bg, (Color)fg);
            }
        }
    }

    static <N> void paintRowIcon(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, DsmTableImpl<N> dsmTable, Graphics2D g) {
        Icon nodeIcon = node.getIcon();
        if (nodeIcon != null) {
            UIUtil.drawImage((Graphics)g, (Image)dsmTable.myIconCache.getIcon(nodeIcon, height), (int)x, (int)y, null);
        }
    }
}

