/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.common.persistence.mapping;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttributeType
implements PersistentAttributeType {
    private static final List<AttributeType> ourInstances = new ArrayList<AttributeType>();
    private static final Map<String, AttributeType> ourAnnotations = new THashMap();
    private static final Set<JamMemberMeta<PsiMember, ? extends JamAttributeBase>> ourMetas = new THashSet();
    private final Class myAttributeClass;
    private final String myTypeName;
    private final JamMemberMeta<PsiMember, ? extends JamAttributeBase>[] myJamMeta;

    public static Iterable<AttributeType> values() {
        return ourInstances;
    }

    public static Set<String> getAttributeAnnotations() {
        return ourAnnotations.keySet();
    }

    @Nullable
    public static AttributeType getAttributeType(String anno) {
        return ourAnnotations.get(anno);
    }

    public static JamMemberMeta<PsiMember, ? extends JamAttributeBase>[] getAllJamMetas() {
        return ourMetas.toArray(new JamMemberMeta[ourMetas.size()]);
    }

    @Nullable
    public static AttributeType getAnnotationAttributeType(AttributeType type) {
        String annotation = type.getAttributeAnnotation();
        return annotation == null ? null : ourAnnotations.get(annotation);
    }

    protected AttributeType(Class attributeClass, String typeName, JamMemberMeta<PsiMember, ? extends JamAttributeBase> ... jamMetas) {
        assert (attributeClass != null) : "null attribute class";
        this.myAttributeClass = attributeClass;
        this.myTypeName = typeName;
        this.myJamMeta = jamMetas;
        for (JamMemberMeta<PsiMember, ? extends JamAttributeBase> meta : jamMetas) {
            for (JamAnnotationMeta annotationMeta : meta.getRootAnnotations()) {
                AttributeType prevType;
                String anno = annotationMeta.getAnnoName();
                if (anno == null || (prevType = ourAnnotations.get(anno)) != null && (prevType.getAttributeClass() == attributeClass || !ReflectionUtil.isAssignable((Class)attributeClass, (Class)prevType.getAttributeClass()))) continue;
                ourAnnotations.put(anno, this);
            }
        }
        ContainerUtil.addAll(ourMetas, (Object[])jamMetas);
        ourInstances.add(this);
    }

    public String getTypeName() {
        return this.myTypeName;
    }

    public Class getAttributeClass() {
        return this.myAttributeClass;
    }

    public JamMemberMeta<PsiMember, ? extends JamAttributeBase>[] getJamMetas() {
        return this.myJamMeta;
    }

    @Nullable
    public String getAttributeAnnotation() {
        return this.myJamMeta.length == 0 ? null : JamCommonUtil.getFirstRootAnnotation(this.myJamMeta[0]);
    }

    @Nullable
    public RelationshipType getRelationshipType() {
        return null;
    }

    @NotNull
    public static AttributeType getAttributeType(@NotNull PersistentAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getAttributeType"));
        }
        boolean container = attribute.getAttributeModelHelper().isContainer();
        List list = ModelMergerUtil.getImplementations((Object)attribute);
        int size = list.size();
        for (int i = size - 1; i > -1; --i) {
            PersistentAttribute attr = (PersistentAttribute)list.get(i);
            for (AttributeType type : AttributeType.values()) {
                if (!type.accepts(attr) || type.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY) != container) continue;
                AttributeType attributeType = type;
                if (attributeType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getAttributeType"));
                }
                return attributeType;
            }
        }
        throw new AssertionError(attribute);
    }

    protected boolean accepts(PersistentAttribute attribute) {
        return this.getAttributeClass().isInstance(attribute);
    }

    @NotNull
    public static AttributeType getAttributeType(@NotNull RelationshipType relationshipType) {
        if (relationshipType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relationshipType", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getAttributeType"));
        }
        for (AttributeType type : AttributeType.values()) {
            if (type.getRelationshipType() != relationshipType) continue;
            AttributeType attributeType = type;
            if (attributeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getAttributeType"));
            }
            return attributeType;
        }
        throw new AssertionError(relationshipType);
    }

    public boolean isIdAttribute() {
        return false;
    }

    public boolean isVersionAttribute() {
        return false;
    }

    public Icon getIcon() {
        boolean id = this.isIdAttribute();
        if (this.getRelationshipType() != null) {
            return id ? JavaeeIcons.ID_RELATIONSHIP_ICON : JavaeeIcons.RELATIONSHIP_ICON;
        }
        return id ? JavaeeIcons.ID_ATTRIBUTE_ICON : JavaeeIcons.ATTRIBUTE_ICON;
    }

    public String toString() {
        return "[" + this.getTypeName() + "]";
    }

    @NotNull
    public PsiType getDefaultPsiType(PersistentAttribute attribute) {
        PsiType psiType = this.getDefaultElementPsiType(attribute);
        if (this.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY)) {
            PsiType psiType2;
            try {
                psiType2 = JavaContainerType.COLLECTION.createCollectionType(attribute.getIdentifyingPsiElement(), psiType, null);
            }
            catch (IncorrectOperationException e) {
                throw new AssertionError((Object)e);
            }
            if (psiType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getDefaultPsiType"));
            }
            return psiType2;
        }
        PsiType psiType3 = psiType;
        if (psiType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getDefaultPsiType"));
        }
        return psiType3;
    }

    @NotNull
    protected PsiType getDefaultElementPsiType(PersistentAttribute attribute) {
        PersistentRelationshipAttribute relationAttributeBase;
        PsiClass aClass;
        PsiManager psiManager = attribute.getPsiManager();
        PsiClassType psiType = null;
        if (attribute instanceof PersistentEmbeddedAttribute) {
            PsiClass aClass2 = (PsiClass)((PersistentEmbeddedAttribute)attribute).getTargetEmbeddableClass().getValue();
            psiType = aClass2 == null ? PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)ProjectScope.getAllScope((Project)psiManager.getProject())) : JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(aClass2);
        } else if (attribute instanceof PersistentRelationshipAttribute && (aClass = (PsiClass)(relationAttributeBase = (PersistentRelationshipAttribute)attribute).getTargetEntityClass().getValue()) != null) {
            psiType = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(aClass);
        }
        if (psiType == null) {
            psiType = PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)ProjectScope.getAllScope((Project)psiManager.getProject()));
        }
        PsiClassType psiClassType = psiType;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/persistence/mapping/AttributeType", "getDefaultElementPsiType"));
        }
        return psiClassType;
    }
}

