/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.psi.css.CssBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssDialect {
    public static final ExtensionPointName<CssDialect> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.dialect");
    public static final CssDialect CLASSIC = new CssDialect(){

        @Override
        public String getName() {
            return "CLASSIC";
        }

        @Override
        public String getDisplayName() {
            return CssBundle.message("css.w3c.dialect.name", new Object[0]);
        }

        @Override
        public boolean isDefault(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/css/CssDialect$1", "isDefault"));
            }
            return true;
        }
    };

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract boolean isDefault(@NotNull Module var1);

    @Nullable
    public static CssDialect getDefaultDialect(@Nullable Module module) {
        if (module != null) {
            for (CssDialect dialect : (CssDialect[])Extensions.getExtensions(EP_NAME)) {
                if (!dialect.isDefault(module)) continue;
                return dialect;
            }
            return CLASSIC;
        }
        return null;
    }

    public static List<CssDialect> getAvailableDialects() {
        ArrayList<CssDialect> results = new ArrayList<CssDialect>();
        Collections.addAll(results, Extensions.getExtensions(EP_NAME));
        results.add(CLASSIC);
        return results;
    }

    public static List<CssDialect> getCustomDialects() {
        ArrayList<CssDialect> results = new ArrayList<CssDialect>();
        Collections.addAll(results, Extensions.getExtensions(EP_NAME));
        return results;
    }
}

