/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotifier;
import com.jetbrains.plugins.webDeployment.ui.CancellableAllFileSelector;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.jetbrains.annotations.NotNull;

public abstract class TransferOperation {
    private static final Logger LOG = Logger.getInstance((String)TransferOperation.class.getName());

    public void prepare(ExecutionContext context) throws FileSystemException {
    }

    public abstract String getProgressText(ExecutionContext var1);

    public abstract String getDetailedText(ExecutionContext var1);

    public abstract void execute(ExecutionContext var1) throws FileSystemException;

    public abstract String getErrorMessage(ExecutionContext var1, String var2);

    public abstract void onLocalMove(FileObject var1, FileObject var2) throws FileSystemException;

    protected static FileObject updateOnParentMove(FileObject file, FileObject parentFrom, FileObject parentTo) throws FileSystemException {
        if (file.getName().isAncestor(parentFrom.getName())) {
            return parentTo.resolveFile(parentFrom.getName().getRelativeName(file.getName()), NameScope.DESCENDENT);
        }
        return file;
    }

    public static WebServerConfig.RemotePath updateOnParentMove(WebServerConfig.RemotePath path, FileObject parentFrom, FileObject parentTo, boolean caseSensitive) throws FileSystemException {
        return new WebServerConfig.RemotePath(TransferOperation.updateOnParentMove(path.path, parentFrom, parentTo, caseSensitive));
    }

    public static String updateOnParentMove(String path, FileObject parentFrom, FileObject parentTo, boolean caseSensitive) throws FileSystemException {
        return TransferOperation.updateOnParentMove(path, parentFrom.getName().getPath(), parentTo.getName().getPath(), caseSensitive);
    }

    public static String updateOnParentMove(String path, String parentFrom, String parentTo, boolean caseSensitive) {
        String remainder = DeploymentPathUtils.getPathRemainder(parentFrom, path, caseSensitive);
        if (remainder != null) {
            return DeploymentPathUtils.join(parentTo, remainder);
        }
        return path;
    }

    public static boolean isUpToDate(FileObject source, FileObject target, WebServerConfig server) throws FileSystemException {
        long targetTimestamp;
        long sourceTimestamp;
        if (!target.exists()) {
            return false;
        }
        long sourceSize = source.getContent().getSize();
        long targetSize = target.getContent().getSize();
        if (ApplicationManagerEx.getApplicationEx().isUnitTestMode()) {
            sourceTimestamp = 0L;
            targetTimestamp = 0L;
        } else {
            boolean accurateTimestamp = server.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            sourceTimestamp = source.getContent().getLastModifiedTime(accurateTimestamp);
            targetTimestamp = target.getContent().getLastModifiedTime(accurateTimestamp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(source.getName().getPath() + " source timestamp=" + String.valueOf(sourceTimestamp) + ", target timestamp=" + String.valueOf(targetTimestamp) + ", delta=" + Long.toString(sourceTimestamp - targetTimestamp) + ", source size=" + sourceSize + ", target size=" + targetSize);
        }
        return sourceSize == targetSize && TransferOperation.areTimestampsEqual(sourceTimestamp, targetTimestamp, source.getFileSystem().getLastModTimeAccuracy() + target.getFileSystem().getLastModTimeAccuracy());
    }

    private static void move(ExecutionContext context, FileObject remoteSource, FileObject remoteTarget) throws FileSystemException {
        LOG.assertTrue(context.isServerSideModification());
        if (!remoteSource.getName().equals(remoteTarget.getName())) {
            remoteSource.moveTo(remoteTarget);
        }
        context.incCounter("transfer.details.moved");
        context.addAffectedRoot(remoteSource.getName(), true);
        context.addAffectedRoot(remoteTarget.getName(), true);
    }

    private static boolean setPermissions(FileObject target, boolean isDirectory, ExecutionContext context, boolean tolerate) throws FileSystemException {
        int permissions;
        int n = permissions = isDirectory ? context.getConfig().getFolderPermissions() : context.getConfig().getFilePermissions();
        if (!context.isServerSideModification() || permissions == -1) {
            return false;
        }
        LOG.debug("Changing permissions of " + target.getName().getURI() + " to " + Util.getPermissionsAsString(permissions) + " (" + Integer.toOctalString(permissions) + ")");
        try {
            target.setPermissions(permissions);
            return true;
        }
        catch (FileSystemException e) {
            if (!tolerate || PublishUtils.isFatal(e)) {
                throw e;
            }
            context.getConfig().setFilePermissions(-1);
            context.getConfig().setFolderPermissions(-1);
            LOG.warn("Failed to change permissions of " + target.getName().getPath(), (Throwable)e);
            String message = WDBundle.message("failed.to.change.permissions", isDirectory ? 2 : 1, context.getServer().getPresentablePath(target), StringUtil.decapitalize((String)PublishUtils.getMessage(e, false)));
            context.console(message, ConsoleViewContentType.ERROR_OUTPUT);
            if (context.isMultipleOperations()) {
                message = message + "\n" + WDBundle.message("permissions.wont.be.changed", new Object[0]);
            }
            context.showBalloon(message, MessageType.WARNING);
            return false;
        }
    }

    private static void createFolder(FileObject target, ExecutionContext context) throws FileSystemException {
        LOG.debug("Creating folder " + target.getName().getPath());
        target.createFolder();
        TransferOperation.setPermissions(target, true, context, true);
        context.incCounter("transfer.details.foldersCreated");
        context.addAffectedRoot(target.getName(), context.isServerSideModification());
    }

    private static boolean copyFile(FileObject source, FileObject target, ExecutionContext context) throws FileSystemException {
        boolean accurateTimestamp;
        if (source.getType() == FileType.FOLDER) {
            throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", DeploymentPathUtils.getLocalPath(source)));
        }
        if (target.getType() == FileType.FOLDER) {
            throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", context.getServer().getPresentablePath(target)));
        }
        if (!context.getConfig().isOverwriteAll() && TransferOperation.isUpToDate(source, target, context.getServer())) {
            TransferOperation.createNewRevision(source, target, context);
            String message = WDBundle.message("file.up.to.date", context.getServer().getPresentablePath(target));
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            LOG.debug("Up to date: " + target.getName().getPath());
            context.incCounter("transfer.details.upToDate");
            boolean affected = TransferOperation.setPermissions(target, false, context, true);
            if (affected) {
                context.addAffectedRoot(source.getName(), !context.isServerSideModification());
                context.addAffectedRoot(target.getName(), context.isServerSideModification());
            }
            return true;
        }
        try {
            if (target.exists() && !context.promptForOverwrite(source, target)) {
                String message = WDBundle.message("file.skipped", context.getServer().getPresentablePath(target));
                context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
                LOG.debug("Skipped by user: " + target.getName().getPath());
                context.incCounter("transfer.details.skippedByUser");
                return false;
            }
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider/copy-file.error", new Object[]{source, target}, (Throwable)e);
        }
        TransferOperation.copyFrom(target, source, context);
        TransferOperation.setPermissions(target, false, context, true);
        if (context.getConfig().isPreserveTimestamps()) {
            accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long sourceTimestamp = source.getContent().getLastModifiedTime(accurateTimestamp);
            try {
                target.getContent().setLastModifiedTime(sourceTimestamp);
            }
            catch (FileSystemException e) {
                if (PublishUtils.isFatal(e)) {
                    throw e;
                }
                context.getConfig().setPreserveTimestamps(false);
                LOG.warn("Failed to set timestamp of a file " + target.getName().getPath(), (Throwable)e);
                String path = context.isServerSideModification() ? context.getServer().getPresentablePath(target) : DeploymentPathUtils.getLocalPath(target);
                String message = WDBundle.message("failed.to.set.timestamp", path);
                context.console(message, ConsoleViewContentType.ERROR_OUTPUT);
                if (context.isMultipleOperations()) {
                    message = message + "\n" + WDBundle.message("timestamps.wont.be.preserved", new Object[0]);
                }
                context.showBalloon(message, MessageType.WARNING);
            }
        }
        if (context.getConfig().getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE) {
            accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            try {
                ThrowableComputable revisionFactory;
                FileObject localFile = context.isServerSideModification() ? source : target;
                FileObject remotefile = context.isServerSideModification() ? target : source;
                long timestamp = remotefile.getContent().getLastModifiedTime(accurateTimestamp);
                if (localFile.getContent().getSize() <= DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
                    revisionFactory = () -> new DeploymentRevisionTracker.Revision(timestamp, FileTransferUtil.getContent(localFile, context.getProgressIndicator()));
                } else {
                    LOG.warn("File " + DeploymentPathUtils.getLocalPath(localFile) + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
                    revisionFactory = null;
                }
                context.getRevisionTracker().putBaseRevision(DeploymentPathUtils.getLocalPath(localFile), context.getServer(), (ThrowableComputable<DeploymentRevisionTracker.Revision, IOException>)revisionFactory);
            }
            catch (IOException e) {
                LOG.warn("Failed to load content of local file " + source.getName().getPath(), (Throwable)e);
            }
        }
        LOG.debug("Transferred: " + source.getName().getPath());
        context.incCounter("transfer.details.transferred");
        context.incBytesTransmitted(source.getContent().getSize());
        context.addAffectedRoot(target.getName(), context.isServerSideModification());
        return true;
    }

    private static void createNewRevision(FileObject source, FileObject target, @NotNull ExecutionContext context) throws FileSystemException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/webDeployment/TransferOperation", "createNewRevision"));
        }
        Project project = context.getProject();
        if (project == null) {
            return;
        }
        FileObject local = context.isServerSideModification() ? source : target;
        boolean accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
        long timestamp = source.getContent().getLastModifiedTime(accurateTimestamp);
        try {
            RemoteChangeNotifier.createRevision(project, DeploymentPathUtils.getLocalPath(local), RemoteChangeNotifier.getContent(local, context.getProgressIndicator(), true), timestamp, context.getServer());
        }
        catch (IOException e) {
            LOG.warn("Failed to create revision of of local file " + source.getName().getPath(), (Throwable)e);
        }
    }

    private static void copyFrom(FileObject target, FileObject source, ExecutionContext context) throws FileSystemException {
        LOG.assertTrue(!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        if (!source.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)source);
        }
        assert (source.getType() == FileType.FILE) : "Came " + source.getType();
        if (target.exists() && target.getType() != source.getType()) {
            target.delete(Selectors.SELECT_ALL);
        }
        try {
            FileTransferUtil.copyContent(source, target, context);
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider/copy-file.error", new Object[]{source, target}, (Throwable)e);
        }
    }

    private static void delete(FileObject target, ExecutionContext context, boolean removeRevision) throws FileSystemException {
        if (target.exists()) {
            LOG.debug("Deleting (recursively) " + target.getName().getPath());
            try {
                if (!context.promptForOverwrite(null, target)) {
                    String message = WDBundle.message("file.skipped", context.getServer().getPresentablePath(target));
                    context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
                    LOG.debug("Skipped by user: " + target.getName().getPath());
                    context.incCounter("transfer.details.skippedByUser");
                    return;
                }
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/delete.error", (Object)target, (Throwable)e);
            }
            if (!context.isMultipleOperations()) {
                context.getProgressIndicator().setIndeterminate(true);
            }
            try {
                target.delete((FileSelector)new CancellableAllFileSelector(context.getProgressIndicator(), "deleting.0", context.isCancellable()));
                if (removeRevision && context.getConfig().getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE) {
                    DeploymentPathMapping mapping;
                    String localPath = context.isServerSideModification() ? ((mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingDeploy2Local(target, false, context.getServer()).getFirst()) != null ? mapping.mapToLocalPath(target, context.getServer()) : null) : DeploymentPathUtils.getLocalPath(target);
                    if (localPath != null) {
                        try {
                            context.getRevisionTracker().putBaseRevision(localPath, context.getServer(), null);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                if (PublishUtils.isProcessCanceledException(e)) {
                    throw new ProcessCanceledException();
                }
                throw e;
            }
        }
        context.incCounter("transfer.details.deleted");
        context.addAffectedRoot(target.getName().getParent(), context.isServerSideModification());
    }

    public static boolean areTimestampsEqual(long ts1, long ts2, double accuracy) {
        long delta = Math.abs(ts1 - ts2);
        return accuracy > 0.0 ? (double)delta < accuracy : delta == 0L;
    }

    public static class ChangePermissions
    extends TransferOperation {
        private FileObject myTarget;
        private final boolean myIsDirectory;

        public ChangePermissions(FileObject target) throws FileSystemException {
            this.myTarget = target;
            this.myIsDirectory = this.myTarget.getType() == FileType.FOLDER;
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("changing.0.permissions", this.myTarget.getName().getBaseName());
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("change.permissions.detailed", this.myIsDirectory ? 2 : 1, context.getServer().getPresentablePath(this.myTarget), Util.getPermissionsAsString(this.myIsDirectory ? context.getConfig().getFolderPermissions() : context.getConfig().getFilePermissions()));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            TransferOperation.setPermissions(this.myTarget, this.myIsDirectory, context, context.isTolerateSetPermissionsErrors());
            context.incCounter("transfer.details.processed");
            context.addAffectedRoot(this.myTarget.getName(), context.isServerSideModification());
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            return WDBundle.message("failed.to.change.permissions", this.myIsDirectory ? 2 : 1, context.getServer().getPresentablePath(this.myTarget), StringUtil.decapitalize((String)reason));
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        public String toString() {
            return "Chmod " + this.myTarget.getName().getURI();
        }
    }

    public static class RemoteMove
    extends TransferOperation {
        private final boolean myIsDirectory;
        private FileObject myRemoteSource;
        private FileObject myRemoteTarget;
        private final boolean myForceOverriding;
        private final boolean myIsRename;

        public RemoteMove(FileObject remoteSource, FileObject remoteTarget, boolean isDirectory, boolean forceOverwriting) {
            this.myIsDirectory = isDirectory;
            this.myRemoteSource = remoteSource;
            this.myRemoteTarget = remoteTarget;
            this.myForceOverriding = forceOverwriting;
            this.myIsRename = DeploymentPathUtils.getParentPath(this.myRemoteSource.getName().getPath()).equals(DeploymentPathUtils.getParentPath(this.myRemoteTarget.getName().getPath()));
        }

        @Override
        public void prepare(ExecutionContext context) throws FileSystemException {
            if (!this.myForceOverriding && this.myRemoteTarget.exists()) {
                throw new CustomFileSystemException(WDBundle.message("file.0.already.exists", StringUtil.capitalize((String)WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0])), context.getServer().getPresentablePath(this.myRemoteTarget)));
            }
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message(this.myIsRename ? "renaming.0" : "moving.0", this.myRemoteSource.getName().getBaseName());
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTarget);
            String sourcePath = context.getServer().getPresentablePath(this.myRemoteSource);
            return WDBundle.message(this.myIsRename ? "rename.0.1.to.2" : "move.0.1.to.2", WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0]), sourcePath, targetPath);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            TransferOperation.move(context, this.myRemoteSource, this.myRemoteTarget);
            Project project = context.getProject();
            if (project != null && !project.isDefault()) {
                RemoteChangeNotifier notifier = RemoteChangeNotifier.getInstance(project);
                notifier.updateNotificationsForRemoteItem(this.myRemoteSource, context.getConfig(), context.getServer());
                notifier.updateNotificationsForRemoteItem(this.myRemoteTarget, context.getConfig(), context.getServer());
            }
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTarget);
            String sourcePath = context.getServer().getPresentablePath(this.myRemoteSource);
            return WDBundle.message(this.myIsRename ? "rename.failed" : "move.failed", WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0]), sourcePath, targetPath, StringUtil.decapitalize((String)reason));
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        public String toString() {
            return "Remote move: " + this.myRemoteSource.getName().getPath() + " to " + this.myRemoteTarget.getName().getPath();
        }
    }

    public static class RemoteMoveOrUpload
    extends TransferOperation {
        private String myLocalTargetPath;
        private WebServerConfig.RemotePath myRemoteSourcePath;
        private WebServerConfig.RemotePath myRemoteTargetPath;
        private final boolean myIsDirectory;
        private final boolean myIsRename;
        private boolean myRemoteSourceExists;
        private FileObject myRemoteSource;
        private FileObject myRemoteTarget;

        public RemoteMoveOrUpload(String localTargetPath, WebServerConfig.RemotePath remoteSourcePath, WebServerConfig.RemotePath remoteTargetPath, boolean isDirectory) {
            this.myLocalTargetPath = localTargetPath;
            this.myRemoteSourcePath = remoteSourcePath;
            this.myRemoteTargetPath = remoteTargetPath;
            this.myIsDirectory = isDirectory;
            this.myIsRename = DeploymentPathUtils.getParentPath(this.myRemoteSourcePath).equals(DeploymentPathUtils.getParentPath(this.myRemoteTargetPath));
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
            this.myLocalTargetPath = RemoteMoveOrUpload.updateOnParentMove(this.myLocalTargetPath, sourceFrom, sourceTo, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void prepare(ExecutionContext context) throws FileSystemException {
            this.myRemoteSource = context.findRemoteFile(this.myRemoteSourcePath, true);
            this.myRemoteSourceExists = this.myRemoteSource.exists();
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            if (this.myRemoteSourceExists) {
                return WDBundle.message(this.myIsRename ? "renaming.0" : "moving.0", DeploymentPathUtils.getFileName(this.myRemoteSourcePath));
            }
            if (this.myIsDirectory) {
                return WDBundle.message("creating.folder.0", DeploymentPathUtils.getFileName(this.myRemoteTargetPath));
            }
            return WDBundle.message("uploading.0", DeploymentPathUtils.getFileName(this.myRemoteTargetPath));
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTargetPath);
            if (this.myRemoteSourceExists) {
                String sourcePath = context.getServer().getPresentablePath(this.myRemoteSourcePath);
                return WDBundle.message(this.myIsRename ? "rename.0.1.to.2" : "move.0.1.to.2", WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0]), sourcePath, targetPath);
            }
            if (this.myIsDirectory) {
                return WDBundle.message("create.folder.0.detailed", targetPath);
            }
            return WDBundle.message("upload.0.to.1", this.myLocalTargetPath, targetPath);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            LOG.assertTrue(context.isServerSideModification());
            FileObject localTarget = DeploymentPathUtils.getLocalFile(this.myLocalTargetPath);
            this.myRemoteTarget = context.findRemoteFile(this.myRemoteTargetPath, true);
            RemoteChangeNotifier notifier = null;
            Project project = context.getProject();
            if (project != null && !project.isDefault()) {
                notifier = RemoteChangeNotifier.getInstance(project);
            }
            if (this.myRemoteSourceExists) {
                FileObject remoteTargetParent = this.myRemoteTarget.getParent();
                if (!remoteTargetParent.exists()) {
                    TransferOperation.createFolder(remoteTargetParent, context);
                }
                if (this.myIsDirectory || RemoteMoveOrUpload.isUpToDate(localTarget, this.myRemoteSource, context.getServer())) {
                    TransferOperation.move(context, this.myRemoteSource, this.myRemoteTarget);
                    if (notifier != null) {
                        notifier.updateNotificationsForRemoteItem(this.myRemoteSource, context.getConfig(), context.getServer());
                        notifier.updateNotificationsForRemoteItem(this.myRemoteTarget, context.getConfig(), context.getServer());
                    }
                } else {
                    TransferOperation.delete(this.myRemoteSource, context, false);
                    TransferOperation.copyFile(localTarget, this.myRemoteTarget, context);
                    if (notifier != null) {
                        notifier.updateNotificationsForRemoteItem(this.myRemoteSource, context.getConfig(), context.getServer());
                        notifier.updateNotificationsForRemoteItem(this.myRemoteTarget, context.getConfig(), context.getServer());
                    }
                }
            } else if (this.myIsDirectory) {
                TransferOperation.createFolder(this.myRemoteTarget, context);
            } else {
                TransferOperation.copyFile(localTarget, this.myRemoteTarget, context);
                if (notifier != null) {
                    notifier.updateNotificationsForLocalItem(localTarget, context);
                }
            }
        }

        public FileObject getSource() {
            return this.myRemoteSource;
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTargetPath);
            if (this.myRemoteSourceExists) {
                String sourcePath = context.getServer().getPresentablePath(this.myRemoteSourcePath);
                return WDBundle.message(this.myIsRename ? "rename.failed" : "move.failed", WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0]), sourcePath, targetPath, StringUtil.decapitalize((String)reason));
            }
            if (this.myIsDirectory) {
                return WDBundle.message("failed.to.create.folder", targetPath, StringUtil.decapitalize((String)reason));
            }
            return WDBundle.message("file.transfer.failed", targetPath, StringUtil.decapitalize((String)reason));
        }

        public String toString() {
            return "Remote move or upload: " + this.myRemoteSourcePath + " to " + this.myRemoteTargetPath;
        }
    }

    public static class CreateFolder
    extends TransferOperation {
        private FileObject myTarget;
        private WebServerConfig.RemotePath myTargetPath;

        public CreateFolder(FileObject target) {
            this.myTarget = target;
        }

        public CreateFolder(WebServerConfig.RemotePath targetPath) {
            this.myTargetPath = targetPath;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            String name = this.myTarget != null ? this.myTarget.getName().getBaseName() : DeploymentPathUtils.getFileName(this.myTargetPath);
            return WDBundle.message("creating.folder.0", name);
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            String path = context.isServerSideModification() ? (this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath)) : DeploymentPathUtils.getLocalPath(this.myTarget);
            return WDBundle.message("create.folder.0.detailed", path);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.myTarget == null) {
                this.myTarget = context.findRemoteFile(this.myTargetPath, true);
            }
            TransferOperation.createFolder(this.myTarget, context);
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            String path = this.myTargetPath != null ? context.getServer().getPresentablePath(this.myTargetPath) : DeploymentPathUtils.getLocalPath(this.myTarget);
            return WDBundle.message("failed.to.create.folder", path, StringUtil.decapitalize((String)reason));
        }

        public String toString() {
            return "Create folder " + (this.myTarget != null ? this.myTarget.getName().getURI() : this.myTargetPath);
        }
    }

    public static class Delete
    extends TransferOperation {
        private FileObject myTarget;
        private WebServerConfig.RemotePath myTargetPath;
        private final boolean myIsDirectory;
        private final boolean myDeleteRevision;

        public Delete(FileObject target, boolean isDirectory, boolean deleteRevision) {
            this.myTarget = target;
            this.myIsDirectory = isDirectory;
            this.myDeleteRevision = deleteRevision;
        }

        public Delete(WebServerConfig.RemotePath targetPath, boolean isDirectory, boolean deleteRevision) {
            this.myTargetPath = targetPath;
            this.myIsDirectory = isDirectory;
            this.myDeleteRevision = deleteRevision;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            String name = this.myTarget != null ? this.myTarget.getName().getBaseName() : DeploymentPathUtils.getFileName(this.myTargetPath);
            return WDBundle.message("deleting.0", name);
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            String path = context.isServerSideModification() ? (this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath)) : (this.myTarget != null ? DeploymentPathUtils.getLocalPath(this.myTarget) : this.myTargetPath.path);
            return WDBundle.message("delete.0.detailed", this.myIsDirectory ? 2 : 1, path);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.myTarget == null) {
                this.myTarget = context.findRemoteFile(this.myTargetPath, true);
            }
            TransferOperation.delete(this.myTarget, context, this.myDeleteRevision);
            Project project = context.getProject();
            if (project != null && !project.isDefault() && !project.isDisposed()) {
                RemoteChangeNotifier.getInstance(project).updateNotificationsForRemoteItem(this.myTarget, context.getConfig(), context.getServer());
            }
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            String path = this.myTargetPath != null ? context.getServer().getPresentablePath(this.myTargetPath) : DeploymentPathUtils.getLocalPath(this.myTarget);
            return WDBundle.message("failed.to.delete", this.myIsDirectory ? 2 : 1, path, StringUtil.decapitalize((String)reason));
        }

        public String toString() {
            return "Delete " + (this.myTarget != null ? this.myTarget.getName().getURI() : this.myTargetPath);
        }
    }

    public static class Copy
    extends TransferOperation {
        protected FileObject mySource;
        protected FileObject myTarget;
        private WebServerConfig.RemotePath myTargetPath;
        protected boolean mySuccessfullyFinished;

        public Copy(FileObject source, FileObject target) {
            this.mySource = source;
            this.myTarget = target;
        }

        public Copy(FileObject source, WebServerConfig.RemotePath targetPath) {
            this.mySource = source;
            this.myTargetPath = targetPath;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
            this.mySource = Copy.updateOnParentMove(this.mySource, sourceFrom, sourceTo);
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message(context.isServerSideModification() ? "uploading.0" : "downloading.0", this.mySource.getName().getBaseName());
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            if (context.isServerSideModification()) {
                String targetPath = this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath);
                return WDBundle.message("upload.0.to.1", DeploymentPathUtils.getLocalPath(this.mySource), targetPath);
            }
            return WDBundle.message("download.0.to.1", context.getServer().getPresentablePath(this.mySource), DeploymentPathUtils.getLocalPath(this.myTarget));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.myTarget == null) {
                this.myTarget = context.findRemoteFile(this.myTargetPath, true);
            }
            this.mySuccessfullyFinished = TransferOperation.copyFile(this.mySource, this.myTarget, context);
            Project project = context.getProject();
            if (project != null && !project.isDefault() && !project.isDisposed()) {
                RemoteChangeNotifier notifier = RemoteChangeNotifier.getInstance(project);
                if (context.isServerSideModification()) {
                    notifier.updateNotificationsForLocalItem(this.mySource, context);
                } else {
                    notifier.updateNotificationsForLocalItem(this.myTarget, context);
                }
            }
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            String path = context.isServerSideModification() ? DeploymentPathUtils.getLocalPath(this.mySource) : context.getServer().getPresentablePath(this.mySource);
            return WDBundle.message("file.transfer.failed", path, StringUtil.decapitalize((String)reason));
        }

        public String toString() {
            return "Copy: " + this.mySource.getName().getURI() + " to " + (this.myTarget != null ? this.myTarget.getName().getURI() : this.myTargetPath);
        }
    }

    public static class CreateRemoteFile
    extends TransferOperation {
        private final String myContent;
        private FileObject myTarget;

        public CreateRemoteFile(@NotNull String fileContent, FileObject target) {
            if (fileContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/jetbrains/plugins/webDeployment/TransferOperation$CreateRemoteFile", "<init>"));
            }
            this.myContent = fileContent;
            this.myTarget = target;
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("creating.0", this.myTarget.getName().getBaseName());
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("create.0.detailed", context.getServer().getPresentablePath(this.myTarget));
        }

        @Override
        public String getErrorMessage(ExecutionContext context, String reason) {
            return WDBundle.message("create.failed", context.getServer().getPresentablePath(this.myTarget), StringUtil.decapitalize((String)reason));
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            LOG.assertTrue(context.isServerSideModification());
            if (this.myTarget.getType() == FileType.FOLDER) {
                throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", context.getServer().getPresentablePath(this.myTarget)));
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.myTarget.getContent().getOutputStream());
            try {
                writer.write(this.myContent);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            TransferOperation.setPermissions(this.myTarget, false, context, true);
            LOG.debug("File " + this.myTarget.getName().getURI() + " was created with given content");
            context.incCounter("transfer.details.transferred");
            context.incBytesTransmitted(this.myContent.length());
            context.addAffectedRoot(this.myTarget.getName().getParent(), true);
        }

        public String toString() {
            return "Create file at " + this.myTarget.getName().getURI();
        }
    }
}

