/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.UploadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nullable;

public class DownloadAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)DownloadAction.class.getName());

    public void update(AnActionEvent e) {
        WebServerConfig server = DownloadAction.isEnabled(e);
        if (WebDeploymentDataKeys.SERVER_TREE.getData(e.getDataContext()) != null) {
            e.getPresentation().setText(WDBundle.message("action.title.download.from.here", new Object[0]));
        } else if (server != null) {
            e.getPresentation().setText(WDBundle.message("action.title.download", server.getName()));
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(server != null);
        } else {
            e.getPresentation().setEnabled(server != null);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        WebServerConfig server;
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        final VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        final FileObject[] remoteFiles = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext());
        final RemoteConnection connection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData(e.getDataContext());
        if (files != null) {
            server = publishConfig.findDefaultServer();
            LOG.assertTrue(server != null);
            VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files);
            AutoUploadComponent.saveDocumentsSilently(project, (Collection<VirtualFile>)roots);
        } else {
            LOG.assertTrue(remoteFiles != null && connection != null);
            server = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(e.getDataContext());
            LOG.assertTrue(server != null);
            AutoUploadComponent.saveDocumentsSilently(project, UploadFilesAction.getLocalRoots(publishConfig, remoteFiles, server));
        }
        String title = WDBundle.message("download.from", server.getName());
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
        ProgressManager.getInstance().run((Task)new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), false, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

            @Override
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                if (files != null) {
                    return DownloadAction.scanFiles(context, (Collection<VirtualFile>)new VfsUtilCore.DistinctVFilesRootsCollection(files));
                }
                DistinctRootsCollections.FileObjects downloadRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
                ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
                Iterator iterator = downloadRoots.iterator();
                while (iterator.hasNext()) {
                    FileObject downloadRoot = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(downloadRoot, context);
                    DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processOutgoing(downloadRoot, result, context);
                    errors.addAll(e);
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errors);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        });
    }

    public static TransferTask.ListBased.ResultWithErrors scanFiles(ExecutionContext context, Collection<VirtualFile> roots) throws FileSystemException {
        ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
        DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
        for (VirtualFile root : roots) {
            DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming(DeploymentPathUtils.getLocalFile(root.getPath()), context, result);
            errors.addAll(e);
        }
        return new TransferTask.ListBased.ResultWithErrors(result, errors);
    }

    @Nullable
    private static WebServerConfig isEnabled(AnActionEvent e) {
        FileObject[] nodes;
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            return null;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files != null) {
            WebServerConfig server = publishConfig.findDefaultServer();
            if (server == null || !server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
                return null;
            }
            VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files);
            for (VirtualFile root : roots) {
                if (!PublishActionUtil.checkMapping(publishConfig, server, root.getPath(), true)) continue;
                return server;
            }
        }
        if ((nodes = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext())) != null) {
            WebServerConfig server = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(e.getDataContext());
            LOG.assertTrue(server != null);
            if (server.getFileTransferConfig().validateFast() != null) {
                return null;
            }
            for (FileObject node : nodes) {
                if (publishConfig.getNearestMappingDeploy2Local(node, false, server).getFirst() == null && ((List)publishConfig.getChildMappingsDeploy2Local(node, server).getFirst()).isEmpty()) continue;
                return server;
            }
        }
        return null;
    }
}

