/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ultimate.UltimateVerifier;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExtendedNotificationBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.Component;
import java.util.Collections;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;

public class RemoteRenameAction
extends DumbAwareAction {
    public RemoteRenameAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        boolean b = RemoteRenameAction.isEnabled(e.getDataContext());
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(b);
        } else {
            e.getPresentation().setEnabled(b);
        }
    }

    private static boolean isEnabled(DataContext context) {
        ServerTreeNode[] serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(context);
        if (serverNodes == null || serverNodes.length != 1) {
            return false;
        }
        ServerTreeNode fileToRename = serverNodes[0];
        return !fileToRename.isRoot();
    }

    public void actionPerformed(AnActionEvent e) {
        String nameToRename;
        final RemoteConnection connection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData(e.getDataContext());
        FileObject[] serverObjects = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext());
        if (serverObjects == null || serverObjects.length != 1) {
            return;
        }
        final FileObject fileToRenameObject = serverObjects[0];
        String oldName = fileToRenameObject.getName().getBaseName();
        final ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(e.getDataContext()));
        final WebServerConfig server = (WebServerConfig)WebDeploymentDataKeys.SERVER_CONFIG.getData(e.getDataContext());
        Project project = e.getProject();
        boolean isModalContext = (Boolean)PlatformDataKeys.IS_MODAL_CONTEXT.getData(e.getDataContext());
        String newName = Messages.showInputDialog((Component)((Object)tree), (String)WDBundle.message("enter.new.name.for.0", oldName), (String)WDBundle.message("rename.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)oldName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                if (StringUtil.isEmpty((String)inputString)) {
                    return false;
                }
                return inputString.indexOf("\\") == -1 && inputString.indexOf("/") == -1;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        if (newName != null && !oldName.equals(nameToRename = newName.trim())) {
            PublishConfig publishConfig = project != null ? PublishConfig.getInstance(project) : new PublishConfig(null, UltimateVerifier.getInstance());
            new ExtendedNotificationBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project, (Component)((Object)tree)), publishConfig, server, WDBundle.message("rename.server.node", oldName, newName), isModalContext, (Component)((Object)tree), WDBundle.message("rename.task.title", new Object[0]), DeploymentRevisionTracker.DEAF, true, true){

                @Override
                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) {
                    TransferOperation.RemoteMove operation;
                    context.getProgressIndicator().checkCanceled();
                    context.getProgressIndicator().setText(WDBundle.message("processing.0", server.getPresentablePath(fileToRenameObject)));
                    try {
                        FileObject parent = fileToRenameObject.getParent();
                        final FileObject newFile = parent.resolveFile(nameToRename, NameScope.CHILD);
                        operation = new TransferOperation.RemoteMove(fileToRenameObject, newFile, fileToRenameObject.getType() == FileType.FOLDER, false){

                            @Override
                            public void execute(ExecutionContext context) throws FileSystemException {
                                super.execute(context);
                                context.scheduleForSelection(server.getRemotePath(newFile), (Object)tree);
                            }
                        };
                    }
                    catch (FileSystemException ex) {
                        return new TransferTask.ListBased.ResultWithErrors(Collections.emptyList(), new DeploymentPathUtils.ErrorsAndExclusions());
                    }
                    return new TransferTask.ListBased.ResultWithErrors(Collections.singletonList(operation), new DeploymentPathUtils.ErrorsAndExclusions());
                }

                @Override
                protected RemoteConnection getExistingConnection() {
                    return connection;
                }
            }.queue();
        }
    }
}

