/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteEditedFileBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditedFileBrowserUrlProvider", "canHandleElement"));
        }
        return request.getVirtualFile() instanceof RemoteVirtualFile;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile virtualFile) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditedFileBrowserUrlProvider", "getUrl"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditedFileBrowserUrlProvider", "getUrl"));
        }
        PublishConfig publishConfig = PublishConfig.getInstance(request.getProject());
        if (!(virtualFile instanceof RemoteVirtualFile)) {
            return null;
        }
        RemoteVirtualFile file = (RemoteVirtualFile)virtualFile;
        WebServerConfig server = file.getServerConfig();
        if (server == null || server.validateUrl() != null) {
            return null;
        }
        Pair<DeploymentPathMapping, Boolean> mapping = publishConfig.getNearestMappingDeploy2Local(((RemoteVirtualFile)virtualFile).getRemotePath(), false, server, true, false, true);
        if (mapping.getFirst() == null) {
            return null;
        }
        String webPath = ((DeploymentPathMapping)mapping.getFirst()).mapToWebPath(((RemoteVirtualFile)virtualFile).getRemotePath(), server);
        if (webPath == null) {
            return null;
        }
        String url = DeploymentPathUtils.joinWebPath(server.getUrl(), webPath);
        return url == null ? null : Urls.parseFromIdea((CharSequence)url);
    }

    @Nullable
    public static Url getUrl(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditedFileBrowserUrlProvider", "getUrl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditedFileBrowserUrlProvider", "getUrl"));
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        WebServerConfig server = publishConfig.findDefaultServer();
        String url = publishConfig.mapToWebPath(file.getPath(), server);
        return url == null ? null : Urls.parseFromIdea((CharSequence)url);
    }
}

