/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteReadOnlyVirtualFile
extends VirtualFile {
    private final String myName;
    private final String myPath;
    private final byte[] myContent;
    private final boolean myIsDirectory;

    public RemoteReadOnlyVirtualFile(FileObject file, byte[] content, boolean isDirectory) {
        this.myName = file.getName().getBaseName();
        this.myPath = file.getName().getPath();
        this.myContent = content;
        this.myIsDirectory = isDirectory;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile", "getName"));
        }
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        RemoteVirtualFileSystem remoteVirtualFileSystem = RemoteVirtualFileSystem.INSTANCE;
        if (remoteVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile", "getFileSystem"));
        }
        return remoteVirtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return new VirtualFile[0];
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("getOutputStream is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile", "contentsToByteArray"));
        }
        return this.myContent;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return this.myContent.length;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    public long getModificationStamp() {
        return 0L;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("getInputStream is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    private static class RemoteVirtualFileSystem
    extends DeprecatedVirtualFileSystem {
        private static final RemoteVirtualFileSystem INSTANCE = new RemoteVirtualFileSystem();

        private RemoteVirtualFileSystem() {
        }

        @NotNull
        public String getProtocol() {
            if ("rvfs" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile$RemoteVirtualFileSystem", "getProtocol"));
            }
            return "rvfs";
        }

        public VirtualFile findFileByPath(@NotNull @NonNls String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile$RemoteVirtualFileSystem", "findFileByPath"));
            }
            return null;
        }

        public void refresh(boolean asynchronous) {
        }

        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/ui/RemoteReadOnlyVirtualFile$RemoteVirtualFileSystem", "refreshAndFindFileByPath"));
            }
            return null;
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

