/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import java.io.File;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

public class PathConverter {
    private static final char UNIX_SEPARATOR = '/';
    private static final String UNIX_SEPARATOR_STR = String.valueOf('/');

    private PathConverter() {
    }

    public static String getNormalizedPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/coverage/PathConverter", "getNormalizedPath"));
        }
        URI uri = file.toURI();
        URI normalizedUri = uri.normalize();
        String normalizedPath = normalizedUri.getPath();
        if (normalizedPath.startsWith(UNIX_SEPARATOR_STR) && File.separatorChar != '/') {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }
}

