/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;
import org.junit.vintage.engine.discovery.UniqueIdFilter;

class UniqueIdSelectorResolver
extends DiscoverySelectorResolver<UniqueIdSelector> {
    private final Logger logger;

    UniqueIdSelectorResolver(Logger logger) {
        super(UniqueIdSelector.class);
        this.logger = logger;
    }

    @Override
    void resolve(UniqueIdSelector selector, TestClassCollector collector) {
        UniqueId uniqueId = selector.getUniqueId();
        if (UniqueId.forEngine((String)"junit-vintage").equals((Object)uniqueId)) {
            this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Cannot resolve the engine's unique ID", uniqueId));
        } else {
            uniqueId.getEngineId().ifPresent(engineId -> {
                if (engineId.equals("junit-vintage")) {
                    String testClassName = this.determineTestClassName(uniqueId);
                    this.resolveIntoFilteredTestClass(testClassName, uniqueId, collector);
                }
            });
        }
    }

    private void resolveIntoFilteredTestClass(String testClassName, UniqueId uniqueId, TestClassCollector collector) {
        Optional testClass = ReflectionUtils.loadClass((String)testClassName);
        if (testClass.isPresent()) {
            collector.addFiltered((Class)testClass.get(), new UniqueIdFilter(uniqueId));
        } else {
            this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Unknown class %s", uniqueId, testClassName));
        }
    }

    private String determineTestClassName(UniqueId uniqueId) {
        List segments = uniqueId.getSegments();
        segments.remove(0);
        UniqueId.Segment runnerSegment = (UniqueId.Segment)segments.remove(0);
        return runnerSegment.getValue();
    }
}

