/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.highlighting;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.security.model.xml.converters.InterceptUrlAccessWrappingConverter;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringSecuritySpElAccessInjector
implements MultiHostInjector {
    public static final XmlAttributeValuePattern ACCESS_ATTR_PATTERN = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"access"}).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(new String[]{"intercept-url", "intercept-message", "authorize"})).withNamespace("http://www.springframework.org/schema/security"));

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/security/highlighting/SpringSecuritySpElAccessInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/security/highlighting/SpringSecuritySpElAccessInjector", "getLanguagesToInject"));
        }
        PsiFile containingFile = host.getContainingFile();
        if (!JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        if (ACCESS_ATTR_PATTERN.accepts((Object)host, context)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
            if (!InterceptUrlAccessWrappingConverter.useRoleConverter(((XmlAttributeValue)host).getValue(), module)) {
                registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.from((int)1, (int)(host.getTextLength() - 2))).doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/highlighting/SpringSecuritySpElAccessInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

