/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.core.util.BindingKeyParser;
import org.eclipse.jdt.internal.core.util.BindingKeyResolver;

public class BindingKeyResolver
extends BindingKeyParser {
    Compiler compiler;
    Binding compilerBinding;
    char[][] compoundName;
    int dimension;
    LookupEnvironment environment;
    ReferenceBinding genericType;
    MethodBinding methodBinding;
    CompilationUnitDeclaration parsedUnit;
    BlockScope scope;
    TypeBinding typeBinding;
    TypeDeclaration typeDeclaration;
    ArrayList types = new ArrayList();
    int rank = 0;
    int wildcardRank;
    CompilationUnitDeclaration outerMostParsedUnit;

    private BindingKeyResolver(BindingKeyParser parser, Compiler compiler, LookupEnvironment environment, int wildcardRank, CompilationUnitDeclaration outerMostParsedUnit) {
        super(parser);
        this.compiler = compiler;
        this.environment = environment;
        this.wildcardRank = wildcardRank;
        this.outerMostParsedUnit = outerMostParsedUnit;
    }

    public BindingKeyResolver(String key) {
        this(key, null, null);
    }

    public BindingKeyResolver(String key, Compiler compiler, LookupEnvironment environment) {
        super(key);
        this.compiler = compiler;
        this.environment = environment;
    }

    public char[][] compoundName() {
        return this.compoundName;
    }

    public void consumeArrayDimension(char[] brakets) {
        this.dimension = brakets.length;
    }

    public void consumeBaseType(char[] baseTypeSig) {
        this.compoundName = new char[][]{this.getKey().toCharArray()};
        TypeBinding baseTypeBinding = this.getBaseTypeBinding(baseTypeSig);
        if (baseTypeBinding != null) {
            this.typeBinding = baseTypeBinding;
        }
    }

    public void consumeCapture(int position) {
        CompilationUnitDeclaration outerParsedUnit;
        CompilationUnitDeclaration compilationUnitDeclaration = outerParsedUnit = this.outerMostParsedUnit == null ? this.parsedUnit : this.outerMostParsedUnit;
        if (outerParsedUnit == null) {
            return;
        }
        Binding wildcardBinding = ((BindingKeyResolver)this.types.get((int)0)).compilerBinding;
        class CaptureFinder
        extends ASTVisitor {
            CaptureBinding capture;
            final /* synthetic */ BindingKeyResolver this$0;
            private final /* synthetic */ int val$position;
            private final /* synthetic */ Binding val$wildcardBinding;

            CaptureFinder(BindingKeyResolver bindingKeyResolver, int n, Binding binding) {
                this.this$0 = bindingKeyResolver;
                this.val$position = n;
                this.val$wildcardBinding = binding;
            }

            boolean checkType(TypeBinding binding) {
                if (binding == null) {
                    return false;
                }
                switch (binding.kind()) {
                    case 260: {
                        TypeBinding[] arguments = ((ParameterizedTypeBinding)binding).arguments;
                        if (arguments == null) {
                            return false;
                        }
                        int i = 0;
                        int length = arguments.length;
                        while (i < length) {
                            if (this.checkType(arguments[i])) {
                                return true;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 516: {
                        return this.checkType(((WildcardBinding)binding).bound);
                    }
                    case 68: {
                        return this.checkType(((ArrayBinding)binding).leafComponentType);
                    }
                    case 4100: {
                        if (!binding.isCapture()) break;
                        CaptureBinding captureBinding = (CaptureBinding)binding;
                        if (captureBinding.position != this.val$position || captureBinding.wildcard != this.val$wildcardBinding) break;
                        this.capture = captureBinding;
                        return true;
                    }
                }
                return false;
            }

            public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
                if (this.checkType(singleNameReference.resolvedType)) {
                    return false;
                }
                return super.visit(singleNameReference, blockScope);
            }

            public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope blockScope) {
                if (this.checkType(qualifiedNameReference.resolvedType)) {
                    return false;
                }
                return super.visit(qualifiedNameReference, blockScope);
            }

            public boolean visit(MessageSend messageSend, BlockScope blockScope) {
                if (this.checkType(messageSend.resolvedType)) {
                    return false;
                }
                return super.visit(messageSend, blockScope);
            }

            public boolean visit(FieldReference fieldReference, BlockScope blockScope) {
                if (this.checkType(fieldReference.resolvedType)) {
                    return false;
                }
                return super.visit(fieldReference, blockScope);
            }

            public boolean visit(ConditionalExpression conditionalExpression, BlockScope blockScope) {
                if (this.checkType(conditionalExpression.resolvedType)) {
                    return false;
                }
                return super.visit(conditionalExpression, blockScope);
            }

            public boolean visit(CastExpression castExpression, BlockScope blockScope) {
                if (this.checkType(castExpression.resolvedType)) {
                    return false;
                }
                return super.visit(castExpression, blockScope);
            }

            public boolean visit(Assignment assignment, BlockScope blockScope) {
                if (this.checkType(assignment.resolvedType)) {
                    return false;
                }
                return super.visit(assignment, blockScope);
            }

            public boolean visit(ArrayReference arrayReference, BlockScope blockScope) {
                if (this.checkType(arrayReference.resolvedType)) {
                    return false;
                }
                return super.visit(arrayReference, blockScope);
            }
        }
        CaptureFinder captureFinder = new CaptureFinder(this, position, wildcardBinding);
        outerParsedUnit.traverse((ASTVisitor)captureFinder, outerParsedUnit.scope);
        this.typeBinding = captureFinder.capture;
    }

    public void consumeField(char[] fieldName) {
        FieldBinding[] fields = ((ReferenceBinding)this.typeBinding).fields();
        int i = 0;
        int length = fields.length;
        while (i < length) {
            FieldBinding field = fields[i];
            if (CharOperation.equals(fieldName, field.name)) {
                this.typeBinding = null;
                this.compilerBinding = field;
                return;
            }
            ++i;
        }
    }

    public void consumeParameterizedGenericMethod() {
        if (this.methodBinding == null) {
            return;
        }
        TypeBinding[] arguments = this.getTypeBindingArguments();
        this.methodBinding = arguments.length != this.methodBinding.typeVariables().length ? new ParameterizedGenericMethodBinding(this.methodBinding, null, this.environment) : new ParameterizedGenericMethodBinding(this.methodBinding, arguments, this.environment);
        this.compilerBinding = this.methodBinding;
    }

    public void consumeLocalType(char[] uniqueKey) {
        LocalTypeBinding[] localTypeBindings = this.parsedUnit.localTypes;
        int i = 0;
        while (i < this.parsedUnit.localTypeCount) {
            if (CharOperation.equals(uniqueKey, localTypeBindings[i].computeUniqueKey(false))) {
                this.typeBinding = localTypeBindings[i];
                return;
            }
            ++i;
        }
    }

    public void consumeLocalVar(char[] varName) {
        if (this.scope == null) {
            this.scope = this.methodBinding.sourceMethod().scope;
        }
        int i = 0;
        while (i < this.scope.localIndex) {
            LocalVariableBinding local = this.scope.locals[i];
            if (CharOperation.equals(varName, local.name)) {
                this.methodBinding = null;
                this.compilerBinding = local;
                return;
            }
            ++i;
        }
    }

    public void consumeMethod(char[] selector, char[] signature) {
        MethodBinding[] methods = ((ReferenceBinding)this.typeBinding).methods();
        int i = 0;
        int methodLength = methods.length;
        while (i < methodLength) {
            MethodBinding method = methods[i];
            if (CharOperation.equals(selector, method.selector) || selector.length == 0 && method.isConstructor()) {
                char[] methodSignature = method.genericSignature();
                if (methodSignature == null) {
                    methodSignature = method.signature();
                }
                if (CharOperation.equals(signature, methodSignature)) {
                    this.typeBinding = null;
                    this.methodBinding = method;
                    this.compilerBinding = this.methodBinding;
                    return;
                }
            }
            ++i;
        }
    }

    public void consumeMemberType(char[] simpleTypeName) {
        this.typeBinding = this.getTypeBinding(simpleTypeName);
    }

    public void consumePackage(char[] pkgName) {
        this.compoundName = CharOperation.splitOn('/', pkgName);
        this.compilerBinding = new PackageBinding(this.compoundName, null, this.environment);
    }

    public void consumeParameterizedType(char[] simpleTypeName, boolean isRaw) {
        TypeBinding[] arguments = this.getTypeBindingArguments();
        if (simpleTypeName != null) {
            this.genericType = this.genericType == null ? ((ReferenceBinding)this.typeBinding).getMemberType(simpleTypeName) : this.genericType.getMemberType(simpleTypeName);
            this.typeBinding = !isRaw ? this.environment.createParameterizedType(this.genericType, arguments, (ReferenceBinding)this.typeBinding) : this.environment.createRawType(this.genericType, (ReferenceBinding)this.typeBinding);
        } else {
            this.genericType = (ReferenceBinding)this.typeBinding;
            ReferenceBinding enclosing = this.genericType.enclosingType();
            if (enclosing != null) {
                enclosing = (ReferenceBinding)this.environment.convertToRawType(enclosing);
            }
            this.typeBinding = this.environment.createParameterizedType(this.genericType, arguments, enclosing);
        }
    }

    public void consumeParser(BindingKeyParser parser) {
        this.types.add(parser);
        if (((BindingKeyResolver)parser).compilerBinding instanceof WildcardBinding) {
            ++this.rank;
        }
    }

    public void consumeScope(int scopeNumber) {
        if (this.scope == null) {
            this.scope = this.methodBinding.sourceMethod().scope;
        }
        if (scopeNumber >= this.scope.subscopeCount) {
            return;
        }
        this.scope = (BlockScope)this.scope.subscopes[scopeNumber];
    }

    public void consumeRawType() {
        if (this.typeBinding == null) {
            return;
        }
        this.typeBinding = this.environment.convertToRawType(this.typeBinding);
    }

    public void consumeSecondaryType(char[] simpleTypeName) {
        if (this.parsedUnit == null) {
            return;
        }
        this.typeDeclaration = null;
        this.typeBinding = this.getTypeBinding(simpleTypeName);
    }

    public void consumeFullyQualifiedName(char[] fullyQualifiedName) {
        this.compoundName = CharOperation.splitOn('/', fullyQualifiedName);
    }

    public void consumeTopLevelType() {
        this.parsedUnit = this.getCompilationUnitDeclaration();
        if (this.parsedUnit != null && this.compiler != null) {
            this.compiler.process(this.parsedUnit, this.compiler.totalUnits + 1);
        }
        if (this.parsedUnit == null) {
            this.typeBinding = this.getBinaryBinding();
        } else {
            char[] typeName = this.compoundName[this.compoundName.length - 1];
            this.typeBinding = this.getTypeBinding(typeName);
        }
    }

    public void consumeKey() {
        if (this.typeBinding != null) {
            this.typeBinding = this.getArrayBinding(this.dimension, this.typeBinding);
            this.compilerBinding = this.typeBinding;
        }
    }

    public void consumeTypeVariable(char[] position, char[] typeVariableName) {
        if (position.length > 0) {
            int pos = Integer.parseInt(new String(position));
            MethodBinding[] methods = ((ReferenceBinding)this.typeBinding).methods();
            if (methods != null && pos < methods.length) {
                this.methodBinding = methods[pos];
            }
        }
        TypeVariableBinding[] typeVariableBindings = this.methodBinding != null ? this.methodBinding.typeVariables() : this.typeBinding.typeVariables();
        int i = 0;
        int length = typeVariableBindings.length;
        while (i < length) {
            TypeVariableBinding typeVariableBinding = typeVariableBindings[i];
            if (CharOperation.equals(typeVariableName, typeVariableBinding.sourceName())) {
                this.typeBinding = typeVariableBinding;
                return;
            }
            ++i;
        }
    }

    public void consumeTypeWithCapture() {
        BindingKeyResolver resolver = (BindingKeyResolver)this.types.get(0);
        this.typeBinding = (TypeBinding)resolver.compilerBinding;
    }

    public void consumeWildCard(int kind) {
        switch (kind) {
            case 1: 
            case 2: {
                BindingKeyResolver boundResolver = (BindingKeyResolver)this.types.get(0);
                this.typeBinding = this.environment.createWildcard((ReferenceBinding)this.typeBinding, this.wildcardRank, (TypeBinding)boundResolver.compilerBinding, null, kind);
                break;
            }
            case 0: {
                this.typeBinding = this.environment.createWildcard((ReferenceBinding)this.typeBinding, this.rank++, null, null, kind);
            }
        }
    }

    private TypeBinding getArrayBinding(int dim, TypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (dim == 0) {
            return binding;
        }
        return this.environment.createArrayType(binding, dim);
    }

    private TypeBinding getBaseTypeBinding(char[] signature) {
        switch (signature[0]) {
            case 'I': {
                return BaseTypes.IntBinding;
            }
            case 'Z': {
                return BaseTypes.BooleanBinding;
            }
            case 'V': {
                return BaseTypes.VoidBinding;
            }
            case 'C': {
                return BaseTypes.CharBinding;
            }
            case 'D': {
                return BaseTypes.DoubleBinding;
            }
            case 'B': {
                return BaseTypes.ByteBinding;
            }
            case 'F': {
                return BaseTypes.FloatBinding;
            }
            case 'J': {
                return BaseTypes.LongBinding;
            }
            case 'S': {
                return BaseTypes.ShortBinding;
            }
            case 'N': {
                return BaseTypes.NullBinding;
            }
        }
        return null;
    }

    private TypeBinding getBinaryBinding() {
        if (this.compoundName.length == 0) {
            return null;
        }
        return this.environment.getType(this.compoundName);
    }

    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        char[][] name = this.compoundName();
        if (name.length == 0) {
            return null;
        }
        if (this.environment == null) {
            return null;
        }
        ReferenceBinding binding = this.environment.getType(name);
        if (!(binding instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
        if (sourceTypeBinding.scope == null) {
            return null;
        }
        return sourceTypeBinding.scope.compilationUnitScope().referenceContext;
    }

    public Binding getCompilerBinding() {
        this.parse();
        return this.compilerBinding;
    }

    private TypeBinding getTypeBinding(char[] simpleTypeName) {
        TypeDeclaration[] typeDeclarations;
        if (this.typeBinding instanceof BinaryTypeBinding) {
            return ((BinaryTypeBinding)this.typeBinding).getMemberType(simpleTypeName);
        }
        Object object = this.typeDeclaration == null ? (this.parsedUnit == null ? null : this.parsedUnit.types) : (typeDeclarations = this.typeDeclaration.memberTypes);
        if (typeDeclarations == null) {
            return null;
        }
        int i = 0;
        int length = typeDeclarations.length;
        while (i < length) {
            TypeDeclaration declaration = typeDeclarations[i];
            if (CharOperation.equals(simpleTypeName, declaration.name)) {
                this.typeDeclaration = declaration;
                return declaration.binding;
            }
            ++i;
        }
        return null;
    }

    private TypeBinding[] getTypeBindingArguments() {
        int size = this.types.size();
        TypeBinding[] arguments = new TypeBinding[size];
        int i = 0;
        while (i < size) {
            BindingKeyResolver resolver = (BindingKeyResolver)this.types.get(i);
            arguments[i] = (TypeBinding)resolver.compilerBinding;
            ++i;
        }
        this.types = new ArrayList();
        return arguments;
    }

    public void malformedKey() {
        this.compoundName = CharOperation.NO_CHAR_CHAR;
    }

    public BindingKeyParser newParser() {
        return new BindingKeyResolver(this, this.compiler, this.environment, this.rank, this.outerMostParsedUnit == null ? this.parsedUnit : this.outerMostParsedUnit);
    }

    public String toString() {
        return this.getKey();
    }
}

