/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PatternValuesIndex;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;

public class InjectionCache {
    private final CachedValue<Collection<String>> myAnnoIndex;
    private final CachedValue<Collection<String>> myXmlIndex;

    public InjectionCache(Project project, Configuration configuration) {
        this.myXmlIndex = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            THashMap map = new THashMap();
            for (BaseInjection injection : configuration.getInjections("java")) {
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (!place.isEnabled() || place.getElementPattern() == null) continue;
                    map.put(place.getElementPattern(), injection);
                }
            }
            Set stringSet = PatternValuesIndex.buildStringIndex(map.keySet());
            return new CachedValueProvider.Result((Object)stringSet, new Object[]{configuration});
        }, false);
        this.myAnnoIndex = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            String annotationClass = configuration.getAdvancedConfiguration().getLanguageAnnotationClass();
            THashSet result = new THashSet();
            ArrayList<String> annoClasses = new ArrayList<String>(3);
            annoClasses.add(StringUtil.getShortName((String)annotationClass));
            for (int cursor = 0; cursor < annoClasses.size(); ++cursor) {
                String annoClass = (String)annoClasses.get(cursor);
                for (PsiAnnotation annotation : JavaAnnotationIndex.getInstance().get(annoClass, project, GlobalSearchScope.allScope((Project)project))) {
                    PsiElement modList = annotation.getParent();
                    if (!(modList instanceof PsiModifierList)) continue;
                    PsiElement element = modList.getParent();
                    if (element instanceof PsiParameter) {
                        PsiElement scope = ((PsiParameter)element).getDeclarationScope();
                        if (scope instanceof PsiNamedElement) {
                            ContainerUtil.addIfNotNull((Object)((PsiNamedElement)scope).getName(), (Collection)result);
                            continue;
                        }
                        ContainerUtil.addIfNotNull((Object)((PsiNamedElement)element).getName(), (Collection)result);
                        continue;
                    }
                    if (!(element instanceof PsiNamedElement)) continue;
                    if (element instanceof PsiClass && ((PsiClass)element).isAnnotationType()) {
                        String s = ((PsiClass)element).getName();
                        if (annoClasses.contains(s)) continue;
                        annoClasses.add(s);
                        continue;
                    }
                    ContainerUtil.addIfNotNull((Object)((PsiNamedElement)element).getName(), (Collection)result);
                }
            }
            return new CachedValueProvider.Result((Object)result, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, configuration});
        }, false);
    }

    public static InjectionCache getInstance(Project project) {
        return (InjectionCache)ServiceManager.getService((Project)project, InjectionCache.class);
    }

    public Collection<String> getAnnoIndex() {
        return (Collection)this.myAnnoIndex.getValue();
    }

    public Collection<String> getXmlIndex() {
        return (Collection)this.myXmlIndex.getValue();
    }
}

