/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.transparent.ChangeManagement.CCaseContentRevision;
import org.jetbrains.annotations.NotNull;

public class ContentRevisionFactory {
    private static final VFSKeysListener listener;
    private static final HashMap<FilePath, CCaseContentRevision> cachedRevisions;

    public static void detachListeners() {
        LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)listener);
    }

    private ContentRevisionFactory() {
    }

    public static CCaseContentRevision getRevision(@NotNull FilePath path, Project project) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "net/sourceforge/transparent/ContentRevisionFactory", "getRevision"));
        }
        CCaseContentRevision revision = cachedRevisions.get(path);
        if (revision == null) {
            revision = new CCaseContentRevision(path, project);
            cachedRevisions.put(path, revision);
        }
        return revision;
    }

    public static void clearCacheForFile(String file) {
        FilePath path = VcsUtil.getFilePath((String)file);
        cachedRevisions.remove(path);
    }

    static {
        cachedRevisions = new HashMap();
        listener = new VFSKeysListener();
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)listener);
    }

    private static class VFSKeysListener
    extends VirtualFileAdapter {
        public void beforeFileMovement(@NotNull VirtualFileMoveEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "net/sourceforge/transparent/ContentRevisionFactory$VFSKeysListener", "beforeFileMovement"));
            }
            String oldPath = e.getOldParent().getPath() + "/" + e.getFileName();
            VFSKeysListener.analyzeEvent(oldPath);
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "net/sourceforge/transparent/ContentRevisionFactory$VFSKeysListener", "beforePropertyChange"));
            }
            VirtualFile file = e.getFile();
            if (e.getPropertyName() == "name") {
                try {
                    String oldName = file.getParent().getPath() + "/" + e.getOldValue();
                    VFSKeysListener.analyzeEvent(oldName);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }

        private static void analyzeEvent(String filePath) {
            FilePath path = VcsUtil.getFilePath((String)filePath);
            CCaseContentRevision revision = (CCaseContentRevision)cachedRevisions.get(path);
            if (revision != null) {
                cachedRevisions.remove(path);
            }
            if (path.isDirectory()) {
                ArrayList keys = new ArrayList(cachedRevisions.keySet());
                for (FilePath file : keys) {
                    if (!file.isUnder(path, false)) continue;
                    cachedRevisions.remove(file);
                }
            }
        }
    }
}

