/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNDepth;

public enum Depth {
    UNKNOWN("unknown"),
    INFINITY("infinity"),
    IMMEDIATES("immediates"),
    FILES("files"),
    EMPTY("empty");

    @NotNull
    private static final Map<String, Depth> ourAllDepths;
    @NotNull
    private final String myName;

    private Depth(String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/api/Depth", "<init>"));
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/Depth", "getName"));
        }
        return string;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull Depth depth) {
        if (depth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/api/Depth", "register"));
        }
        ourAllDepths.put(depth.myName, depth);
    }

    @NotNull
    public static Depth from(@NotNull String depthName) {
        if (depthName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depthName", "org/jetbrains/idea/svn/api/Depth", "from"));
        }
        Depth result = ourAllDepths.get(depthName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown depth " + depthName);
        }
        Depth depth = result;
        if (depth == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/Depth", "from"));
        }
        return depth;
    }

    @NotNull
    public static Depth from(@Nullable SVNDepth depth) {
        Depth depth2 = depth != null ? Depth.from(depth.getName()) : UNKNOWN;
        if (depth2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/Depth", "from"));
        }
        return depth2;
    }

    @NotNull
    public static Depth allOrFiles(boolean recursive) {
        Depth depth = recursive ? INFINITY : FILES;
        if (depth == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/Depth", "allOrFiles"));
        }
        return depth;
    }

    @NotNull
    public static Depth allOrEmpty(boolean recursive) {
        Depth depth = recursive ? INFINITY : EMPTY;
        if (depth == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/Depth", "allOrEmpty"));
        }
        return depth;
    }

    public static boolean isRecursive(@Nullable Depth depth) {
        return depth == null || depth == INFINITY || depth == UNKNOWN;
    }

    static {
        ourAllDepths = ContainerUtil.newHashMap();
        for (Depth action : Depth.values()) {
            Depth.register(action);
        }
    }
}

