/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.actions.ArtefactData;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"getArtefactData", "Lorg/jetbrains/plugins/grails/actions/ArtefactData;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getGrailsApplication", "Lorg/jetbrains/plugins/grails/structure/GrailsApplication;", "dataContext", "groovy-mvc"})
public final class GrailsActionUtilKt {
    @Nullable
    public static final ArtefactData getArtefactData(@Nullable DataContext context) {
        Object artefactName;
        String packageName;
        boolean isView;
        GrailsApplication application;
        VirtualFile file;
        Module module;
        Project project;
        block14: {
            Object object;
            block16: {
                block15: {
                    GrTypeDefinition publicClass;
                    block13: {
                        if (context == null) {
                            return null;
                        }
                        Project project2 = (Project)context.getData(LangDataKeys.PROJECT);
                        if (project2 == null) {
                            return null;
                        }
                        project = project2;
                        if (DumbService.isDumb((Project)project)) {
                            return null;
                        }
                        Module module2 = (Module)context.getData(LangDataKeys.MODULE);
                        if (module2 == null) {
                            return null;
                        }
                        module = module2;
                        VirtualFile virtualFile = (VirtualFile)context.getData(LangDataKeys.VIRTUAL_FILE);
                        if (virtualFile == null) {
                            return null;
                        }
                        file = virtualFile;
                        GrailsApplication grailsApplication = GrailsApplicationManager.getInstance(project).findApplication(file);
                        if (grailsApplication == null) {
                            return null;
                        }
                        application = grailsApplication;
                        publicClass = GroovyUtils.getPublicClass((Project)project, (VirtualFile)file);
                        if (publicClass != null) break block13;
                        String string = GrailsUtils.getControllerNameByGsp(file);
                        if (string == null) {
                            return null;
                        }
                        String controllerName = string;
                        if (Intrinsics.areEqual((Object)controllerName, (Object)"layouts") || !StringUtil.isJavaIdentifier((String)controllerName)) {
                            return null;
                        }
                        isView = true;
                        packageName = null;
                        String string2 = controllerName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"controllerName");
                        artefactName = string2;
                        break block14;
                    }
                    PsiClass artefactClass = GrailsUtils.isInGrailsTests(file, project) ? GrailsTestUtils.getTestedClass((PsiClass)publicClass) : (PsiClass)publicClass;
                    if (artefactClass == null) {
                        return null;
                    }
                    isView = false;
                    String string = artefactClass.getQualifiedName();
                    if (string == null) {
                        return null;
                    }
                    packageName = StringUtil.getPackageName((String)string);
                    object = GrailsArtifact.getType(artefactClass);
                    if (object == null) break block15;
                    GrailsArtifact grailsArtifact = object;
                    GrailsArtifact it = grailsArtifact;
                    object = it.getArtifactName(artefactClass);
                    if (object != null) break block16;
                }
                return null;
            }
            artefactName = object;
        }
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Module module3 = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        VirtualFile virtualFile = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
        GrailsApplication grailsApplication = application;
        Intrinsics.checkExpressionValueIsNotNull((Object)grailsApplication, (String)"application");
        return new ArtefactData(project3, module3, virtualFile, packageName, (String)artefactName, grailsApplication, isView);
    }

    @Nullable
    public static final GrailsApplication getGrailsApplication(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        GrailsApplicationManager instance = GrailsApplicationManager.getInstance(project2);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return instance.findApplication(virtualFile2);
    }
}

