/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.ui.GrailsRunCommandDialog;
import org.jetbrains.plugins.groovy.mvc.actions.MvcRunCommandActionHandler;

public class GrailsRunCommandActionHandler
extends MvcRunCommandActionHandler {
    public boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/actions/GrailsRunCommandActionHandler", "isAvailable"));
        }
        return e.getProject() != null && GrailsApplicationManager.getInstance(e.getProject()).hasApplications();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/actions/GrailsRunCommandActionHandler", "update"));
        }
        e.getPresentation().setText("Run Grails Command");
        e.getPresentation().setDescription("");
    }

    public void performAction(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/actions/GrailsRunCommandActionHandler", "performAction"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        GrailsRunCommandDialog dialog = new GrailsRunCommandDialog(project).setSelectedApplication(application);
        if (dialog.showAndGet()) {
            GrailsCommandExecutorUtil.execute(dialog.getSelectedApplication(), dialog.getCommand(), null, false, new String[0]);
        }
    }
}

