/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.editor.GrailsEditorDecoratorKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/grails/editor/GrailsEditorDecorator;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "groovy-mvc"})
public final class GrailsEditorDecorator
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                GrailsEditorDecoratorKt.decorate(source, file);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                file.putUserData(GrailsEditorDecoratorKt.access$getDECORATED$p(), null);
            }
        });
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] virtualFileArray = manager.getOpenFiles();
        for (int i = 0; i < virtualFileArray.length; ++i) {
            VirtualFile file = virtualFileArray[i];
            FileEditorManager fileEditorManager = manager;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"manager");
            VirtualFile virtualFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            GrailsEditorDecoratorKt.decorate(fileEditorManager, virtualFile);
        }
    }
}

