/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrMethodWrapper;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class DirtyCheckableContributor
implements AstTransformationSupport {
    public static final String DIRTY_CHECK_FQN = "grails.gorm.dirty.checking.DirtyCheck";
    public static final String DIRTY_CHECKABLE_FQN = "org.grails.datastore.mapping.dirty.checking.DirtyCheckable";

    protected boolean check(GrTypeDefinition clazz) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)clazz, (String)DIRTY_CHECK_FQN, (boolean)false) || GrailsUtils.calculateArtifactType((PsiClass)clazz) == GrailsArtifact.DOMAIN && GormUtils.getGormVersion((PsiElement)clazz) != GormUtils.GormVersion.AT_LEAST_5;
    }

    protected String getOriginInfo() {
        return "via @DirtyCheck";
    }

    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/DirtyCheckableContributor", "applyTransformation"));
        }
        GrTypeDefinition clazz = context.getCodeClass();
        if (!this.check(clazz)) {
            return;
        }
        context.addInterface(TypesUtil.createType((String)DIRTY_CHECKABLE_FQN, (PsiElement)clazz));
        PsiClass dirtyCheckable = JavaPsiFacade.getInstance((Project)clazz.getProject()).findClass(DIRTY_CHECKABLE_FQN, clazz.getResolveScope());
        if (dirtyCheckable == null || !dirtyCheckable.isInterface() || GrTraitUtil.isTrait((PsiClass)dirtyCheckable)) {
            return;
        }
        for (PsiMethod interfaceMethod : dirtyCheckable.getMethods()) {
            GrMethodWrapper wrapper = GrMethodWrapper.wrap((PsiMethod)interfaceMethod);
            wrapper.getModifierList().removeModifier(1024);
            wrapper.setOriginInfo(this.getOriginInfo());
            context.addMethod((PsiMethod)wrapper);
        }
    }
}

