/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GrGspExprInjection;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspGroovyFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttribute;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttributeValue;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;

public class GspErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/lang/gsp/GspErrorFilter", "shouldHighlightErrorElement"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrConditionalExpression)) {
            return true;
        }
        if (element.getNextSibling() != null) {
            return true;
        }
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)element.getPrevSibling(), (IElementType)GroovyTokenTypes.mQUESTION)) {
            return true;
        }
        if (element.getTextLength() != 0) {
            return true;
        }
        PsiElement exprInj = parent.getParent();
        if (!(exprInj instanceof GrGspExprInjection)) {
            return true;
        }
        PsiFile containingFile = exprInj.getContainingFile();
        if (!(containingFile instanceof GspGroovyFile)) {
            return true;
        }
        PsiElement xmlTagElement = containingFile.getViewProvider().findElementAt(exprInj.getTextOffset(), (Language)GspLanguage.INSTANCE);
        if (!(xmlTagElement instanceof GspOuterGroovyElement)) {
            return true;
        }
        PsiElement attributeValue = xmlTagElement.getParent();
        if (!(attributeValue instanceof GspAttributeValue)) {
            return true;
        }
        PsiElement gspAttribute = attributeValue.getParent();
        if (!(gspAttribute instanceof GspAttribute)) {
            return true;
        }
        if (!"in".equals(((GspAttribute)gspAttribute).getName())) {
            return true;
        }
        PsiElement tag = gspAttribute.getParent();
        if (!(tag instanceof GspTag)) {
            return true;
        }
        String tagName = ((GspTag)tag).getName();
        return !"g:each".equals(tagName) && !"g:grep".equals(tagName) && !"g:collect".equals(tagName) && !"g:findAll".equals(tagName);
    }
}

