/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter.processors;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.plugins.grails.lang.gsp.formatter.AbstractGspBlock;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspExpressionTag;

public class GspSpacingProcessor
implements GspTokenTypesEx {
    private static final Spacing NO_SPACING_WITH_NEWLINE = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)1);
    private static final Spacing NO_SPACING = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
    private static final Spacing COMMON_SPACING = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)100);
    private static final TokenSet GSP_GROOVY_EXPR_SEPARATORS = TokenSet.create((IElementType[])new IElementType[]{JEXPR_BEGIN, GEXPR_BEGIN, GEXPR_END});

    private GspSpacingProcessor() {
    }

    public static Spacing getSpacing(XmlFormattingPolicy policy, AbstractGspBlock child1, AbstractGspBlock child2) {
        IElementType rt;
        ASTNode leftNode = child1.getNode();
        ASTNode rightNode = child2.getNode();
        IElementType lt = leftNode.getElementType();
        if (GspSpacingProcessor.isXmlTagName(lt, rt = rightNode.getElementType()) && policy.getShouldAddSpaceAroundTagName()) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)policy.getShouldKeepLineBreaks(), (int)policy.getKeepBlankLines());
        }
        if (lt == XML_TAG_END || rt == XML_END_TAG_START) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (rt == XML_TAG_END) {
            return NO_SPACING;
        }
        if (rt == XmlElementType.XML_EMPTY_ELEMENT_END) {
            if (policy.addSpaceIntoEmptyTag()) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)policy.getShouldKeepLineBreaks(), (int)policy.getKeepBlankLines());
            }
            return NO_SPACING;
        }
        if (rt == XML_BAD_CHARACTER || lt == XML_BAD_CHARACTER) {
            return null;
        }
        if (leftNode.getPsi() instanceof XmlAttribute || rightNode.getPsi() instanceof XmlAttribute) {
            return COMMON_SPACING;
        }
        if (XML_EQ == lt || XML_EQ == rt) {
            int spaces = policy.getShouldAddSpaceAroundEqualityInAttribute() ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)policy.getShouldKeepLineBreaks(), (int)policy.getKeepBlankLines());
        }
        if (GSP_GROOVY_EXPR_SEPARATORS.contains(lt) || GSP_GROOVY_EXPR_SEPARATORS.contains(rt)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (rt == JEXPR_END && rightNode.getTreeParent().getPsi() instanceof GspExpressionTag) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (GSP_GROOVY_SEPARATORS.contains(lt) && rightNode.getText().trim().length() > 0 || GSP_GROOVY_SEPARATORS.contains(rt) && leftNode.getText().trim().length() > 0) {
            return COMMON_SPACING;
        }
        if (rt == XmlElementType.HTML_TAG && lt == XmlElementType.HTML_TAG && policy.insertLineBreakBeforeTag((XmlTag)rightNode.getPsi())) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)2, (boolean)policy.getShouldKeepLineBreaks(), (int)policy.getKeepBlankLines());
        }
        return null;
    }

    private static boolean isXmlTagName(IElementType type1, IElementType type2) {
        if ((type1 == XmlElementType.XML_NAME || type1 == XmlElementType.XML_TAG_NAME) && type2 == XmlElementType.XML_TAG_END) {
            return true;
        }
        if ((type1 == XmlElementType.XML_NAME || type1 == XmlElementType.XML_TAG_NAME) && type2 == XmlElementType.XML_EMPTY_ELEMENT_END) {
            return true;
        }
        if ((type1 == XmlElementType.XML_ATTRIBUTE || type1 == GspElementTypes.GRAILS_TAG_ATTRIBUTE) && type2 == XmlElementType.XML_EMPTY_ELEMENT_END) {
            return true;
        }
        return (type1 == XmlElementType.XML_ATTRIBUTE || type1 == GspElementTypes.GRAILS_TAG_ATTRIBUTE) && type2 == XmlElementType.XML_TAG_END;
    }
}

