/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.impl.GrailsCommandLineState;
import org.jetbrains.plugins.grails.runner.impl.GrailsTestCommandLineState;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsDebuggerRunner
extends GenericDebuggerRunner {
    @NotNull
    public String getRunnerId() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "getRunnerId"));
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "canRun"));
        }
        if (DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof GrailsRunConfiguration) {
            return ((GrailsRunConfiguration)profile).getGrailsApplicationNullable() instanceof Grails2Application;
        }
        return false;
    }

    static boolean isForkedDebug(GrailsCommandLineState state) throws ExecutionException {
        GrailsApplication application = state.getApplication();
        if (!(application instanceof Grails2Application)) {
            return false;
        }
        Version version = application.getVersion();
        boolean forTests = state instanceof GrailsTestCommandLineState;
        return forTests ? version.compareTo(Version.GRAILS_2_3_10) > 0 && ((Grails2Application)application).isTestForked() : version.compareTo(Version.GRAILS_2_3_5) > 0 && ((Grails2Application)application).isRunForked();
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        GrailsCommandLineState grailsCommandLineState;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "createContentDescriptor"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "createContentDescriptor"));
        }
        if (state instanceof GrailsCommandLineState && GrailsDebuggerRunner.isForkedDebug(grailsCommandLineState = (GrailsCommandLineState)state)) {
            String address = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
            String forkedInstanceArgs = String.format("-Xrunjdwp:transport=dt_socket,server=n,suspend=n,address=%s", address);
            ParametersList vmParametersList = grailsCommandLineState.getJavaParameters().getVMParametersList();
            vmParametersList.addProperty("grails.project.fork.run.debugArgs", forkedInstanceArgs);
            vmParametersList.addProperty("grails.project.fork.test.debugArgs", forkedInstanceArgs);
            return this.attachVirtualMachine(state, environment, new RemoteConnection(true, "127.0.0.1", address, true), true);
        }
        return super.createContentDescriptor(state, environment);
    }
}

