/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails3Application;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class Grails3InstallationCommandExecutor
extends GrailsCommandLineExecutor
implements GrailsInstallationExecutor {
    @Override
    public boolean isApplicable(@NotNull GrailsApplication grailsApplication) {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "isApplicable"));
        }
        return grailsApplication instanceof Grails3Application && GrailsSDKManager.getGrailsSdk(grailsApplication) != null;
    }

    @Override
    public boolean isApplicable(@NotNull GrailsSDK grailsSdk) {
        if (grailsSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdk", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "isApplicable"));
        }
        return grailsSdk.getVersion().isAtLeast(Version.GRAILS_3_0);
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication, @NotNull MvcCommand command) throws ExecutionException {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        GrailsSDK grailsSdk = GrailsSDKManager.getGrailsSdk(grailsApplication);
        if (grailsSdk == null) {
            throw new ExecutionException("Grails SDK is not defined");
        }
        Sdk sdk = ProjectRootManager.getInstance((Project)grailsApplication.getProject()).getProjectSdk();
        if (sdk == null) {
            throw new ExecutionException("Project SDK is not defined");
        }
        JavaParameters params = this.createJavaParameters(sdk, grailsSdk, command);
        params.setWorkingDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)grailsApplication.getRoot()));
        params.setDefaultCharset(grailsApplication.getProject());
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        return javaParameters;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Sdk sdk, @NotNull GrailsSDK grailsSdk, @NotNull MvcCommand command) throws ExecutionException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        if (grailsSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsSdk", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        JavaParameters params = new JavaParameters();
        params.setJdk(sdk);
        params.getVMParametersList().addAll(new String[]{"-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1", "-XX:CICompilerCount=3"});
        params.getVMParametersList().addParametersString(command.getVmOptions());
        GrailsExecutionUtils.addCommonJvmOptions(params);
        params.getClassPath().addAllFiles(Grails3InstallationCommandExecutor.runClassPath(new File(grailsSdk.getPath())));
        params.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
        params.setMainClass("org.grails.cli.GrailsCli");
        command.addToParametersList(params.getProgramParametersList());
        params.setUseClasspathJar(true);
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        return javaParameters;
    }

    private static List<File> runClassPath(File grailsSDKHome) {
        File grailsSDKDist = new File(grailsSDKHome.getAbsolutePath() + "/dist");
        File grailsSDKLib = new File(grailsSDKHome.getAbsolutePath() + "/lib");
        if (!grailsSDKDist.exists() || !grailsSDKLib.exists()) {
            return Collections.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        FileUtil.processFilesRecursively((File)grailsSDKHome, file -> {
            String fileName = file.getName();
            if (fileName.endsWith(".jar") && !fileName.endsWith("-sources.jar") && !fileName.endsWith("-javadoc.jar") && !fileName.matches("javaee-(web-)?api(-\\d(\\.\\d)*)?.jar")) {
                result.add(file);
            }
            return true;
        });
        return result;
    }
}

