/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrailsResourceBeanExtractor {
    private static final LightCacheKey<List<BeanDescriptor>> FILE_CACHE = LightCacheKey.createByFileModificationCount();

    private static boolean isLooksLikeClassReference(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "isLooksLikeClassReference"));
        }
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        PsiElement nameElement = ref.getReferenceNameElement();
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)nameElement, (IElementType)GroovyTokenTypes.mIDENT)) {
            return false;
        }
        String text = nameElement.getText();
        if (text.isEmpty() || !Character.isUpperCase(text.charAt(0))) {
            return false;
        }
        GrExpression q = ref.getQualifierExpression();
        while (q != null) {
            if (!(q instanceof GrReferenceExpression)) {
                return false;
            }
            nameElement = ((GrReferenceExpression)q).getReferenceNameElement();
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)nameElement, (IElementType)GroovyTokenTypes.mIDENT)) {
                return false;
            }
            q = ((GrReferenceExpression)q).getQualifierExpression();
        }
        return true;
    }

    @Nullable
    public static Pair<String, GrReferenceExpression> getBeanDefinition(@NotNull GrMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "getBeanDefinition"));
        }
        if (!(methodCall.getParent() instanceof GrCodeBlock)) {
            return null;
        }
        String beanName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)methodCall);
        if (beanName == null) {
            return null;
        }
        GrExpression[] allArguments = PsiUtil.getAllArguments((GrCall)methodCall);
        if (allArguments.length == 0) {
            return null;
        }
        int classNameArgumentIndex = 0;
        if (allArguments[0] == null) {
            if (allArguments.length == 1) {
                return null;
            }
            classNameArgumentIndex = 1;
        }
        if (!GrailsResourceBeanExtractor.isLooksLikeClassReference(allArguments[classNameArgumentIndex])) {
            return null;
        }
        return Pair.create((Object)beanName, (Object)((GrReferenceExpression)allArguments[classNameArgumentIndex]));
    }

    private static void processBeanDefinitionClosure(final Map<String, BeanDescriptor> descriptorMap, @NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "processBeanDefinitionClosure"));
        }
        closure.acceptChildren((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

            public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
                Pair<String, GrReferenceExpression> pair = GrailsResourceBeanExtractor.getBeanDefinition(methodCallExpression);
                if (pair != null) {
                    BeanDescriptor beanDescriptor = (BeanDescriptor)descriptorMap.get(pair.first);
                    if (beanDescriptor == null) {
                        beanDescriptor = new BeanDescriptor((String)pair.first);
                        descriptorMap.put(pair.first, beanDescriptor);
                    }
                    beanDescriptor.getReferences().add((GrReferenceExpression)pair.second);
                }
            }
        });
    }

    private static List<BeanDescriptor> evaluateBeanDescriptorsFromResourcesGroovy(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "evaluateBeanDescriptorsFromResourcesGroovy"));
        }
        com.intellij.util.containers.hash.HashMap descriptorMap = new com.intellij.util.containers.hash.HashMap();
        for (PsiElement e = file.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrExpression lValue;
            GrExpression rValue;
            GrAssignmentExpression assign;
            GrExpression[] allArguments;
            String methodName;
            if (e instanceof GrMethodCallExpression && "beans".equals(methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)((GrMethodCall)e))) && (allArguments = PsiUtil.getAllArguments((GrCall)((GrCall)e))).length == 1 && allArguments[0] instanceof GrClosableBlock) {
                GrailsResourceBeanExtractor.processBeanDefinitionClosure((Map<String, BeanDescriptor>)descriptorMap, (GrClosableBlock)allArguments[0]);
            }
            if (!(e instanceof GrAssignmentExpression) || (assign = (GrAssignmentExpression)e).getOperationTokenType() != GroovyTokenTypes.mASSIGN || !((rValue = ((GrAssignmentExpression)e).getRValue()) instanceof GrClosableBlock) || !((lValue = ((GrAssignmentExpression)e).getLValue()) instanceof GrReferenceExpression) || !"beans".equals(lValue.getText())) continue;
            GrailsResourceBeanExtractor.processBeanDefinitionClosure((Map<String, BeanDescriptor>)descriptorMap, (GrClosableBlock)rValue);
        }
        return new ArrayList<BeanDescriptor>(descriptorMap.values());
    }

    private static List<BeanDescriptor> evaluateBeansFromPluginClass(@NotNull GrTypeDefinition pluginClass) {
        if (pluginClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginClass", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "evaluateBeansFromPluginClass"));
        }
        GrClosableBlock closure = GrailsResourceBeanExtractor.getInitializer(pluginClass);
        if (closure == null) {
            return Collections.emptyList();
        }
        HashMap descriptorMap = ContainerUtil.newHashMap();
        GrailsResourceBeanExtractor.processBeanDefinitionClosure(descriptorMap, closure);
        return ContainerUtil.newArrayList(descriptorMap.values());
    }

    private static GrClosableBlock getInitializer(@NotNull GrTypeDefinition pluginClass) {
        GrStatement statement;
        GrStatement[] statements;
        GrOpenBlock block;
        PsiMethod method;
        GrExpression initializer;
        if (pluginClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginClass", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "getInitializer"));
        }
        PsiField field = pluginClass.findCodeFieldByName("doWithSpring", false);
        if (field instanceof GrField && (initializer = ((GrField)field).getInitializerGroovy()) instanceof GrClosableBlock) {
            return (GrClosableBlock)initializer;
        }
        PsiMethod[] methods = pluginClass.findCodeMethodsByName("doWithSpring", false);
        if (methods.length == 1 && (method = methods[0]) instanceof GrMethod && (block = ((GrMethod)method).getBlock()) != null && (statements = block.getStatements()).length == 1 && (statement = statements[0]) instanceof GrClosableBlock) {
            return (GrClosableBlock)statement;
        }
        return null;
    }

    public static List<BeanDescriptor> getBeanDescriptorsFromResourcesGroovy(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "getBeanDescriptorsFromResourcesGroovy"));
        }
        List res = (List)FILE_CACHE.getCachedValue((PsiElement)file);
        if (res == null) {
            res = GrailsResourceBeanExtractor.evaluateBeanDescriptorsFromResourcesGroovy(file);
            res = (List)FILE_CACHE.putCachedValue((PsiElement)file, res);
        }
        return res;
    }

    public static List<BeanDescriptor> getBeanDescriptorsFromPluginClass(@NotNull GrTypeDefinition pluginClass) {
        if (pluginClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginClass", "org/jetbrains/plugins/grails/spring/GrailsResourceBeanExtractor", "getBeanDescriptorsFromPluginClass"));
        }
        List res = (List)FILE_CACHE.getCachedValue((PsiElement)pluginClass);
        if (res == null) {
            res = GrailsResourceBeanExtractor.evaluateBeansFromPluginClass(pluginClass);
            res = (List)FILE_CACHE.putCachedValue((PsiElement)pluginClass, res);
        }
        return res;
    }

    public static class BeanDescriptor {
        private final String myName;
        private final List<GrReferenceExpression> myReferences = new ArrayList<GrReferenceExpression>();

        public BeanDescriptor(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public List<GrReferenceExpression> getReferences() {
            return this.myReferences;
        }

        @Nullable
        public PsiType getType() {
            PsiManager manager = this.myReferences.get(0).getManager();
            PsiType res = null;
            for (GrReferenceExpression reference : this.myReferences) {
                PsiElement resolve = reference.resolve();
                if (!(resolve instanceof PsiClass)) continue;
                res = TypesUtil.getLeastUpperBoundNullable(res, (PsiType)PsiTypesUtil.getClassType((PsiClass)((PsiClass)resolve)), (PsiManager)manager);
            }
            return res;
        }
    }
}

