/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.spring.InjectedSpringBeanProvider;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class SpringGrailsTargetMapper
implements AliasingPsiTargetMapper {
    @NotNull
    public Set<AliasingPsiTarget> getTargets(final @NotNull PomTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/plugins/grails/spring/SpringGrailsTargetMapper", "getTargets"));
        }
        Set set = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<AliasingPsiTarget>>(){

            public Set<AliasingPsiTarget> compute() {
                CommonSpringBean bean = SpringBeanUtils.getInstance().findBean(target);
                if (bean == null) {
                    return Collections.emptySet();
                }
                String name = bean.getBeanName();
                if (name == null) {
                    return Collections.emptySet();
                }
                Module module = bean.getModule();
                if (module == null) {
                    return Collections.emptySet();
                }
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
                GroovyShortNamesCache cache = GroovyShortNamesCache.getGroovyShortNamesCache((Project)module.getProject());
                HashSet<AliasingPsiTarget> res = new HashSet<AliasingPsiTarget>();
                for (final PsiField psiField : cache.getFieldsByName(name, scope)) {
                    SpringBeanPointer pointer = InjectedSpringBeanProvider.getInjectedBean((PsiVariable)psiField);
                    if (pointer == null || !bean.equals(pointer.getSpringBean())) continue;
                    res.add(new AliasingPsiTarget((PsiNamedElement)psiField){

                        @NotNull
                        public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                            if (newAliasName == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAliasName", "org/jetbrains/plugins/grails/spring/SpringGrailsTargetMapper$1$1", "setAliasName"));
                            }
                            psiField.setName(newAliasName);
                            AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                            if (aliasingPsiTarget == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/SpringGrailsTargetMapper$1$1", "setAliasName"));
                            }
                            return aliasingPsiTarget;
                        }
                    });
                }
                return res;
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/SpringGrailsTargetMapper", "getTargets"));
        }
        return set;
    }
}

