/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.service.GrailsExecutorHolder;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationListener;
import org.jetbrains.plugins.grails.structure.GrailsApplicationProvider;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;

public final class GrailsApplicationManager {
    private static final Logger LOG = Logger.getInstance(GrailsApplicationManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectFileIndex myFileIndex;
    private final AtomicReference<Map<VirtualFile, GrailsApplication>> myApplicationsRef;

    public GrailsApplicationManager(@NotNull Project project, @NotNull ProjectFileIndex index) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "<init>"));
        }
        this.myApplicationsRef = new AtomicReference(Collections.emptyMap());
        this.myProject = project;
        this.myFileIndex = index;
    }

    public boolean hasApplications() {
        return !this.getApplicationMap().isEmpty();
    }

    @NotNull
    public Collection<GrailsApplication> getApplications() {
        Collection<GrailsApplication> collection = this.getApplicationMap().values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getApplications"));
        }
        return collection;
    }

    @NotNull
    public Map<VirtualFile, GrailsApplication> getApplicationMap() {
        Map<VirtualFile, GrailsApplication> map2 = this.myApplicationsRef.get();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getApplicationMap"));
        }
        return map2;
    }

    @Nullable
    @Contract(value="null -> null")
    public GrailsApplication findApplication(@Nullable VirtualFile file) {
        if (file == null || !this.hasApplications()) {
            return null;
        }
        for (VirtualFile currentFile = this.myFileIndex.getContentRootForFile(file); currentFile != null; currentFile = currentFile.getParent()) {
            GrailsApplication application = this.getApplicationByRoot(currentFile);
            if (application != null) {
                return application;
            }
            if (currentFile.equals(this.myProject.getBaseDir())) break;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public GrailsApplication getApplicationByRoot(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        return this.getApplicationMap().get(root);
    }

    public void queueUpdate() {
        if (LOG.isTraceEnabled()) {
            LOG.debug("Update queued from ", new Throwable());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Update queued from " + new Throwable().getStackTrace()[2]);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(this::doUpdate);
            return;
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((Executor)GrailsExecutorHolder.ourExecutorService, (ReadTask)new ReadTask(){

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager$1", "onCanceled"));
                }
                GrailsApplicationManager.this.queueUpdate();
            }

            public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager$1", "computeInReadAction"));
                }
                GrailsApplicationManager.this.doUpdate();
            }
        });
    }

    private void doUpdate() {
        Map<VirtualFile, GrailsApplication> map2;
        Map<VirtualFile, GrailsApplication> oldMap = this.myApplicationsRef.get();
        if (oldMap.equals(map2 = this.doGetApplications())) {
            return;
        }
        if (this.myApplicationsRef.compareAndSet(oldMap, map2)) {
            LOG.debug("Grails applications recomputed");
            LOG.debug(map2.values().toString());
            oldMap.values().forEach(Disposer::dispose);
            ((GrailsApplicationListener)this.myProject.getMessageBus().syncPublisher(GrailsApplicationListener.TOPIC)).applicationsRecomputed();
        } else {
            LOG.warn("Some thread already updated values");
        }
    }

    @NotNull
    private Map<VirtualFile, GrailsApplication> doGetApplications() {
        Collection appRoots = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"grails-app", (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        if (appRoots.isEmpty()) {
            Map<VirtualFile, GrailsApplication> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "doGetApplications"));
            }
            return map2;
        }
        HashMap result = ContainerUtil.newHashMap();
        for (VirtualFile appRoot : appRoots) {
            GrailsApplication application;
            VirtualFile root;
            if (!appRoot.isDirectory() || (root = appRoot.getParent()) == null || !root.isDirectory() || (application = GrailsApplicationProvider.createGrailsApplication(this.myProject, root)) == null) continue;
            result.put(root, application);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "doGetApplications"));
        }
        return hashMap;
    }

    @NotNull
    public static GrailsApplicationManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getInstance"));
        }
        GrailsApplicationManager grailsApplicationManager = (GrailsApplicationManager)ServiceManager.getService((Project)project, GrailsApplicationManager.class);
        if (grailsApplicationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/GrailsApplicationManager", "getInstance"));
        }
        return grailsApplicationManager;
    }

    @Nullable
    @Contract(value="null -> null")
    public static GrailsApplication findApplication(@Nullable PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            return null;
        }
        VirtualFile file = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : ((psiFile = element.getContainingFile()) == null ? null : psiFile.getVirtualFile());
        return GrailsApplicationManager.getInstance(element.getProject()).findApplication(file);
    }

    @Nullable
    @Contract(value="null -> null")
    public static OldGrailsApplication findApplication(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        for (GrailsApplication application : GrailsApplicationManager.getInstance(module.getProject()).getApplications()) {
            if (!(application instanceof OldGrailsApplication) || !((OldGrailsApplication)application).getModule().equals(module)) continue;
            return (OldGrailsApplication)application;
        }
        return null;
    }
}

