/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.tests.runner;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.execution.ParametersListUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationType;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GrailsTestConfigurationProducer
extends RunConfigurationProducer<GrailsRunConfiguration> {
    public GrailsTestConfigurationProducer() {
        super((ConfigurationType)GrailsRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(GrailsRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElementRef) {
        String vmParameters;
        GrailsApplication application = GrailsApplicationManager.findApplication(context.getPsiLocation());
        if (application == null) {
            return false;
        }
        PsiElement sourceElement = this.setupConfigurationFromContext0(configuration, context);
        if (sourceElement == null) {
            return false;
        }
        configuration.setGrailsApplication(application);
        sourceElementRef.set((Object)sourceElement);
        if (application.getVersion().isAtLeast("1.3.0")) {
            String parameters = configuration.getProgramParameters();
            configuration.setProgramParameters(parameters == null ? null : parameters + " -echoOut");
        }
        if (StringUtil.isEmpty((String)(vmParameters = configuration.getVMParameters()))) {
            configuration.setVMParameters("-Dgrails.full.stacktrace=true");
        } else if (!vmParameters.contains("-Dgrails.full.stacktrace=true")) {
            configuration.setVMParameters(vmParameters + ' ' + "-Dgrails.full.stacktrace=true");
        }
        return true;
    }

    @Nullable
    protected PsiElement setupConfigurationFromContext0(GrailsRunConfiguration configuration, ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            if (GrailsTestConfigurationProducer.setupConfigurationByDir(configuration, (PsiDirectory)element, module)) {
                return element;
            }
            return null;
        }
        PsiClass psiClass = null;
        PsiFile file = element.getContainingFile();
        if (file instanceof GroovyFile) {
            PsiClass[] groovyFile = (PsiClass[])file;
            if (!groovyFile.isScript()) {
                for (GrTypeDefinition typeDefinition : groovyFile.getTypeDefinitions()) {
                    if (!(typeDefinition instanceof GrClassDefinition) || !GrailsTestConfigurationProducer.isGrailsTestClass((PsiClass)typeDefinition)) continue;
                    psiClass = typeDefinition;
                    break;
                }
            }
        } else if (file instanceof PsiJavaFile) {
            for (PsiClass aClass : ((PsiJavaFile)file).getClasses()) {
                if (!GrailsTestConfigurationProducer.isGrailsTestClass(aClass)) continue;
                psiClass = aClass;
                break;
            }
        }
        if (psiClass == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        return GrailsTestConfigurationProducer.setupConfigurationByClass(configuration, psiClass, method);
    }

    private static String cleanCmd(String cmd) {
        return cmd.replace("-echoOut", "").replaceAll("\\s+", " ").trim();
    }

    public boolean isConfigurationFromContext(GrailsRunConfiguration configuration, ConfigurationContext context) {
        GrailsApplication application = GrailsApplicationManager.findApplication(context.getPsiLocation());
        if (application == null || !application.equals(configuration.getGrailsApplicationNullable())) {
            return false;
        }
        if (configuration.getVMParameters() == null) {
            return false;
        }
        GrailsRunConfiguration tmp = new GrailsRunConfiguration(context.getProject(), this.getConfigurationFactory(), "tmp");
        if (this.setupConfigurationFromContext0(tmp, context) == null) {
            return false;
        }
        return GrailsTestConfigurationProducer.cleanCmd(tmp.getProgramParameters()).equals(GrailsTestConfigurationProducer.cleanCmd(configuration.getProgramParameters()));
    }

    private static boolean setupConfigurationByDir(GrailsRunConfiguration configuration, PsiDirectory dir, Module module) {
        String name;
        VirtualFile vfile = dir.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex();
        VirtualFile srcRoot = fileIndex.getSourceRootForFile(vfile);
        if (srcRoot == null || !GrailsUtils.TEST_FOLDER_NAMES.contains(srcRoot.getName()) || !fileIndex.isInTestSourceContent(vfile)) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("test-app");
        builder.append(GrailsTestConfigurationProducer.getParamKeyBySrcRoot(module, srcRoot));
        String pkg = fileIndex.getPackageNameByDirectory(vfile);
        if (StringUtil.isNotEmpty((String)pkg)) {
            builder.append(" ").append(pkg).append(".**");
            name = "Grails tests:" + pkg;
        } else {
            name = "Grails tests:" + srcRoot.getName();
        }
        configuration.setProgramParameters(builder.toString());
        configuration.setName(name);
        return true;
    }

    private static PsiElement setupConfigurationByClass(GrailsRunConfiguration configuration, @NotNull PsiClass aClass, @Nullable PsiMethod method) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/tests/runner/GrailsTestConfigurationProducer", "setupConfigurationByClass"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("test-app");
        Module module = JavaExecutionUtil.findModule((PsiClass)aClass);
        VirtualFile srcRoot = ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().getSourceRootForFile(aClass.getContainingFile().getVirtualFile());
        builder.append(GrailsTestConfigurationProducer.getParamKeyBySrcRoot(module, srcRoot));
        PsiClass sourceElement = aClass;
        String qname = aClass.getQualifiedName();
        assert (qname != null);
        String testName = GrailsTestConfigurationProducer.trimTestSuffix(qname);
        String confName = aClass.getName();
        if (GrailsTestConfigurationProducer.isGrailsTestMethod(method) && GrailsConfigUtils.isAtLeastGrails1_1(module)) {
            testName = ParametersListUtil.join((String[])new String[]{testName + "." + method.getName()});
            confName = method.getName() + "()";
            sourceElement = method;
        }
        builder.append(" ").append(testName);
        configuration.setProgramParameters(builder.toString());
        configuration.setName(confName);
        return sourceElement;
    }

    private static String trimTestSuffix(String name) {
        if (name.endsWith("Tests")) {
            return name.substring(0, name.length() - "Tests".length());
        }
        if (name.endsWith("Test")) {
            return name.substring(0, name.length() - "Test".length());
        }
        return name;
    }

    private static String getParamKeyBySrcRoot(@NotNull Module module, VirtualFile srcRoot) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/tests/runner/GrailsTestConfigurationProducer", "getParamKeyBySrcRoot"));
        }
        String name = srcRoot.getName();
        if (GrailsUtils.TEST_FOLDER_NAMES.contains(name)) {
            if (GrailsConfigUtils.isAtLeastGrails1_3(module)) {
                return ' ' + name + ':';
            }
            return " -" + name;
        }
        return "";
    }

    public static boolean isGrailsTestClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/grails/tests/runner/GrailsTestConfigurationProducer", "isGrailsTestClass"));
        }
        if (!GrailsUtils.isInGrailsTests((PsiElement)psiClass)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.test.mixin.TestFor", (boolean)false, (boolean)true)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.buildtestdata.mixin.Build", (boolean)false, (boolean)true)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.test.mixin.TestMixin", (boolean)false, (boolean)true)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.test.mixin.Mock", (boolean)false, (boolean)true)) {
            return true;
        }
        String name = psiClass.getName();
        if (name.matches(".+(Spec|Specification)")) {
            return GroovyPsiManager.isInheritorCached((PsiClass)psiClass, (String)"spock.lang.Specification");
        }
        if (!name.matches(".+Tests?")) {
            return false;
        }
        if (GroovyPsiManager.isInheritorCached((PsiClass)psiClass, (String)"junit.framework.TestCase") || GroovyPsiManager.isInheritorCached((PsiClass)psiClass, (String)"spock.lang.Specification")) {
            return true;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (psiMethod.getModifierList().findAnnotation("org.junit.Test") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrailsTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        Project project = aClass.getProject();
        return JUnitUtil.isTestMethod((Location)new MethodLocation(project, method, (Location)new PsiLocation(project, (PsiElement)aClass)));
    }
}

