/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.pluginSupport.webflow.WebFlowUtils;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsNameUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsUtils {
    private static final Logger LOG = Logger.getInstance(GrailsUtils.class);
    public static final List<String> TEST_FOLDER_NAMES = Arrays.asList("integration", "unit", "functional");
    @NonNls
    public static final String GRAILS_INTEGRATION_TESTS = "test/integration/";
    @NonNls
    public static final String GRAILS_UNIT_TESTS = "test/unit/";
    @NonNls
    public static final String GRAILS_APP_DIRECTORY = "grails-app";
    @NonNls
    public static final String VIEWS_DIRECTORY = "views";
    @NonNls
    public static final String CONF_DIRECTORY = "conf";
    @NonNls
    public static final String BUILD_CONFIG = "BuildConfig.groovy";
    @NonNls
    public static final String CONFIG_GROOVY = "Config.groovy";
    public static final String GRAILS_NOTIFICATION_GROUP = "grails";
    @NonNls
    public static final String SOURCE_ROOT = "src";
    @NonNls
    public static final String JAVA_SOURCE_ROOT = "java";
    @NonNls
    public static final String webAppDir = "web-app";
    @NonNls
    public static final String metaInfDir = "META-INF";
    @NonNls
    public static final String webInfDir = "WEB-INF";
    @NonNls
    public static final String jsDir = "js";
    @NonNls
    public static final String cssDir = "css";
    @NonNls
    public static final String imagecDir = "images";
    @NonNls
    public static final String GRAILS_USER_LIBRARY = "Grails User Library";
    @NonNls
    public static final String GROOVY_EXTENSION = ".groovy";
    @NonNls
    public static final String TEST_DIR = "test";
    @NonNls
    public static final String TEMPLATES_DIR = "templates";
    @NonNls
    public static String GRAILS_RUN_DEFAULT_HOST = "localhost";
    @NonNls
    public static String GRAILS_RUN_DEFAULT_PORT = "8080";
    private static final String[] RESERVED_DIRS = new String[]{"META-INF", "WEB-INF", "js", "css", "images"};
    public static final String ENVIRONMENTS = "environments";
    public static final String ENVIRONMENTS_METHOD_KIND = "grails:environments";
    public static final List<String> ENVIRONMENT_LIST = Arrays.asList("development", "production", "test");
    public static final String COMMON_WEB_PROPERTIES = " private org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap getParams() {} private org.codehaus.groovy.grails.web.servlet.FlashScope getFlash() {} private javax.servlet.http.HttpSession getSession() {} private javax.servlet.http.HttpServletRequest getRequest() {} private javax.servlet.ServletContext getServletContext() {} private javax.servlet.http.HttpServletResponse getResponse() {} private org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes getGrailsAttributes() {} private org.codehaus.groovy.grails.commons.GrailsApplication getGrailsApplication() {} private String getActionName() {} private String getControllerName() {} private org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest getWebRequest() {};";

    private GrailsUtils() {
    }

    @Nullable
    public static VirtualFile findParent(VirtualFile virtualFile, String parentFileName) {
        VirtualFile parent;
        for (parent = virtualFile.getParent(); parent != null && !parentFileName.equals(parent.getName()); parent = parent.getParent()) {
        }
        return parent;
    }

    public static boolean isUnderWebAppDirectory(PsiDirectory directory) {
        VirtualFile virtualFile = directory.getVirtualFile();
        if (virtualFile.getName().equals(webAppDir) && virtualFile.isDirectory()) {
            return true;
        }
        VirtualFile parent = GrailsUtils.findParent(virtualFile, webAppDir);
        if (parent == null || ArrayUtil.contains((String)virtualFile.getName(), (String[])RESERVED_DIRS)) {
            return false;
        }
        for (String reservedDir : RESERVED_DIRS) {
            if (GrailsUtils.findParent(virtualFile, reservedDir) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isConfigGroovyFile(@Nullable PsiElement file) {
        return GrailsUtils.isConfigFile(file, CONFIG_GROOVY);
    }

    public static boolean isConfigFile(@Nullable PsiElement file, String name) {
        if (!(file instanceof GroovyFileBase)) {
            return false;
        }
        VirtualFile virtualFile = ((GroovyFileBase)file).getOriginalFile().getVirtualFile();
        if (virtualFile == null || !name.equals(virtualFile.getName())) {
            return false;
        }
        VirtualFile conf = virtualFile.getParent();
        if (conf == null || !CONF_DIRECTORY.equals(conf.getName())) {
            return false;
        }
        VirtualFile grailsApp = conf.getParent();
        if (grailsApp == null || !GRAILS_APP_DIRECTORY.equals(grailsApp.getName())) {
            return false;
        }
        return ((GroovyFileBase)file).isScript();
    }

    public static boolean isBuildConfigFile(@Nullable PsiFile file) {
        return GrailsUtils.isConfigFile((PsiElement)file, BUILD_CONFIG);
    }

    @Nullable
    public static VirtualFile getViewDirectory(@Nullable VirtualFile gspFile) {
        for (VirtualFile f = gspFile; f != null; f = f.getParent()) {
            VirtualFile parent;
            if (!f.getName().equals(VIEWS_DIRECTORY) || !f.isDirectory() || (parent = f.getParent()) == null || !parent.getName().equals(GRAILS_APP_DIRECTORY)) continue;
            return f;
        }
        return null;
    }

    public static boolean isUnderGrailsViewsDirectory(PsiDirectory directory) {
        return GrailsUtils.getViewDirectory(directory.getVirtualFile()) != null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile findGrailsAppRoot(@Nullable Module module) {
        return GrailsFramework.getInstance().findAppRoot(module);
    }

    public static boolean hasSupport(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsUtils", "hasSupport"));
        }
        return GrailsCommandExecutor.getGrailsExecutor(GrailsApplicationManager.findApplication(module)) != null;
    }

    public static boolean isGrailsPluginModule(@Nullable Module module) {
        return GrailsUtils.extractGrailsPluginName(module) != null;
    }

    @Nullable
    public static String extractGrailsPluginName(@Nullable Module module) {
        VirtualFile root = GrailsUtils.findGrailsAppRoot(module);
        return GrailsUtils.extractGrailsPluginName(root);
    }

    @Nullable
    public static String extractGrailsPluginName(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        for (VirtualFile child : root.getChildren()) {
            String name = child.getName();
            if (!name.endsWith("GrailsPlugin.groovy")) continue;
            return StringUtil.trimEnd((String)name, (String)"GrailsPlugin.groovy");
        }
        return null;
    }

    public static boolean isInGrailsTests(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/GrailsUtils", "isInGrailsTests"));
        }
        PsiFile file = element.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return GrailsUtils.isInGrailsTests(virtualFile, file.getProject());
    }

    public static boolean isInGrailsTests(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/grails/util/GrailsUtils", "isInGrailsTests"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/util/GrailsUtils", "isInGrailsTests"));
        }
        GrailsApplication application = GrailsApplicationManager.getInstance(project).findApplication(virtualFile);
        if (application == null) {
            return false;
        }
        return application.getTestsScope().contains(virtualFile) || GlobalSearchScopesCore.projectTestScope((Project)project).contains(virtualFile);
    }

    @Nullable
    public static VirtualFile findViewsDirectory(@Nullable PsiElement element) {
        VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(element);
        if (appDir == null) {
            return null;
        }
        return appDir.findChild(VIEWS_DIRECTORY);
    }

    @Nullable
    public static VirtualFile findI18nDirectory(@Nullable PsiElement element) {
        VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(element);
        if (appDir == null) {
            return null;
        }
        return appDir.findChild("i18n");
    }

    @Nullable
    public static VirtualFile findConfDirectory(@Nullable Module module) {
        VirtualFile root = GrailsFramework.getInstance().findAppDirectory(module);
        if (root == null) {
            return null;
        }
        return root.findChild(CONF_DIRECTORY);
    }

    @Nullable
    public static VirtualFile findConfDirectory(@NotNull GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/util/GrailsUtils", "findConfDirectory"));
        }
        return application.getAppRoot().findChild(CONF_DIRECTORY);
    }

    @Nullable
    public static String getTemplateName(String fileName) {
        if (fileName.length() > 5 && fileName.charAt(0) == '_' && fileName.endsWith(".gsp")) {
            return fileName.substring(1, fileName.length() - ".gsp".length());
        }
        return null;
    }

    public static String getFileNameByTemplateName(String templateName) {
        return '_' + templateName + ".gsp";
    }

    public static PsiMember toField(@Nullable PsiMethod getter) {
        return getter instanceof GrAccessorMethod ? ((GrAccessorMethod)getter).getProperty() : getter;
    }

    public static Map<String, PsiMethod> getControllerActions(@Nullable String controllerName, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsUtils", "getControllerActions"));
        }
        return GrailsUtils.getControllerActions(GrailsArtifact.CONTROLLER.getInstances(module, controllerName), module);
    }

    public static Map<String, PsiMethod> getControllerActions(Collection<? extends PsiClass> classes, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsUtils", "getControllerActions"));
        }
        GrailsStructure structure = GrailsStructure.getInstance(module);
        Boolean isGrails1_4 = structure == null || structure.isAtLeastGrails1_4();
        LinkedHashMap<String, PsiMethod> res = new LinkedHashMap<String, PsiMethod>();
        try {
            for (PsiMethod method : GrClassImplUtil.getAllMethods(classes)) {
                PsiMethod oldValue;
                String name = GrailsUtils.getActionName0((PsiElement)method, false, isGrails1_4);
                if (name == null || (oldValue = res.put(name, method)) == null) continue;
                res.put(name, oldValue);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return res;
    }

    public static Map<String, PsiMethod> collectClosureProperties(Collection<? extends PsiClass> classes) {
        if (classes.isEmpty()) {
            return Collections.emptyMap();
        }
        ClosurePropertiesProcessor processor = new ClosurePropertiesProcessor();
        for (PsiClass psiClass : classes) {
            psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass);
        }
        return processor.getResults();
    }

    @Nullable
    public static PsiMethod getClosureProperty(Collection<? extends PsiClass> classes, @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/grails/util/GrailsUtils", "getClosureProperty"));
        }
        if (classes.isEmpty()) {
            return null;
        }
        ClosureOnePropertyProcessor processor = new ClosureOnePropertyProcessor(propertyName);
        for (PsiClass psiClass : classes) {
            if (!psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass)) break;
        }
        return processor.getResult();
    }

    @Nullable
    public static VirtualFile getControllerDirByGsp(VirtualFile gspFile) {
        VirtualFile parent1 = gspFile.getParent();
        if (parent1 == null) {
            return null;
        }
        VirtualFile parent2 = parent1.getParent();
        if (parent2 == null) {
            return null;
        }
        VirtualFile parent3 = parent2.getParent();
        if (parent3 == null) {
            return null;
        }
        while (!GRAILS_APP_DIRECTORY.equals(parent3.getName()) || !VIEWS_DIRECTORY.equals(parent2.getName())) {
            parent1 = parent2;
            parent2 = parent3;
            if ((parent3 = parent3.getParent()) != null) continue;
            return null;
        }
        return parent1;
    }

    @Nullable
    public static String getExistingControllerNameDirByGsp(VirtualFile gspFile, Project project) {
        String controllerName = GrailsUtils.getControllerNameByGsp(gspFile);
        if (controllerName == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)gspFile, (Project)project);
        if (module != null && !GrailsArtifact.CONTROLLER.getInstances(module, controllerName).isEmpty()) {
            return controllerName;
        }
        return null;
    }

    @Nullable
    public static String getControllerNameByGsp(@NotNull VirtualFile gspFile) {
        if (gspFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspFile", "org/jetbrains/plugins/grails/util/GrailsUtils", "getControllerNameByGsp"));
        }
        VirtualFile controllerFolder = GrailsUtils.getControllerDirByGsp(gspFile);
        return controllerFolder == null ? null : controllerFolder.getName();
    }

    public static Object[] createPluginVariants(@NotNull Module module, boolean withVersion) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsUtils", "createPluginVariants"));
        }
        Collection<VirtualFile> roots = GrailsFramework.getInstance().getAllPluginRoots(module, false);
        Object[] res = new Object[roots.size()];
        int i = 0;
        for (VirtualFile root : roots) {
            String pluginName = GrailsUtils.extractGrailsPluginName(root);
            if (pluginName == null) continue;
            pluginName = withVersion ? root.getName() : GrailsNameUtils.getScriptName(pluginName);
            res[i++] = LookupElementBuilder.create((String)pluginName).withIcon(JetgroovyIcons.Mvc.Groovy_mvc_plugin);
        }
        return res;
    }

    public static boolean isControllerAction(@Nullable PsiElement element) {
        return GrailsUtils.getActionName(element) != null;
    }

    @Nullable
    public static String getActionName(@Nullable PsiElement element) {
        return GrailsUtils.getActionName0(element, true, null);
    }

    @Nullable
    private static String getActionName0(@Nullable PsiElement element, boolean needCheckArtifact, @Nullable Boolean isGrails1_4) {
        GrMember member;
        if (element instanceof GrAccessorMethod) {
            if (((GrAccessorMethod)element).isSetter()) {
                return null;
            }
            member = ((GrAccessorMethod)element).getProperty();
        } else {
            if (!(element instanceof GrMember)) {
                return null;
            }
            member = (GrMember)element;
        }
        if (needCheckArtifact && !GrailsArtifact.CONTROLLER.isInstance(member.getContainingClass())) {
            return null;
        }
        if (member.hasModifierProperty("static")) {
            return null;
        }
        if (member instanceof GrField) {
            GrField field = (GrField)member;
            if (!(field.getInitializerGroovy() instanceof GrClosableBlock)) {
                return null;
            }
            GrModifierList modifierList = field.getModifierList();
            if (modifierList == null || modifierList.hasExplicitVisibilityModifiers() && !member.hasModifierProperty("public")) {
                return null;
            }
            String fieldName = element instanceof GrAccessorMethod ? GroovyPropertyUtils.getPropertyNameByGetterName((String)((GrAccessorMethod)element).getName(), (boolean)false) : member.getName();
            if (fieldName != null && fieldName.endsWith("Flow") && fieldName.length() > "Flow".length() && WebFlowUtils.isWebFlowEnabled(GrailsStructure.getInstance((PsiElement)member))) {
                return fieldName.substring(0, fieldName.length() - "Flow".length());
            }
            return fieldName;
        }
        if (member instanceof GrMethod) {
            if (isGrails1_4 == null) {
                GrailsStructure structure = GrailsStructure.getInstance((PsiElement)member);
                isGrails1_4 = structure == null || structure.isAtLeastGrails1_4();
            }
            if (!isGrails1_4.booleanValue()) {
                return null;
            }
            if (!member.hasModifierProperty("public")) {
                return null;
            }
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static VirtualFile getControllerGspDir(@NotNull PsiClass controllerClass) {
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "getControllerGspDir"));
        }
        VirtualFile grailsApp = GrailsArtifact.CONTROLLER.getGrailsApp(controllerClass);
        if (grailsApp == null) {
            return null;
        }
        VirtualFile viewDirectory = grailsApp.findChild(VIEWS_DIRECTORY);
        if (viewDirectory == null) {
            return null;
        }
        String categoryName = GrailsArtifact.CONTROLLER.getArtifactName(controllerClass);
        return viewDirectory.findChild(categoryName);
    }

    @NotNull
    public static List<VirtualFile> getViewsByAction(@NotNull PsiElement action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewsByAction"));
        }
        String name = GrailsUtils.getActionName(action);
        if (name == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewsByAction"));
            }
            return list;
        }
        PsiClass aClass = ((GrMember)action).getContainingClass();
        assert (aClass != null);
        List<VirtualFile> list = GrailsUtils.getViewsByAction(aClass, name);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewsByAction"));
        }
        return list;
    }

    @NotNull
    public static List<PsiFile> getViewPsiByAction(@NotNull PsiElement action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewPsiByAction"));
        }
        List<VirtualFile> files = GrailsUtils.getViewsByAction(action);
        List list = ContainerUtil.mapNotNull(files, file -> {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/plugins/grails/util/GrailsUtils", "lambda$getViewPsiByAction$0"));
            }
            return action.getManager().findFile(file);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewPsiByAction"));
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> getViewsByAction(@NotNull PsiClass controllerClass, String actionName) {
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewsByAction"));
        }
        VirtualFile controllerViewFolder = GrailsUtils.getControllerGspDir(controllerClass);
        if (controllerViewFolder == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewsByAction"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)controllerViewFolder.findChild(actionName + ".gsp"));
        ContainerUtil.addIfNotNull((Collection)result, (Object)controllerViewFolder.findChild(actionName + ".gson"));
        ContainerUtil.addIfNotNull((Collection)result, (Object)controllerViewFolder.findChild(actionName + ".jsp"));
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsUtils", "getViewsByAction"));
        }
        return list;
    }

    public static boolean isBootStrapClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "isBootStrapClass"));
        }
        String className = aClass.getName();
        if (className == null || !className.endsWith("BootStrap")) {
            return false;
        }
        PsiFile psiFile = aClass.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile vfile = psiFile.getOriginalFile().getVirtualFile();
        if (vfile == null) {
            return false;
        }
        VirtualFile confDir = vfile.getParent();
        if (confDir == null || !confDir.getName().equals(CONF_DIRECTORY)) {
            return false;
        }
        VirtualFile grailsApp = confDir.getParent();
        return grailsApp != null && grailsApp.getName().equals(GRAILS_APP_DIRECTORY);
    }

    @Nullable
    public static TldDescriptor getTldDescriptor(@Nullable XmlFile xmlFile) {
        if (xmlFile == null) {
            return null;
        }
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return null;
        }
        PsiMetaData metaData = document.getMetaData();
        if (!(metaData instanceof TldDescriptor)) {
            return null;
        }
        return (TldDescriptor)metaData;
    }

    public static int getPluginDependenciesCrc(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsUtils", "getPluginDependenciesCrc"));
        }
        ArrayList<Integer> crcList = new ArrayList<Integer>();
        CRC32 crc = new CRC32();
        for (VirtualFile pluginRoot : GrailsFramework.getInstance().getCommonPluginRoots(module, false)) {
            VirtualFile dependenciesFile = pluginRoot.findChild("dependencies.groovy");
            if (dependenciesFile == null) continue;
            try {
                String fileText = VfsUtilCore.loadText((VirtualFile)dependenciesFile).trim();
                if (fileText.isEmpty()) continue;
                crc.reset();
                crc.update(fileText.getBytes(CharsetToolkit.UTF8_CHARSET));
                crcList.add((int)crc.getValue());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (crcList.isEmpty()) {
            return 0;
        }
        Collections.sort(crcList);
        return crcList.hashCode();
    }

    public static int getPluginsCrc(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsUtils", "getPluginsCrc"));
        }
        ArrayList<Integer> crcList = new ArrayList<Integer>();
        CRC32 crc = new CRC32();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            for (VirtualFile root : libraryOrderEntry.getFiles(OrderRootType.CLASSES)) {
                VirtualFile dependenciesFile = (VirtualFile)ContainerUtil.find((Object[])root.getChildren(), file -> !file.isDirectory() && StringUtil.equals((CharSequence)file.getExtension(), (CharSequence)"groovy") && file.getName().endsWith("GrailsPlugin.groovy"));
                if (dependenciesFile == null) continue;
                try {
                    String fileText = VfsUtilCore.loadText((VirtualFile)dependenciesFile).trim();
                    if (fileText.isEmpty()) continue;
                    crc.reset();
                    crc.update(fileText.getBytes(CharsetToolkit.UTF8_CHARSET));
                    crcList.add((int)crc.getValue());
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if (crcList.isEmpty()) {
            return 0;
        }
        Collections.sort(crcList);
        return crcList.hashCode();
    }

    @Nullable
    public static GrClosableBlock getClosureArgument(@NotNull GrMethodCall callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/grails/util/GrailsUtils", "getClosureArgument"));
        }
        GrArgumentList argumentList = callExpression.getArgumentList();
        GroovyPsiElement[] allArguments = argumentList.getAllArguments();
        if (allArguments.length == 0) {
            GrClosableBlock[] closureArguments = callExpression.getClosureArguments();
            if (closureArguments.length == 1) {
                return closureArguments[0];
            }
        } else if (allArguments.length == 1 && allArguments[0] instanceof GrClosableBlock) {
            return (GrClosableBlock)allArguments[0];
        }
        return null;
    }

    public static boolean isGrailsPluginClass(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        String className = aClass.getName();
        if (className == null || !className.endsWith("GrailsPlugin")) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        return qname != null && (!qname.contains(".") || qname.startsWith("org.codehaus.groovy.grails.plugins."));
    }

    public static <K, V> Map<K, V> createMap(Object ... data) {
        int length = data.length;
        assert ((length & 1) == 0);
        if (length == 0) {
            return Collections.emptyMap();
        }
        if (length == 2) {
            return Collections.singletonMap(data[0], data[1]);
        }
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        for (int i = 0; i < length; i += 2) {
            res.put(data[i], data[i + 1]);
        }
        return res;
    }

    public static <K, V> Map<K, V> createEnumMap(Object ... data) {
        int length = data.length;
        assert ((length & 1) == 0);
        if (length == 0) {
            return Collections.emptyMap();
        }
        if (length == 2) {
            return Collections.singletonMap(data[0], data[1]);
        }
        EnumMap res = new EnumMap(data[0].getClass());
        for (int i = 0; i < length; i += 2) {
            res.put(data[i], data[i + 1]);
        }
        return res;
    }

    public static boolean isValidatedClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "isValidatedClass"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "lambda$isValidatedClass$2"));
            }
            boolean value = GrailsUtils.isCommandClass(aClass) || TypesUtil.isAnnotatedCheckHierarchyWithCache((PsiClass)aClass, (String)"org.codehaus.groovy.grails.validation.Validateable") || TypesUtil.isAnnotatedCheckHierarchyWithCache((PsiClass)aClass, (String)"grails.validation.Validateable");
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean isCommandClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "isCommandClass"));
        }
        String name = aClass.getName();
        if (name == null || !name.endsWith("Command")) {
            return false;
        }
        PsiFile file = aClass.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().getSourceRootForFile(virtualFile);
        if (sourceRoot == null || !sourceRoot.getName().equals("controllers")) {
            return false;
        }
        VirtualFile appRoot = sourceRoot.getParent();
        return appRoot != null && appRoot.getName().equals(GRAILS_APP_DIRECTORY);
    }

    @Nullable
    public static GrailsArtifact calculateArtifactByAnnotation(@NotNull PsiClass aClass) {
        PsiAnnotation annotation;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "calculateArtifactByAnnotation"));
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null && (annotation = modifierList.findAnnotation("grails.artefact.Artefact")) != null) {
            String s2 = GrAnnotationUtil.inferStringAttribute((PsiAnnotation)annotation, (String)"value");
            if ("TagLibrary".equals(s2)) {
                return GrailsArtifact.TAGLIB;
            }
            if ("Controller".equals(s2)) {
                return GrailsArtifact.CONTROLLER;
            }
            if ("Domain".equals(s2)) {
                return GrailsArtifact.DOMAIN;
            }
        }
        return null;
    }

    @Nullable
    public static GrailsArtifact calculateArtifactType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsUtils", "calculateArtifactType"));
        }
        GrailsArtifact res = GrailsArtifact.getType(aClass);
        if (res != null) {
            return res;
        }
        if (GormUtils.isStandaloneGormBean(aClass)) {
            return GrailsArtifact.DOMAIN;
        }
        return GrailsUtils.calculateArtifactByAnnotation(aClass);
    }

    @Nullable
    public static File findLatestJarInIvyRepository(String artifactFolderPath, String jarPrefix) {
        File[] files;
        File jarDirectory = new File(artifactFolderPath, "jars");
        if (!jarDirectory.exists()) {
            File artifactFolderFile = new File(artifactFolderPath);
            Object[] versions = artifactFolderFile.list();
            if (versions == null || versions.length == 0) {
                return null;
            }
            Arrays.sort(versions);
            jarDirectory = new File(artifactFolderFile, (String)versions[versions.length - 1] + "/jar");
        }
        if ((files = jarDirectory.listFiles()) == null) {
            return null;
        }
        File res = null;
        for (File file : files) {
            String name = file.getName();
            if (!name.startsWith(jarPrefix) || !name.endsWith(".jar") || res != null && name.compareTo(res.getName()) <= 0) continue;
            res = file;
        }
        return res;
    }

    public static void addSystemPropertyIfNotExists(ParametersList parametersList, @NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/plugins/grails/util/GrailsUtils", "addSystemPropertyIfNotExists"));
        }
        int idx = property.indexOf(61);
        assert (idx > 0);
        String leftPart = property.substring(0, idx + 1);
        for (String param : parametersList.getParameters()) {
            if (param == null || !param.startsWith(leftPart)) continue;
            return;
        }
        parametersList.add(property);
    }

    private static boolean isAlreadyInsideEnvironmentDefinition(GrReferenceExpression ref) {
        PsiElement parent = ref.getParent();
        if (parent instanceof GrMethodCall) {
            parent = parent.getParent();
        }
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)parent, GrMethodCall.class);
        while (call != null) {
            GrExpression[] arguments;
            String methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)call);
            if (ENVIRONMENTS.equals(methodName) && (arguments = PsiUtil.getAllArguments((GrCall)call)).length == 1 && arguments[0] instanceof GrClosableBlock) {
                return true;
            }
            call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)call, GrMethodCall.class);
        }
        return false;
    }

    public static boolean processEnvironmentDefinition(PsiScopeProcessor processor, GrReferenceExpression ref) {
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (nameHint == null || nameHint.equals(ENVIRONMENTS)) {
            ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
            if (!ResolveUtil.shouldProcessMethods((ElementClassHint)classHint)) {
                return true;
            }
            if (ref.isQualified()) {
                return true;
            }
            if (GrailsUtils.isAlreadyInsideEnvironmentDefinition(ref)) {
                return true;
            }
            GrLightMethodBuilder envMethod = new GrLightMethodBuilder(ref.getManager(), ENVIRONMENTS);
            envMethod.setMethodKind((Object)ENVIRONMENTS_METHOD_KIND);
            envMethod.addParameter("closure", "groovy.lang.Closure", false);
            return processor.execute((PsiElement)envMethod, ResolveState.initial());
        }
        return true;
    }

    @Nullable
    public static PsiClass findApplicationClass(final Module module) {
        final Project project = module.getProject();
        return (PsiClass)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<PsiClass>(){
            private final PsiShortNamesCache myNamesCache;
            {
                this.myNamesCache = PsiShortNamesCache.getInstance((Project)project);
            }

            @Nullable
            public CachedValueProvider.Result<PsiClass> compute() {
                return CachedValueProvider.Result.create((Object)this.doCompute(), (Object[])new Object[]{ModuleManager.getInstance((Project)project), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }

            private PsiClass doCompute() {
                PsiClass[] classes;
                for (PsiClass clazz : classes = this.myNamesCache.getClassesByName("Application", module.getModuleScope())) {
                    if (!PsiClassUtil.isRunnableClass((PsiClass)clazz, (boolean)true) || !InheritanceUtil.isInheritor((PsiClass)clazz, (String)"grails.boot.config.GrailsAutoConfiguration")) continue;
                    return clazz;
                }
                return null;
            }
        });
    }

    public static class ClosureOnePropertyProcessor
    extends BaseScopeProcessor
    implements ElementClassHint,
    NameHint {
        private final String myGetterName;
        private final String myPropertyName;
        private PsiMethod result;

        public ClosureOnePropertyProcessor(@NotNull String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosureOnePropertyProcessor", "<init>"));
            }
            this.myGetterName = GroovyPropertyUtils.getGetterNameNonBoolean((String)propertyName);
            this.myPropertyName = propertyName;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosureOnePropertyProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosureOnePropertyProcessor", "execute"));
            }
            if (element instanceof PsiMethod && PsiUtil.isClosurePropertyGetter((PsiMethod)(method = (PsiMethod)element)) && this.myPropertyName.equals(GroovyPropertyUtils.getPropertyNameByGetterName((String)method.getName(), (boolean)false))) {
                this.result = method;
                return false;
            }
            return true;
        }

        public PsiMethod getResult() {
            return this.result;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosureOnePropertyProcessor", "getHint"));
            }
            if (hintKey == NameHint.KEY || hintKey == ElementClassHint.KEY) {
                return (T)((Object)this);
            }
            return null;
        }

        public boolean shouldProcess(ElementClassHint.DeclarationKind resolveKind) {
            return resolveKind == ElementClassHint.DeclarationKind.METHOD;
        }

        public String getName(@NotNull ResolveState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosureOnePropertyProcessor", "getName"));
            }
            return this.myGetterName;
        }
    }

    public static class ClosurePropertiesProcessor
    extends BaseScopeProcessor
    implements ElementClassHint {
        private Map<String, PsiMethod> results;

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosurePropertiesProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosurePropertiesProcessor", "execute"));
            }
            if (element instanceof PsiMethod && PsiUtil.isClosurePropertyGetter((PsiMethod)(method = (PsiMethod)element))) {
                String name;
                PsiMethod oldValue;
                if (this.results == null) {
                    this.results = new HashMap<String, PsiMethod>();
                }
                if ((oldValue = this.results.put(name = GroovyPropertyUtils.getPropertyNameByGetterName((String)method.getName(), (boolean)false), method)) != null) {
                    this.results.put(name, oldValue);
                }
            }
            return true;
        }

        public Map<String, PsiMethod> getResults() {
            return this.results == null ? Collections.emptyMap() : this.results;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/plugins/grails/util/GrailsUtils$ClosurePropertiesProcessor", "getHint"));
            }
            if (hintKey == ElementClassHint.KEY) {
                return (T)((Object)this);
            }
            return null;
        }

        public boolean shouldProcess(ElementClassHint.DeclarationKind resolveKind) {
            return resolveKind == ElementClassHint.DeclarationKind.METHOD;
        }
    }
}

