/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;

public class MvcPluginUtil {
    private static final Logger LOG = Logger.getInstance(MvcPluginUtil.class);
    private static final String SET_PROXY_COMMAND = "set-proxy";
    private static final String ENTER_HTTP_PROXY_HOST = "Enter HTTP proxy host";
    private static final String ENTER_HTTP_PROXY_PORT = "Enter HTTP proxy port";
    private static final String ENTER_HTTP_PROXY_USERNAME = "Enter HTTP proxy username";
    private static final String ENTER_HTTP_PROXY_PASSWORD = "Enter HTTP proxy password";
    public static final Color COLOR_REMOVE_PLUGIN = FileStatus.DELETED_FROM_FS.getColor();
    public static final Color COLOR_INSTALL_PLUGIN = FileStatus.ADDED.getColor();
    @NonNls
    public static final String LIST_PLUGINS_COMMAND = "list-plugins";
    private static final Key<Pair<Collection<MvcPluginDescriptor>, Long>> PLUGIN_DESCRIPTOR_KEY = Key.create((String)"MVC_PLUGIN_DESCRIPTOR_KEY");
    public static final Key<Boolean> PLUGIN_LIST_DONOT_DOWNLOADED = Key.create((String)"PLUGIN_LIST_DONOT_DOWNLOADED");

    private MvcPluginUtil() {
    }

    private static void setProxyOld(final @NotNull HttpConfigurable cfg, @NotNull OldGrailsApplication application) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "setProxyOld"));
        }
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "setProxyOld"));
        }
        try {
            GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
            if (!(executor instanceof GrailsCommandLineExecutor)) {
                return;
            }
            GeneralCommandLine commandLine = ((GrailsCommandLineExecutor)executor).createCommandLine(application, new MvcCommand(SET_PROXY_COMMAND, new String[0]));
            OSProcessHandler handler = new OSProcessHandler(commandLine);
            GrailsConsole.getInstance(application.getProject()).getConsole().attachToProcess((ProcessHandler)handler);
            final OutputStreamWriter writer = new OutputStreamWriter(handler.getProcess().getOutputStream());
            writer.write(cfg.USE_HTTP_PROXY ? "y\n" : "n\n");
            writer.flush();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    String text = event.getText();
                    try {
                        if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_HOST)) {
                            writer.append(cfg.PROXY_HOST).append('\n');
                        } else if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_PORT)) {
                            writer.write(cfg.PROXY_PORT);
                            writer.write(10);
                        } else if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_USERNAME)) {
                            writer.append(cfg.getProxyLogin()).append('\n');
                        } else if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_PASSWORD)) {
                            writer.append(cfg.getPlainProxyPassword()).append('\n');
                        }
                        writer.flush();
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            });
            handler.startNotify();
        }
        catch (Exception e) {
            GrailsConsole.NOTIFICATION_GROUP.createNotification("Process to set proxy cannot start", e.getMessage(), NotificationType.ERROR, null);
            LOG.debug((Throwable)e);
        }
    }

    private static void setProxyNew(@NotNull HttpConfigurable cfg, @NotNull OldGrailsApplication application) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "setProxyNew"));
        }
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "setProxyNew"));
        }
        if (cfg.USE_HTTP_PROXY) {
            MvcCommand command = new MvcCommand("add-proxy", new String[]{"IDEA_PROXY", "--host=" + cfg.PROXY_HOST, "--port=" + cfg.PROXY_PORT, "--username=" + cfg.getProxyLogin(), "--password=" + cfg.getPlainProxyPassword()});
            GrailsCommandExecutorUtil.executeInModal(application, command, "Execute 'add-proxy' command", () -> {
                if (application == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "lambda$setProxyNew$0"));
                }
                GrailsCommandExecutorUtil.executeInModal(application, new MvcCommand(SET_PROXY_COMMAND, new String[]{"IDEA_PROXY"}), "Execute 'set-proxy' command", null, false);
            }, false);
        } else {
            GrailsCommandExecutorUtil.executeInModal(application, new MvcCommand("clear-proxy", new String[0]), "Execute 'clear-proxy' command", null, false);
        }
    }

    public static void setFrameworkProxy(@NotNull HttpConfigurable cfg, @NotNull OldGrailsApplication application) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "setFrameworkProxy"));
        }
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "setFrameworkProxy"));
        }
        assert (!GrailsConsole.getInstance(application.getProject()).isExecuting());
        if (application.getVersion().isAtLeast("1.3.2")) {
            MvcPluginUtil.setProxyNew(cfg, application);
        } else {
            MvcPluginUtil.setProxyOld(cfg, application);
        }
    }

    public static String cleanPath(String path) {
        String pluginFilePath = path;
        if (path.endsWith("!/")) {
            pluginFilePath = path.substring(0, path.length() - "!/".length());
        } else if (path.endsWith("!")) {
            pluginFilePath = path.substring(0, path.length() - "!".length());
        }
        return pluginFilePath;
    }

    @NotNull
    public static List<MvcPluginDescriptor> refreshAndLoadPluginList(@NotNull OldGrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "refreshAndLoadPluginList"));
        }
        VirtualFile sdkWorkDir = MvcModuleStructureUtil.refreshAndFind((File)GrailsFramework.getInstance().getSdkWorkDir(application.getModule()));
        ArrayList<MvcPluginDescriptor> res = new ArrayList<MvcPluginDescriptor>();
        if (sdkWorkDir == null) {
            LOG.warn("Grails/Griffon work directory not found.");
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "refreshAndLoadPluginList"));
            }
            return list;
        }
        if (!sdkWorkDir.isDirectory()) {
            LOG.warn("Failed to load plugin list: Grails/Griffon work directory is not a directory (" + sdkWorkDir.getPath() + ')');
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "refreshAndLoadPluginList"));
            }
            return list;
        }
        sdkWorkDir.refresh(false, false);
        boolean pluginListExists = false;
        for (VirtualFile file : sdkWorkDir.getChildren()) {
            if (!MvcPluginUtil.isPluginListFile(file)) continue;
            res.addAll(MvcPluginUtil.getPluginList(file));
            pluginListExists = true;
        }
        PLUGIN_LIST_DONOT_DOWNLOADED.set((UserDataHolder)application, (Object)(pluginListExists ? null : Boolean.valueOf(true)));
        ArrayList<MvcPluginDescriptor> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "refreshAndLoadPluginList"));
        }
        return arrayList;
    }

    private static boolean isPluginListFile(VirtualFile file) {
        return !file.isDirectory() && file.getName().startsWith("plugins-list") && file.getName().endsWith(".xml");
    }

    @NotNull
    public static List<MvcPluginDescriptor> loadPluginList(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "loadPluginList"));
        }
        MvcFramework framework = MvcFramework.getInstance((Module)module);
        if (framework == null) {
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "loadPluginList"));
            }
            return list;
        }
        VirtualFile sdkWorkDir = LocalFileSystem.getInstance().findFileByIoFile(framework.getSdkWorkDir(module));
        if (sdkWorkDir == null || !sdkWorkDir.isDirectory()) {
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "loadPluginList"));
            }
            return list;
        }
        ArrayList<MvcPluginDescriptor> res = new ArrayList<MvcPluginDescriptor>();
        sdkWorkDir.refresh(true, false);
        for (VirtualFile file : sdkWorkDir.getChildren()) {
            if (!MvcPluginUtil.isPluginListFile(file)) continue;
            res.addAll(MvcPluginUtil.getPluginList(file));
        }
        ArrayList<MvcPluginDescriptor> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "loadPluginList"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<MvcPluginDescriptor> parsePluginList(VirtualFile file) {
        ArrayList<MvcPluginDescriptor> res = new ArrayList<MvcPluginDescriptor>();
        InputStream in = null;
        try {
            in = file.getInputStream();
            Document document = new SAXBuilder().build(in);
            Element root = document.getRootElement();
            for (Element pluginElement : root.getChildren("plugin")) {
                MvcPluginDescriptor.Release latestRelease;
                MvcPluginDescriptor plugin;
                block17: {
                    String latestVersion;
                    block16: {
                        String name = pluginElement.getAttributeValue("name");
                        plugin = new MvcPluginDescriptor(name);
                        if (!StringUtil.isNotEmpty((String)name)) continue;
                        latestVersion = pluginElement.getAttributeValue("latest-release");
                        for (Element releaseElement : pluginElement.getChildren("release")) {
                            MvcPluginDescriptor.Release release = new MvcPluginDescriptor.Release(plugin, releaseElement.getAttributeValue("version"), releaseElement.getAttributeValue("type"), releaseElement.getChildTextTrim("title"), releaseElement.getChildTextTrim("author"), releaseElement.getChildTextTrim("description"), releaseElement.getChildTextTrim("authorEmail"), releaseElement.getChildTextTrim("file"), releaseElement.getChildTextTrim("documentation"));
                            plugin.getReleases().add(release);
                        }
                        latestRelease = null;
                        if (!StringUtil.isEmpty((String)latestVersion)) break block16;
                        if (plugin.getReleases().size() <= 0) break block17;
                        latestRelease = plugin.getReleases().get(plugin.getReleases().size() - 1);
                        break block17;
                    }
                    for (MvcPluginDescriptor.Release release : plugin.getReleases()) {
                        if (!latestVersion.equals(release.getVersion())) continue;
                        latestRelease = release;
                        break;
                    }
                }
                plugin.setLastRelease(latestRelease);
                res.add(plugin);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to read plugins file:" + file.getPath(), (Throwable)e);
            Notifications.Bus.notify((Notification)new Notification("grails", "Failed to load plugin list", "Failed to parse " + file.getPath(), NotificationType.ERROR));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return res;
    }

    public static Collection<MvcPluginDescriptor> getPluginList(VirtualFile file) {
        Pair cachedValue = (Pair)file.getUserData(PLUGIN_DESCRIPTOR_KEY);
        if (cachedValue == null || ((Long)cachedValue.second).longValue() != file.getModificationCount()) {
            Collection<MvcPluginDescriptor> res = MvcPluginUtil.parsePluginList(file);
            cachedValue = Pair.create(res, (Object)file.getModificationCount());
            file.putUserData(PLUGIN_DESCRIPTOR_KEY, (Object)cachedValue);
        }
        return (Collection)cachedValue.first;
    }

    @Nullable
    public static MvcPluginDescriptor parsePluginXml(VirtualFile file) {
        try {
            return MvcPluginUtil.parsePluginXml(file.getInputStream());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static MvcPluginDescriptor parsePluginXml(InputStream inputStream) throws IOException {
        Element root;
        try {
            Document document = new SAXBuilder().build(inputStream);
            root = document.getRootElement();
        }
        catch (JDOMException e) {
            return null;
        }
        String name = root.getAttributeValue("name");
        if (StringUtil.isEmpty((String)name)) {
            throw new IOException("Name of plugin cannot be null.");
        }
        String version = root.getAttributeValue("version");
        MvcPluginDescriptor mvcPlugin = new MvcPluginDescriptor(name);
        MvcPluginDescriptor.Release release = new MvcPluginDescriptor.Release(mvcPlugin, version, "", root.getChildTextTrim("title"), root.getChildTextTrim("author"), root.getChildTextTrim("description"), root.getChildTextTrim("authorEmail"), root.getChildTextTrim("file"), root.getChildTextTrim("documentation"));
        mvcPlugin.getReleases().add(release);
        mvcPlugin.setLastRelease(release);
        return mvcPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static MvcPluginDescriptor extractPluginInfo(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "extractPluginInfo"));
        }
        try (ZipFile zipFile = new ZipFile(path);){
            ZipEntry entry = zipFile.getEntry("plugin.xml");
            if (entry == null) return null;
            MvcPluginDescriptor mvcPluginDescriptor = MvcPluginUtil.parsePluginXml(zipFile.getInputStream(entry));
            return mvcPluginDescriptor;
        }
        catch (IOException e) {
            LOG.error(path, (Throwable)e);
        }
        return null;
    }

    public static Map<String, String> getInstalledPluginVersions(@NotNull PropertiesFile applicationProperties) {
        if (applicationProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationProperties", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil", "getInstalledPluginVersions"));
        }
        HashMap<String, String> pluginNames = new HashMap<String, String>();
        for (IProperty property : applicationProperties.getProperties()) {
            String propName = property.getName();
            if (propName == null || !(propName = propName.trim()).startsWith("plugins.")) continue;
            String pluginName = propName.substring("plugins.".length());
            String pluginVersion = property.getValue();
            if (pluginName.length() <= 0 || pluginVersion == null || (pluginVersion = pluginVersion.trim()).length() <= 0) continue;
            pluginNames.put(pluginName, pluginVersion);
        }
        return pluginNames;
    }
}

