/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCSSReferenceContributor;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxUnresolvedStyleClassReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlFile(XmlFile file) {
                if (!JavaFxFileTypeFactory.isFxml((PsiFile)file)) {
                    return;
                }
                super.visitXmlFile(file);
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlTag parentTag;
                XmlTag xmlTag;
                String attributeName = attribute.getName();
                if ("styleClass".equals(attributeName)) {
                    this.checkStyleAttribute(attribute);
                } else if ("fx:value".equals(attributeName) && (xmlTag = attribute.getParent()) != null && (parentTag = xmlTag.getParentTag()) != null && "styleClass".equals(parentTag.getName())) {
                    this.checkStyleAttribute(attribute);
                }
            }

            private void checkStyleAttribute(XmlAttribute attribute) {
                XmlAttributeValue valueElement = attribute.getValueElement();
                if (valueElement != null) {
                    PsiReference[] references;
                    for (PsiReference reference : references = valueElement.getReferences()) {
                        LocalQuickFix[] localQuickFixArray;
                        if (!(reference instanceof JavaFxCSSReferenceContributor.JavaFxCssReference) || ((JavaFxCSSReferenceContributor.JavaFxCssReference)reference).multiResolve(false).length != 0) continue;
                        Collection<VirtualFile> files = ((JavaFxCSSReferenceContributor.JavaFxCssReference)reference).getCssFiles();
                        PsiElement psiElement = reference.getElement();
                        TextRange textRange = reference.getRangeInElement();
                        if (files.isEmpty() || !holder.isOnTheFly()) {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        } else {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = new JavaFxCreateStyleClassFromUsageFix(reference.getCanonicalText());
                        }
                        holder.registerProblem(psiElement, textRange, "Unresolved style class", localQuickFixArray);
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static class JavaFxCreateStyleClassFromUsageFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxCreateStyleClassFromUsageFix.class.getName()));
        private final String myRefName;

        public JavaFxCreateStyleClassFromUsageFix(String refName) {
            this.myRefName = refName;
        }

        @NotNull
        public String getName() {
            String string = "Create '" + this.myRefName + "' styleClass";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Create styleClass" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix", "getFamilyName"));
            }
            return "Create styleClass";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement == null) {
                return;
            }
            PsiReference reference = psiElement.getReference();
            if (!(reference instanceof JavaFxCSSReferenceContributor.JavaFxCssReference)) {
                return;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (virtualFile == null) {
                return;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
            Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
            Runnable runnable = () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix", "lambda$applyFix$2"));
                }
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                Collection<VirtualFile> files = ((JavaFxCSSReferenceContributor.JavaFxCssReference)reference).getCssFiles();
                if (files.size() == 1) {
                    this.createClassInFile(project, psiManager.findFile(files.iterator().next()));
                } else {
                    Object[] psiFiles = (PsiFile[])ContainerUtil.map2Array(files, PsiFile.class, file -> psiManager.findFile(file));
                    JBList list = new JBList(psiFiles);
                    int width = WindowManagerEx.getInstanceEx().getFrame((Project)project).getSize().width;
                    list.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
                    JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Target for StyleClass").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix", "lambda$null$1"));
                        }
                        this.createClassInFile(project, (PsiFile)list.getSelectedValue());
                    }).createPopup();
                    if (editor != null) {
                        popup.showInBestPositionFor(editor);
                    } else {
                        popup.showCenteredInCurrentWindow(project);
                    }
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        }

        private void createClassInFile(final Project project, final PsiFile psiFile) {
            if (psiFile instanceof CssFile) {
                if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                    return;
                }
                IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                String styleClassText = "." + this.myRefName + "{}";
                CssFile fileWithStyleClass = (CssFile)PsiFileFactory.getInstance((Project)project).createFileFromText("javafx.dummy.css", (Language)CSSLanguage.INSTANCE, (CharSequence)styleClassText);
                CssStylesheet stylesheet = fileWithStyleClass.getStylesheet();
                LOG.assertTrue(stylesheet != null);
                final CssRuleset[] rulesets = stylesheet.getRulesetList().getRulesets();
                LOG.assertTrue(rulesets.length == 1);
                RunResult runResult = new WriteCommandAction<SmartPsiElementPointer<PsiElement>>(project, this.getName(), new PsiFile[]{psiFile}){

                    protected void run(@NotNull Result<SmartPsiElementPointer<PsiElement>> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix$1", "run"));
                        }
                        PsiElement element = psiFile.add((PsiElement)rulesets[0]);
                        result.setResult((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element));
                    }
                }.execute();
                SmartPsiElementPointer newStyleClass = (SmartPsiElementPointer)runResult.getResultObject();
                PsiElement element = newStyleClass.getElement();
                if (element != null) {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)element);
                }
            }
        }
    }
}

