/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.converters;

import com.intellij.psi.PsiType;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamProperty;
import com.intellij.seam.model.xml.components.SeamValue;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamPropertyValueConverter
extends WrappingConverter {
    @Nullable
    public Converter getConverter(@NotNull GenericDomValue element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/seam/model/converters/SeamPropertyValueConverter", "getConverter"));
        }
        String stringValue = element.getStringValue();
        if (stringValue != null && SeamCommonUtils.isElText(stringValue)) {
            return null;
        }
        PsiType type = SeamPropertyValueConverter.getValueType(element);
        if (type == null) {
            return null;
        }
        GenericDomValueConvertersRegistry registry = SeamDomModelManager.getInstance(element.getManager().getProject()).getValueConvertersRegistry();
        return registry.getConverter(element, type);
    }

    @Nullable
    public static PsiType getValueType(GenericDomValue element) {
        SeamProperty seamProperty;
        if (element instanceof SeamValue && (seamProperty = (SeamProperty)element.getParentOfType(SeamProperty.class, false)) != null) {
            return seamProperty.getPropertyType();
        }
        return null;
    }
}

