/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class FileReferenceSetHelper {
    private FileReferenceSetHelper() {
    }

    public static FileReferenceSet createRestrictedByFileType(PsiElement psiElement, final FileType allowedFileType) {
        return new FileReferenceSet(psiElement){

            protected boolean isSoft() {
                return true;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return psiFileSystemItem -> {
                    if (psiFileSystemItem instanceof PsiDirectory || psiFileSystemItem instanceof WebDirectoryElement) {
                        return true;
                    }
                    VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();
                    return virtualFile != null && virtualFile.getFileType().equals(allowedFileType);
                };
            }
        };
    }

    public static void addWebDirectoryAndCurrentNamespaceAsRoots(PsiElement psiElement, String namespace, WebFacet webFacet, FileReferenceSet set) {
        WebDirectoryUtil directoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)psiElement.getProject());
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
            ArrayList basePathRoots = new ArrayList();
            List webRoots = webFacet.getWebRoots(true);
            for (WebRoot webRoot : webRoots) {
                String webRootPath = webRoot.getRelativePath();
                WebDirectoryElement webRootBase = directoryUtil.findWebDirectoryElementByPath(webRootPath, webFacet);
                ContainerUtil.addIfNotNull((Object)webRootBase, basePathRoots);
            }
            if (!Comparing.equal((String)namespace, (String)"/")) {
                WebDirectoryElement packageBase = directoryUtil.findWebDirectoryElementByPath(namespace, webFacet);
                ContainerUtil.addIfNotNull((Object)packageBase, basePathRoots);
            }
            return basePathRoots;
        });
    }
}

